/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JCastOperation
extends JExpression {
    private JType castType;
    private JExpression expr;

    public JCastOperation(SourceInfo info, JType castType, JExpression expr) {
        super(info);
        this.castType = castType;
        this.expr = expr;
    }

    public JType getCastType() {
        return this.castType;
    }

    public JExpression getExpr() {
        return this.expr;
    }

    @Override
    public JType getType() {
        if (!this.expr.getType().canBeNull() && !this.castType.isNullType()) {
            return this.castType.strengthenToNonNull();
        }
        return this.castType;
    }

    @Override
    public boolean hasSideEffects() {
        if (this.castType.isPrimitiveType()) {
            return this.expr.hasSideEffects();
        }
        return true;
    }

    public void resolve(JType newType) {
        assert (newType.replaces(this.castType));
        this.castType = newType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.expr = visitor.accept(this.expr);
        }
        visitor.endVisit(this, ctx);
    }
}

