/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JCaseStatement
extends JStatement {
    private final List<JExpression> exprs;

    public JCaseStatement(SourceInfo info, JExpression expr) {
        super(info);
        this.exprs = Lists.newArrayList(expr);
    }

    public JCaseStatement(SourceInfo info, Collection<JExpression> exprs) {
        super(info);
        this.exprs = Lists.newArrayList(exprs);
    }

    public boolean isDefault() {
        return this.exprs.isEmpty();
    }

    public List<JExpression> getExprs() {
        return Collections.unmodifiableList(this.exprs);
    }

    public JBinaryOperation convertToCompareExpression(JExpression value) {
        if (this.isDefault()) {
            throw new IllegalStateException("Can't replace a default statement with a comparison");
        }
        JBinaryOperation compareOperation = null;
        for (JExpression expr : this.getExprs()) {
            JBinaryOperation caseComparison = new JBinaryOperation(this.getSourceInfo(), JPrimitiveType.BOOLEAN, JBinaryOperator.EQ, value, expr);
            if (compareOperation == null) {
                compareOperation = caseComparison;
                continue;
            }
            compareOperation = new JBinaryOperation(this.getSourceInfo(), JPrimitiveType.BOOLEAN, JBinaryOperator.OR, compareOperation, caseComparison);
        }
        assert (compareOperation != null) : this;
        return compareOperation;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            visitor.accept(this.exprs);
        }
        visitor.endVisit(this, ctx);
    }
}

