/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JBooleanLiteral
extends JValueLiteral {
    public static final JBooleanLiteral FALSE = new JBooleanLiteral(SourceOrigin.UNKNOWN, false);
    public static final JBooleanLiteral TRUE = new JBooleanLiteral(SourceOrigin.UNKNOWN, true);
    private final boolean value;

    public static JBooleanLiteral get(boolean value) {
        return value ? TRUE : FALSE;
    }

    private JBooleanLiteral(SourceInfo sourceInfo, boolean value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public Object getValueObj() {
        return this.value;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }

    private Object readResolve() {
        return JBooleanLiteral.get(this.value);
    }
}

