/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JBlock
extends JStatement {
    private final List<JStatement> statements = new ArrayList<JStatement>();

    public JBlock(SourceInfo info, JStatement ... statements) {
        super(info);
        this.statements.addAll(Arrays.asList(statements));
    }

    public void addStmt(int index, JStatement toAdd) {
        this.statements.add(index, toAdd);
    }

    public void addStmt(JStatement toAdd) {
        this.statements.add(toAdd);
    }

    public void addStmts(int index, List<JStatement> toAdd) {
        this.statements.addAll(index, toAdd);
    }

    public void addStmts(List<JStatement> toAdd) {
        this.statements.addAll(toAdd);
    }

    public void clear() {
        this.statements.clear();
    }

    public List<JStatement> getStatements() {
        return this.statements;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public void removeStmt(int index) {
        this.statements.remove(index);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            visitor.acceptWithInsertRemove(this.statements);
        }
        visitor.endVisit(this, ctx);
    }

    @Override
    public boolean unconditionalControlBreak() {
        for (JStatement stmt : this.statements) {
            if (!stmt.unconditionalControlBreak()) continue;
            return true;
        }
        return false;
    }
}

