/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JBinaryOperation
extends JExpression {
    private JExpression lhs;
    private final JBinaryOperator op;
    private JExpression rhs;
    private JType type;

    public JBinaryOperation(SourceInfo info, JType type, JBinaryOperator op, JExpression lhs, JExpression rhs) {
        super(info);
        this.op = op;
        this.type = type;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public JExpression getLhs() {
        return this.lhs;
    }

    public JBinaryOperator getOp() {
        return this.op;
    }

    public JExpression getRhs() {
        return this.rhs;
    }

    @Override
    public JType getType() {
        JType resultType = this.type;
        if (this.isAssignment()) {
            resultType = this.getLhs().getType();
        }
        if (this.op != JBinaryOperator.ASG && !resultType.isNullType() && resultType instanceof JReferenceType) {
            resultType = ((JReferenceType)resultType).strengthenToNonNull().strengthenToExact();
        }
        return resultType;
    }

    @Override
    public boolean hasSideEffects() {
        return this.op.isAssignment() || this.getLhs().hasSideEffects() || this.getRhs().hasSideEffects();
    }

    public boolean isAssignment() {
        return this.op.isAssignment();
    }

    public void setType(JType newType) {
        this.type = newType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.lhs = this.isAssignment() ? visitor.acceptLvalue(this.lhs) : visitor.accept(this.lhs);
            this.rhs = visitor.accept(this.rhs);
        }
        visitor.endVisit(this, ctx);
    }
}

