/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JArrayType
extends JReferenceType {
    private transient int dims = 0;
    private final JType elementType;
    private transient JType leafType = null;

    public JArrayType(JType elementType) {
        super(elementType.getSourceInfo().makeChild(SourceOrigin.UNKNOWN), elementType.getName() + "[]");
        assert (elementType == elementType.getUnderlyingType());
        this.elementType = elementType;
    }

    public int getDims() {
        if (this.dims == 0) {
            this.dims = 1;
            if (this.elementType instanceof JArrayType) {
                this.dims += ((JArrayType)this.elementType).getDims();
            }
        }
        return this.dims;
    }

    public JType getElementType() {
        return this.elementType;
    }

    @Override
    public String getJavahSignatureName() {
        return "_3" + this.elementType.getJavahSignatureName();
    }

    @Override
    public String getJsniSignatureName() {
        return "[" + this.elementType.getJsniSignatureName();
    }

    @Override
    public JEnumType isEnumOrSubclass() {
        return null;
    }

    public JType getLeafType() {
        if (this.leafType == null) {
            this.leafType = this.elementType instanceof JArrayType ? ((JArrayType)this.elementType).getLeafType() : this.elementType;
        }
        return this.leafType;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return this.elementType.isExternal();
    }

    @Override
    public boolean isFinal() {
        return this.elementType.isFinal();
    }

    private boolean isJavaScriptObject(JType elementType) {
        if (!(elementType instanceof JClassType)) {
            return false;
        }
        JClassType classType = (JClassType)elementType;
        return classType.isJsoType() && !classType.getSuperClass().isJsoType();
    }

    @Override
    public boolean canBeImplementedExternally() {
        return this.getLeafType().canBeImplementedExternally() || this.isJavaScriptObject(this.getElementType());
    }

    @Override
    public boolean isJsType() {
        return false;
    }

    @Override
    public boolean isJsFunction() {
        return false;
    }

    @Override
    public boolean isJsFunctionImplementation() {
        return false;
    }

    @Override
    public boolean isJsNative() {
        return this.getLeafType().isJsNative();
    }

    @Override
    public boolean isJsoType() {
        return false;
    }

    @Override
    public boolean canBeReferencedExternally() {
        return this.getLeafType().canBeReferencedExternally();
    }

    @Override
    public boolean isJavaLangObject() {
        return false;
    }

    @Override
    public boolean replaces(JType originalType) {
        return originalType instanceof JArrayType && this.elementType.replaces(((JArrayType)originalType).getElementType());
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }
}

