/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JArrayRef
extends JExpression {
    private JExpression indexExpr;
    private JExpression instance;

    public JArrayRef(SourceInfo info, JExpression instance, JExpression indexExpr) {
        super(info);
        this.instance = instance;
        this.indexExpr = indexExpr;
    }

    public JArrayType getArrayType() {
        JType type = this.instance.getType();
        if (type.isNullType()) {
            return null;
        }
        return (JArrayType)type.getUnderlyingType();
    }

    public JExpression getIndexExpr() {
        return this.indexExpr;
    }

    public JExpression getInstance() {
        return this.instance;
    }

    @Override
    public JType getType() {
        JArrayType arrayType = this.getArrayType();
        return arrayType == null ? JReferenceType.NULL_TYPE : arrayType.getElementType();
    }

    @Override
    public boolean hasSideEffects() {
        return this.instance.hasSideEffects() || this.indexExpr.hasSideEffects() || this.instance.getType().isNullType();
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.instance = visitor.accept(this.instance);
            this.indexExpr = visitor.accept(this.indexExpr);
        }
        visitor.endVisit(this, ctx);
    }
}

