/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.ast.CanBeJsNative;
import com.google.gwt.dev.jjs.ast.HasJsName;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JRecordType;
import java.beans.Introspector;

public interface HasJsInfo
extends HasJsName,
CanBeJsNative {
    public void setJsMemberInfo(JsMemberType var1, String var2, String var3, boolean var4);

    public void setJsOverlay();

    public JsMemberType getJsMemberType();

    public boolean isJsMethodVarargs();

    public boolean isJsOverlay();

    public boolean canBeReferencedExternally();

    public boolean canBeImplementedExternally();

    public boolean isJsInteropEntryPoint();

    public static enum JsMemberType {
        NONE{

            @Override
            public String computeName(JMember member) {
                return null;
            }
        }
        ,
        CONSTRUCTOR{

            @Override
            public String computeName(JMember member) {
                return "";
            }
        }
        ,
        METHOD,
        PROPERTY,
        GETTER("get"){

            @Override
            public String computeName(JMember member) {
                String methodName = member.getName();
                if (member.getEnclosingType() instanceof JRecordType) {
                    return methodName;
                }
                if (JsMemberType.startsWithCamelCase(methodName, "get")) {
                    return Introspector.decapitalize(methodName.substring(3));
                }
                if (JsMemberType.startsWithCamelCase(methodName, "is")) {
                    return Introspector.decapitalize(methodName.substring(2));
                }
                return "<invalid>";
            }

            @Override
            public boolean isPropertyAccessor() {
                return true;
            }
        }
        ,
        SETTER("set"){

            @Override
            public String computeName(JMember member) {
                String methodName = member.getName();
                if (JsMemberType.startsWithCamelCase(methodName, "set")) {
                    return Introspector.decapitalize(methodName.substring(3));
                }
                return "<invalid>";
            }

            @Override
            public boolean isPropertyAccessor() {
                return true;
            }
        }
        ,
        UNDEFINED_ACCESSOR;

        private String accessorKey;

        private JsMemberType() {
        }

        private JsMemberType(String accessorKey) {
            this.accessorKey = accessorKey;
        }

        public String getPropertyAccessorKey() {
            return this.accessorKey;
        }

        public boolean isPropertyAccessor() {
            return this.getPropertyAccessorKey() != null;
        }

        public String computeName(JMember member) {
            return member.getName();
        }

        private static boolean startsWithCamelCase(String string, String prefix) {
            return string.length() > prefix.length() && string.startsWith(prefix) && !Character.isLowerCase(string.charAt(prefix.length()));
        }
    }
}

