/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.PrecompilationMetricsArtifact;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.util.DiskCache;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;

public class UnifiedAst
implements Serializable {
    private static final DiskCache diskCache = DiskCache.INSTANCE;
    private transient AST initialAst;
    private ModuleMetricsArtifact moduleMetrics;
    private transient Object myLockObject = new Object();
    private final PrecompileTaskOptions options;
    private PrecompilationMetricsArtifact precompilationMetrics;
    private final SortedSet<String> rebindRequests;
    private transient long serializedAstToken;

    public UnifiedAst(PrecompileTaskOptions options, AST initialAst, boolean singlePermutation, Set<String> rebindRequests) {
        this.options = new PrecompileTaskOptionsImpl(options);
        this.initialAst = initialAst;
        this.rebindRequests = Collections.unmodifiableSortedSet(Sets.newTreeSet(rebindRequests));
        this.serializedAstToken = singlePermutation ? -1L : diskCache.writeObject(initialAst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AST getFreshAst() {
        Object object = this.myLockObject;
        synchronized (object) {
            if (this.initialAst != null) {
                AST result = this.initialAst;
                this.initialAst = null;
                return result;
            }
            if (this.serializedAstToken < 0L) {
                throw new IllegalStateException("No serialized AST was cached and AST was already consumed.");
            }
            return diskCache.readObject(this.serializedAstToken, AST.class);
        }
    }

    public ModuleMetricsArtifact getModuleMetrics() {
        return this.moduleMetrics;
    }

    public PrecompileTaskOptions getOptions() {
        return new PrecompileTaskOptionsImpl(this.options);
    }

    public PrecompilationMetricsArtifact getPrecompilationMetrics() {
        return this.precompilationMetrics;
    }

    public SortedSet<String> getRebindRequests() {
        return this.rebindRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        Object object = this.myLockObject;
        synchronized (object) {
            if (this.initialAst == null) {
                this.initialAst = diskCache.readObject(this.serializedAstToken, AST.class);
            }
        }
    }

    public void setModuleMetrics(ModuleMetricsArtifact metrics) {
        this.moduleMetrics = metrics;
    }

    public void setPrecompilationMetrics(PrecompilationMetricsArtifact metrics) {
        this.precompilationMetrics = metrics;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.myLockObject = new Object();
        this.serializedAstToken = diskCache.transferFromStream(stream);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.serializedAstToken >= 0L) {
            diskCache.transferToStream(this.serializedAstToken, stream);
        } else if (this.initialAst != null) {
            Util.writeObjectToStream(stream, this.initialAst);
        } else {
            throw new IllegalStateException("No serialized AST was cached and AST was already consumed.");
        }
    }

    public static final class AST
    implements Serializable {
        private final JProgram jProgram;
        private final JsProgram jsProgram;

        public AST(JProgram jProgram, JsProgram jsProgram) {
            this.jProgram = jProgram;
            this.jsProgram = jsProgram;
        }

        public JProgram getJProgram() {
            return this.jProgram;
        }

        public JsProgram getJsProgram() {
            return this.jsProgram;
        }
    }
}

