/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.Util;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourceOrigin
implements SourceInfo {
    public static final SourceOrigin UNKNOWN = new SourceOrigin("Unknown", 0){

        private Object readResolve() {
            return UNKNOWN;
        }
    };
    private static final Map<SourceOrigin, SourceOrigin> CANONICAL_SOURCE_ORIGINS = Collections.synchronizedMap(new LinkedHashMap<SourceOrigin, SourceOrigin>(150, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SourceOrigin, SourceOrigin> eldest) {
            return this.size() > 100;
        }
    });
    private static final Correlation[] NO_CORRELATIONS = new Correlation[0];
    private final String fileName;
    private final int startLine;

    public static SourceOrigin create(int startPos, int endPos, int startLine, String fileName) {
        if (startPos < 0 && endPos < 0) {
            return SourceOrigin.create(startLine, fileName);
        }
        return new SourceOriginPos(fileName, startLine, startPos, endPos);
    }

    public static SourceOrigin create(int startLine, String fileName) {
        SourceOrigin newInstance = new SourceOrigin(fileName, startLine);
        SourceOrigin canonical = CANONICAL_SOURCE_ORIGINS.get(newInstance);
        assert (canonical == null || newInstance != canonical && newInstance.equals(canonical));
        if (canonical != null) {
            return canonical;
        }
        CANONICAL_SOURCE_ORIGINS.put(newInstance, newInstance);
        return newInstance;
    }

    private SourceOrigin(String location, int startLine) {
        this.fileName = StringInterner.get().intern(Util.stripJarPathPrefix(location));
        this.startLine = startLine;
    }

    @Override
    public void addCorrelation(Correlation c) {
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceOrigin)) {
            return false;
        }
        SourceOrigin other = (SourceOrigin)o;
        return this.startLine == other.startLine && this.getEndPos() == other.getEndPos() && this.getStartPos() == other.getStartPos() && this.fileName.equals(other.fileName);
    }

    @Override
    public Correlation getCorrelation(Correlation.Axis axis) {
        return null;
    }

    @Override
    public Correlation[] getCorrelations() {
        return NO_CORRELATIONS;
    }

    @Override
    public CorrelationFactory getCorrelator() {
        return CorrelationFactory.DummyCorrelationFactory.INSTANCE;
    }

    @Override
    public int getEndPos() {
        return -1;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public SourceOrigin getOrigin() {
        return this;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getStartPos() {
        return -1;
    }

    public int hashCode() {
        return 2 + 13 * this.fileName.hashCode() + 17 * this.startLine + 29 * this.getStartPos() + 31 * this.getEndPos();
    }

    @Override
    public SourceInfo makeChild() {
        return this;
    }

    @Override
    public SourceInfo makeChild(SourceOrigin origin) {
        return origin;
    }

    public String toString() {
        return this.getFileName() + '(' + this.getStartLine() + ')';
    }

    private static class SourceOriginPos
    extends SourceOrigin {
        private final int endPos;
        private final int startPos;

        private SourceOriginPos(String location, int startLine, int startPos, int endPos) {
            super(location, startLine);
            this.startPos = startPos;
            this.endPos = endPos;
        }

        @Override
        public int getEndPos() {
            return this.endPos;
        }

        @Override
        public int getStartPos() {
            return this.startPos;
        }
    }
}

