/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;

public class SourceInfoCorrelation
implements SourceInfo {
    private static final int NUM_AXES = Correlation.Axis.values().length;
    private final SourceOrigin origin;
    private final SourceInfoCorrelation parent;
    private Correlation[] primaryCorrelations = null;

    public SourceInfoCorrelation(SourceOrigin origin) {
        this.origin = origin;
        this.parent = null;
    }

    public SourceInfoCorrelation(SourceInfoCorrelation parent, SourceOrigin origin) {
        this.origin = origin;
        this.parent = parent;
    }

    @Override
    public void addCorrelation(Correlation c) {
        if (this.primaryCorrelations == null) {
            this.primaryCorrelations = new Correlation[NUM_AXES];
        }
        int index = c.getAxis().ordinal();
        this.primaryCorrelations[index] = c;
    }

    @Override
    public Correlation getCorrelation(Correlation.Axis axis) {
        Correlation c;
        if (this.primaryCorrelations != null && (c = this.primaryCorrelations[axis.ordinal()]) != null) {
            return c;
        }
        if (this.parent != null) {
            return this.parent.getCorrelation(axis);
        }
        return null;
    }

    @Override
    public Correlation[] getCorrelations() {
        if (this.parent == null) {
            if (this.primaryCorrelations == null) {
                return new Correlation[NUM_AXES];
            }
            return (Correlation[])this.primaryCorrelations.clone();
        }
        Correlation[] result = this.parent.getCorrelations();
        if (this.primaryCorrelations != null) {
            for (int i = 0; i < NUM_AXES; ++i) {
                Correlation c = this.primaryCorrelations[i];
                if (c == null) continue;
                result[i] = c;
            }
        }
        return result;
    }

    @Override
    public CorrelationFactory getCorrelator() {
        return CorrelationFactory.RealCorrelationFactory.INSTANCE;
    }

    @Override
    public int getEndPos() {
        return this.getOrigin().getEndPos();
    }

    @Override
    public String getFileName() {
        return this.getOrigin().getFileName();
    }

    @Override
    public SourceOrigin getOrigin() {
        return this.origin;
    }

    public Correlation getPrimaryCorrelation() {
        int[] order;
        if (this.primaryCorrelations == null) {
            if (this.parent != null) {
                return this.parent.getPrimaryCorrelation();
            }
            return null;
        }
        if (this.primaryCorrelations[Correlation.Axis.LITERAL.ordinal()] != null) {
            if (this.primaryCorrelations[Correlation.Axis.LITERAL.ordinal()].getIdent().equals("class") && this.parent != null) {
                return this.parent.getPrimaryCorrelation();
            }
            return null;
        }
        for (int idx : order = new int[]{Correlation.Axis.FIELD.ordinal(), Correlation.Axis.METHOD.ordinal(), Correlation.Axis.CLASS.ordinal()}) {
            if (this.primaryCorrelations[idx] == null) continue;
            return this.primaryCorrelations[idx];
        }
        return null;
    }

    @Override
    public int getStartLine() {
        return this.getOrigin().getStartLine();
    }

    @Override
    public int getStartPos() {
        return this.getOrigin().getStartPos();
    }

    @Override
    public SourceInfo makeChild() {
        return new SourceInfoCorrelation(this, this.origin);
    }

    @Override
    public SourceInfo makeChild(SourceOrigin origin) {
        return new SourceInfoCorrelation(this, origin);
    }

    public String toString() {
        return this.origin.toString();
    }
}

