/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.core.ext.linker.impl.JsSourceMapExtractor;
import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.dev.jjs.SourceInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JsSourceMap
implements Serializable {
    private int bytes;
    private int lines;
    private List<Range> ranges;

    public JsSourceMap(List<Range> ranges, int bytes, int lines) {
        this.ranges = ranges;
        this.bytes = bytes;
        this.lines = lines;
    }

    public JsSourceMapExtractor createExtractor() {
        return new JsSourceMapExtractor(this.ranges);
    }

    public int getBytes() {
        return this.bytes;
    }

    public int getLines() {
        return this.lines;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    private void readObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        this.bytes = inStream.readInt();
        this.lines = inStream.readInt();
        int rangeCount = inStream.readInt();
        this.ranges = new ArrayList<Range>(rangeCount);
        for (int i = 0; i < rangeCount; ++i) {
            int start = inStream.readInt();
            int end = inStream.readInt();
            int startLine = inStream.readInt();
            int startColumn = inStream.readInt();
            int endLine = inStream.readInt();
            int endColumn = inStream.readInt();
            SourceInfo sourceInfo = (SourceInfo)inStream.readObject();
            this.ranges.add(new Range(start, end, startLine, startColumn, endLine, endColumn, sourceInfo));
        }
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        outStream.writeInt(this.bytes);
        outStream.writeInt(this.lines);
        outStream.writeInt(this.ranges.size());
        for (Range range : this.ranges) {
            outStream.writeInt(range.getStart());
            outStream.writeInt(range.getEnd());
            outStream.writeInt(range.getStartLine());
            outStream.writeInt(range.getStartColumn());
            outStream.writeInt(range.getEndLine());
            outStream.writeInt(range.getEndColumn());
            outStream.writeObject(range.getSourceInfo());
        }
    }
}

