/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.CompilationMetricsArtifact;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.PrecompilationMetricsArtifact;
import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.core.ext.linker.SymbolData;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.core.ext.linker.impl.StandardSymbolData;
import com.google.gwt.core.ext.soyc.SourceMapRecorder;
import com.google.gwt.core.ext.soyc.coderef.DependencyGraphRecorder;
import com.google.gwt.core.ext.soyc.coderef.EntityRecorder;
import com.google.gwt.core.ext.soyc.impl.DependencyRecorder;
import com.google.gwt.core.ext.soyc.impl.SizeMapRecorder;
import com.google.gwt.core.ext.soyc.impl.SplitPointRecorder;
import com.google.gwt.core.ext.soyc.impl.StoryRecorder;
import com.google.gwt.core.linker.SoycReportLinker;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.cfg.EntryMethodHolderGenerator;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.PermutationProperties;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.StandardGeneratorContext;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.jdt.RebindPermutationOracle;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.JJSOptions;
import com.google.gwt.dev.jjs.JsOutputOption;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.PrecompilationContext;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.impl.ArrayNormalizer;
import com.google.gwt.dev.jjs.impl.AssertionNormalizer;
import com.google.gwt.dev.jjs.impl.AssertionRemover;
import com.google.gwt.dev.jjs.impl.AstDumper;
import com.google.gwt.dev.jjs.impl.CatchBlockNormalizer;
import com.google.gwt.dev.jjs.impl.CompileTimeConstantsReplacer;
import com.google.gwt.dev.jjs.impl.ComputeCastabilityInformation;
import com.google.gwt.dev.jjs.impl.ComputeExhaustiveCastabilityInformation;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.ControlFlowRecorder;
import com.google.gwt.dev.jjs.impl.DeadCodeElimination;
import com.google.gwt.dev.jjs.impl.DevirtualizeDefaultMethodForwarding;
import com.google.gwt.dev.jjs.impl.Devirtualizer;
import com.google.gwt.dev.jjs.impl.EnumNameObfuscator;
import com.google.gwt.dev.jjs.impl.EnumOrdinalizer;
import com.google.gwt.dev.jjs.impl.EqualityNormalizer;
import com.google.gwt.dev.jjs.impl.Finalizer;
import com.google.gwt.dev.jjs.impl.FixAssignmentsToUnboxOrCast;
import com.google.gwt.dev.jjs.impl.FullOptimizerContext;
import com.google.gwt.dev.jjs.impl.GenerateJavaScriptAST;
import com.google.gwt.dev.jjs.impl.HandleCrossFragmentReferences;
import com.google.gwt.dev.jjs.impl.ImplementCastsAndTypeChecks;
import com.google.gwt.dev.jjs.impl.ImplementClassLiteralsAsFields;
import com.google.gwt.dev.jjs.impl.ImplementJsVarargs;
import com.google.gwt.dev.jjs.impl.ImplementRecordComponents;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.JsAbstractTextTransformer;
import com.google.gwt.dev.jjs.impl.JsFunctionClusterer;
import com.google.gwt.dev.jjs.impl.JsInteropRestrictionChecker;
import com.google.gwt.dev.jjs.impl.JsNoopTransformer;
import com.google.gwt.dev.jjs.impl.JsTypeLinker;
import com.google.gwt.dev.jjs.impl.JsniRestrictionChecker;
import com.google.gwt.dev.jjs.impl.LongCastNormalizer;
import com.google.gwt.dev.jjs.impl.LongEmulationNormalizer;
import com.google.gwt.dev.jjs.impl.MakeCallsStatic;
import com.google.gwt.dev.jjs.impl.MethodCallSpecializer;
import com.google.gwt.dev.jjs.impl.MethodCallTightener;
import com.google.gwt.dev.jjs.impl.MethodInliner;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.PostOptimizationCompoundAssignmentNormalizer;
import com.google.gwt.dev.jjs.impl.Pruner;
import com.google.gwt.dev.jjs.impl.RecordRebinds;
import com.google.gwt.dev.jjs.impl.RemoveEmptySuperCalls;
import com.google.gwt.dev.jjs.impl.RemoveSpecializations;
import com.google.gwt.dev.jjs.impl.ReplaceCallsToNativeJavaLangObjectOverrides;
import com.google.gwt.dev.jjs.impl.ReplaceGetClassOverrides;
import com.google.gwt.dev.jjs.impl.ResolvePermutationDependentValues;
import com.google.gwt.dev.jjs.impl.ResolveRuntimeTypeReferences;
import com.google.gwt.dev.jjs.impl.RewriteConstructorCallsForUnboxedTypes;
import com.google.gwt.dev.jjs.impl.SameParameterValueOptimizer;
import com.google.gwt.dev.jjs.impl.SourceInfoCorrelator;
import com.google.gwt.dev.jjs.impl.SplitCaseStatementValues;
import com.google.gwt.dev.jjs.impl.TypeCoercionNormalizer;
import com.google.gwt.dev.jjs.impl.TypeReferencesRecorder;
import com.google.gwt.dev.jjs.impl.TypeTightener;
import com.google.gwt.dev.jjs.impl.UnifyAst;
import com.google.gwt.dev.jjs.impl.codesplitter.CodeSplitter;
import com.google.gwt.dev.jjs.impl.codesplitter.CodeSplitters;
import com.google.gwt.dev.jjs.impl.codesplitter.MultipleDependencyGraphRecorder;
import com.google.gwt.dev.jjs.impl.codesplitter.ReplaceRunAsyncs;
import com.google.gwt.dev.jjs.impl.gflow.DataflowOptimizer;
import com.google.gwt.dev.js.BaselineCoverageGatherer;
import com.google.gwt.dev.js.CoverageInstrumentor;
import com.google.gwt.dev.js.DuplicateClinitRemover;
import com.google.gwt.dev.js.EvalFunctionsAtTopScope;
import com.google.gwt.dev.js.FreshNameGenerator;
import com.google.gwt.dev.js.JsBreakUpLargeVarStatements;
import com.google.gwt.dev.js.JsDuplicateCaseFolder;
import com.google.gwt.dev.js.JsDuplicateFunctionRemover;
import com.google.gwt.dev.js.JsForceInliningChecker;
import com.google.gwt.dev.js.JsIncrementalNamer;
import com.google.gwt.dev.js.JsInliner;
import com.google.gwt.dev.js.JsLiteralInterner;
import com.google.gwt.dev.js.JsNamer;
import com.google.gwt.dev.js.JsNamespaceChooser;
import com.google.gwt.dev.js.JsNamespaceOption;
import com.google.gwt.dev.js.JsNormalizer;
import com.google.gwt.dev.js.JsObfuscateNamer;
import com.google.gwt.dev.js.JsPrettyNamer;
import com.google.gwt.dev.js.JsReportGenerationVisitor;
import com.google.gwt.dev.js.JsStackEmulator;
import com.google.gwt.dev.js.JsStaticEval;
import com.google.gwt.dev.js.JsSymbolResolver;
import com.google.gwt.dev.js.JsUnusedFunctionRemover;
import com.google.gwt.dev.js.JsVerboseNamer;
import com.google.gwt.dev.js.SizeBreakdown;
import com.google.gwt.dev.js.ast.JavaScriptVerifier;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsForIn;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsLabel;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameOf;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.Memory;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.Pair;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.soyc.SoycDashboard;
import com.google.gwt.soyc.io.ArtifactsOutputDirectory;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class JavaToJavaScriptCompiler {
    private static final float EFFICIENT_CHANGE_RATE = 0.01f;
    private static final int FIXED_POINT_CHANGE_RATE = 0;
    private static final int MAX_PASSES = 100;
    private final CompilerContext compilerContext;
    private final TreeLogger logger;
    private final ModuleDef module;
    private final PrecompileTaskOptions options;
    private JsProgram jsProgram;
    private JProgram jprogram;

    public JavaToJavaScriptCompiler(TreeLogger logger, CompilerContext compilerContext) {
        this.logger = logger;
        this.compilerContext = compilerContext;
        this.module = compilerContext.getModule();
        this.options = compilerContext.getOptions();
    }

    public static UnifiedAst precompile(TreeLogger logger, CompilerContext compilerContext, PrecompilationContext precompilationContext) throws UnableToCompleteException {
        return new JavaToJavaScriptCompiler(logger, compilerContext).precompile(precompilationContext);
    }

    public static PermutationResult compilePermutation(UnifiedAst unifiedAst, TreeLogger logger, CompilerContext compilerContext, Permutation permutation) throws UnableToCompleteException {
        JavaToJavaScriptCompiler javaToJavaScriptCompiler = new JavaToJavaScriptCompiler(logger, compilerContext);
        return javaToJavaScriptCompiler.compilePermutation(permutation, unifiedAst);
    }

    private PermutationResult compilePermutation(Permutation permutation, UnifiedAst unifiedAst) throws UnableToCompleteException {
        SpeedTracerLogger.Event jjsCompilePermutationEvent = SpeedTracerLogger.start(CompilerEventType.JJS_COMPILE_PERMUTATION, "name", permutation.getProperties().prettyPrint());
        long permStartMs = System.currentTimeMillis();
        try {
            SpeedTracerLogger.Event javaEvent = SpeedTracerLogger.start(CompilerEventType.PERMUTATION_JAVA, new String[0]);
            long startTimeMs = System.currentTimeMillis();
            PermutationProperties properties = permutation.getProperties();
            int permutationId = permutation.getId();
            UnifiedAst.AST ast = unifiedAst.getFreshAst();
            this.jprogram = ast.getJProgram();
            this.jsProgram = ast.getJsProgram();
            TreeMap symbolTable = new TreeMap(new SymbolData.ClassIdentComparator());
            this.logger.log(TreeLogger.INFO, "Compiling permutation " + permutationId + "...");
            ResolvePermutationDependentValues.exec(this.jprogram, properties, permutation.getPropertyAndBindingInfos());
            Multimap<String, Integer> instrumentableLines = null;
            if (CoverageInstrumentor.isCoverageEnabled()) {
                instrumentableLines = BaselineCoverageGatherer.exec(this.jprogram);
            }
            this.maybeRecordReferencesAndControlFlow(false);
            RewriteConstructorCallsForUnboxedTypes.exec(this.jprogram);
            CompileTimeConstantsReplacer.exec(this.jprogram);
            this.optimizeJava();
            ResolveRuntimeTypeReferences.TypeMapper<?> typeMapper = this.normalizeSemantics();
            this.postNormalizationOptimizeJava();
            this.maybeRecordReferencesAndControlFlow(true);
            javaEvent.end(new String[0]);
            SpeedTracerLogger.Event javaScriptEvent = SpeedTracerLogger.start(CompilerEventType.PERMUTATION_JAVASCRIPT, new String[0]);
            Pair<JavaToJavaScriptMap, Set<JsNode>> jjsMapAndInlineableFunctions = GenerateJavaScriptAST.exec(this.logger, this.jprogram, this.jsProgram, this.compilerContext, typeMapper, symbolTable, properties);
            JavaToJavaScriptMap jjsmap = jjsMapAndInlineableFunctions.getLeft();
            if (CoverageInstrumentor.isCoverageEnabled()) {
                CoverageInstrumentor.exec(this.jprogram, this.jsProgram, jjsmap, instrumentableLines);
            }
            JsNormalizer.exec(this.jsProgram);
            JsSymbolResolver.exec(this.jsProgram);
            if (this.options.getNamespace() == JsNamespaceOption.PACKAGE) {
                if (!this.jprogram.getRunAsyncs().isEmpty()) {
                    this.options.setNamespace(JsNamespaceOption.NONE);
                    this.logger.log(TreeLogger.Type.WARN, "Namespace option is not compatible with CodeSplitter, turning it off.");
                } else {
                    JsNamespaceChooser.exec(this.jprogram, this.jsProgram, jjsmap);
                }
            }
            Pair<SyntheticArtifact, MultipleDependencyGraphRecorder> dependenciesAndRecorder = this.splitJsIntoFragments(properties, permutationId, jjsmap);
            EvalFunctionsAtTopScope.exec(this.jsProgram, jjsmap);
            Set<JsNode> inlinableJsFunctions = jjsMapAndInlineableFunctions.getRight();
            this.optimizeJs(inlinableJsFunctions);
            if (this.options.getOptimizationLevel() > 0) {
                JsForceInliningChecker.check(this.logger, jjsmap, this.jsProgram);
            }
            JsStackEmulator.exec(this.jprogram, this.jsProgram, properties, jjsmap);
            Map<JsName, JsLiteral> internedLiteralByVariableName = this.renameJsSymbols(properties, jjsmap);
            HandleCrossFragmentReferences.exec(this.jsProgram, properties);
            JsBreakUpLargeVarStatements.exec(this.jsProgram, properties.getConfigurationProperties());
            if (!this.options.isIncrementalCompileEnabled()) {
                JavaScriptVerifier.verify(this.jsProgram, jjsmap);
            }
            ArrayList<JsSourceMap> sourceInfoMaps = new ArrayList<JsSourceMap>();
            boolean isSourceMapsEnabled = properties.isTrueInAnyPermutation("compiler.useSourceMaps");
            String[] jsFragments = new String[this.jsProgram.getFragmentCount()];
            StatementRanges[] ranges = new StatementRanges[jsFragments.length];
            SizeBreakdown[] sizeBreakdowns = this.options.isJsonSoycEnabled() || this.options.isSoycEnabled() || this.options.isCompilerMetricsEnabled() ? new SizeBreakdown[jsFragments.length] : null;
            this.generateJavaScriptCode(jjsmap, jsFragments, ranges, sizeBreakdowns, sourceInfoMaps, isSourceMapsEnabled || this.options.isJsonSoycEnabled());
            javaScriptEvent.end(new String[0]);
            PermutationResultImpl permutationResult = new PermutationResultImpl(jsFragments, permutation, this.makeSymbolMap(symbolTable), ranges);
            this.addSyntheticArtifacts(unifiedAst, permutation, startTimeMs, permutationId, jjsmap, dependenciesAndRecorder, internedLiteralByVariableName, isSourceMapsEnabled, jsFragments, sizeBreakdowns, sourceInfoMaps, permutationResult);
            PermutationResultImpl permutationResultImpl = permutationResult;
            return permutationResultImpl;
        }
        catch (Throwable e) {
            throw CompilationProblemReporter.logAndTranslateException(this.logger, e);
        }
        finally {
            jjsCompilePermutationEvent.end(new String[0]);
            if (this.logger.isLoggable(TreeLogger.TRACE)) {
                this.logger.log(TreeLogger.TRACE, "Permutation took " + (System.currentTimeMillis() - permStartMs) + " ms");
            }
        }
    }

    private void maybeRecordReferencesAndControlFlow(boolean onlyUpdate) {
        if (this.options.isIncrementalCompileEnabled()) {
            TypeReferencesRecorder.exec(this.jprogram, this.getMinimalRebuildCache(), onlyUpdate);
            ControlFlowRecorder.exec(this.jprogram, this.getMinimalRebuildCache().getTypeEnvironment(), onlyUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResolveRuntimeTypeReferences.TypeMapper<?> normalizeSemantics() {
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.JAVA_NORMALIZERS, new String[0]);
        try {
            Devirtualizer.exec(this.jprogram);
            CatchBlockNormalizer.exec(this.jprogram);
            PostOptimizationCompoundAssignmentNormalizer.exec(this.jprogram);
            LongCastNormalizer.exec(this.jprogram);
            LongEmulationNormalizer.exec(this.jprogram);
            TypeCoercionNormalizer.exec(this.jprogram);
            SplitCaseStatementValues.exec(this.jprogram);
            if (this.options.isIncrementalCompileEnabled()) {
                ComputeExhaustiveCastabilityInformation.exec(this.jprogram);
            } else {
                ComputeCastabilityInformation.exec(this.jprogram, !this.shouldOptimize());
            }
            ImplementCastsAndTypeChecks.exec(this.jprogram, this.shouldOptimize());
            ImplementJsVarargs.exec(this.jprogram);
            ArrayNormalizer.exec(this.jprogram);
            EqualityNormalizer.exec(this.jprogram);
            ResolveRuntimeTypeReferences.TypeMapper typeMapper = this.getTypeMapper();
            ResolveRuntimeTypeReferences.exec(this.jprogram, typeMapper, this.getTypeOrder());
            ResolveRuntimeTypeReferences.TypeMapper typeMapper2 = typeMapper;
            return typeMapper2;
        }
        finally {
            event.end(new String[0]);
        }
    }

    private void optimizeJava() throws InterruptedException {
        if (this.shouldOptimize()) {
            this.optimizeJavaToFixedPoint();
            RemoveEmptySuperCalls.exec(this.jprogram);
        }
    }

    private void optimizeJs(Set<JsNode> inlinableJsFunctions) throws InterruptedException {
        if (this.shouldOptimize()) {
            this.optimizeJsLoop(inlinableJsFunctions);
            JsDuplicateCaseFolder.exec(this.jsProgram);
        }
    }

    private void postNormalizationOptimizeJava() {
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.JAVA_POST_NORMALIZER_OPTIMIZERS, new String[0]);
        try {
            if (this.shouldOptimize()) {
                RemoveSpecializations.exec(this.jprogram);
                Pruner.exec(this.jprogram, false);
                this.jprogram.typeOracle.recomputeAfterOptimizations(this.jprogram.getDeclaredTypes());
            }
            ReplaceGetClassOverrides.exec(this.jprogram);
        }
        finally {
            event.end(new String[0]);
        }
    }

    private Map<JsName, JsLiteral> runDetailedNamer(ConfigurationProperties config) throws JsNamer.IllegalNameException {
        Map<JsName, JsLiteral> internedTextByVariableName = this.maybeInternLiterals(31);
        JsVerboseNamer.exec(this.jsProgram, config);
        return internedTextByVariableName;
    }

    private Map<JsName, JsLiteral> maybeInternLiterals(int interningMask) {
        if (!this.shouldOptimize()) {
            return null;
        }
        if (this.options.isClosureCompilerFormatEnabled()) {
            interningMask &= 0xFFFFFFEF;
        }
        return JsLiteralInterner.exec(this.jprogram, this.jsProgram, interningMask);
    }

    private Pair<SyntheticArtifact, MultipleDependencyGraphRecorder> splitJsIntoFragments(PermutationProperties properties, int permutationId, JavaToJavaScriptMap jjsmap) {
        MultipleDependencyGraphRecorder dependencyRecorder = null;
        SyntheticArtifact dependencies = null;
        if (this.options.isRunAsyncEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int expectedFragmentCount = this.options.getFragmentCount();
            int minFragmentSize = properties.getConfigurationProperties().getInteger("compiler.splitpoint.leftovermerge.size", 0);
            dependencyRecorder = this.chooseDependencyRecorder(baos);
            CodeSplitter.exec(this.logger, this.jprogram, this.jsProgram, jjsmap, expectedFragmentCount, minFragmentSize, dependencyRecorder);
            if (baos.size() == 0) {
                dependencyRecorder = this.recordNonSplitDependencies(baos);
            }
            if (baos.size() > 0) {
                dependencies = new SyntheticArtifact(SoycReportLinker.class, "dependencies" + permutationId + ".xml.gz", baos.toByteArray());
            }
        } else if (this.options.isSoycEnabled() || this.options.isJsonSoycEnabled()) {
            dependencyRecorder = this.recordNonSplitDependencies(new ByteArrayOutputStream());
        }
        Pair<Object, DependencyRecorder> dependenciesAndRecorder = Pair.create(dependencies, dependencyRecorder);
        return dependenciesAndRecorder;
    }

    private MultipleDependencyGraphRecorder chooseDependencyRecorder(OutputStream out) {
        MultipleDependencyGraphRecorder dependencyRecorder = MultipleDependencyGraphRecorder.NULL_RECORDER;
        if (this.options.isSoycEnabled() && this.options.isJsonSoycEnabled()) {
            dependencyRecorder = new DependencyGraphRecorder(out, this.jprogram);
        } else if (this.options.isSoycEnabled()) {
            dependencyRecorder = new DependencyRecorder(out);
        } else if (this.options.isJsonSoycEnabled()) {
            dependencyRecorder = new DependencyGraphRecorder(out, this.jprogram);
        }
        return dependencyRecorder;
    }

    private DependencyRecorder recordNonSplitDependencies(OutputStream out) {
        DependencyRecorder deps;
        if (this.options.isSoycEnabled() && this.options.isJsonSoycEnabled()) {
            deps = new DependencyGraphRecorder(out, this.jprogram);
        } else if (this.options.isSoycEnabled()) {
            deps = new DependencyRecorder(out);
        } else if (this.options.isJsonSoycEnabled()) {
            deps = new DependencyGraphRecorder(out, this.jprogram);
        } else {
            return null;
        }
        deps.open();
        deps.startDependencyGraph("initial", null);
        ControlFlowAnalyzer cfa = new ControlFlowAnalyzer(this.jprogram);
        cfa.setDependencyRecorder(deps);
        cfa.traverseEntryMethods();
        deps.endDependencyGraph();
        deps.close();
        return deps;
    }

    private CompilationMetricsArtifact addCompilerMetricsArtifact(UnifiedAst unifiedAst, Permutation permutation, long startTimeMs, SizeBreakdown[] sizeBreakdowns, PermutationResult permutationResult) {
        CompilationMetricsArtifact compilationMetrics = null;
        if (this.options.isCompilerMetricsEnabled()) {
            compilationMetrics = new CompilationMetricsArtifact(permutation.getId());
            compilationMetrics.setCompileElapsedMilliseconds(System.currentTimeMillis() - startTimeMs);
            compilationMetrics.setElapsedMilliseconds(System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime());
            compilationMetrics.setJsSize(sizeBreakdowns);
            compilationMetrics.setPermutationDescription(permutation.getProperties().prettyPrint());
            permutationResult.addArtifacts(Lists.newArrayList(unifiedAst.getModuleMetrics(), unifiedAst.getPrecompilationMetrics(), compilationMetrics));
        }
        return compilationMetrics;
    }

    private void addSourceMapArtifacts(int permutationId, JavaToJavaScriptMap jjsmap, Pair<SyntheticArtifact, MultipleDependencyGraphRecorder> dependenciesAndRecorder, boolean isSourceMapsEnabled, SizeBreakdown[] sizeBreakdowns, List<JsSourceMap> sourceInfoMaps, PermutationResult permutationResult) {
        if (this.options.isJsonSoycEnabled()) {
            permutationResult.addArtifacts(EntityRecorder.makeSoycArtifacts(permutationId, sourceInfoMaps, this.options.getSourceMapFilePrefix(), jjsmap, sizeBreakdowns, (DependencyGraphRecorder)dependenciesAndRecorder.getRight(), this.jprogram));
        } else if (isSourceMapsEnabled) {
            this.logger.log(TreeLogger.INFO, "Source Maps Enabled");
            permutationResult.addArtifacts(SourceMapRecorder.exec(permutationId, sourceInfoMaps, this.options.getSourceMapFilePrefix()));
        }
    }

    private void maybeAddGeneratedArtifacts(PermutationResult permutationResult) {
        if (this.options.isIncrementalCompileEnabled()) {
            permutationResult.addArtifacts(this.compilerContext.getMinimalRebuildCache().getGeneratedArtifacts());
        }
    }

    private void addSoycArtifacts(UnifiedAst unifiedAst, int permutationId, JavaToJavaScriptMap jjsmap, Pair<SyntheticArtifact, MultipleDependencyGraphRecorder> dependenciesAndRecorder, Map<JsName, JsLiteral> internedLiteralByVariableName, String[] js, SizeBreakdown[] sizeBreakdowns, List<JsSourceMap> sourceInfoMaps, PermutationResult permutationResult, CompilationMetricsArtifact compilationMetrics) throws IOException, UnableToCompleteException {
        permutationResult.addArtifacts(this.makeSoycArtifacts(permutationId, js, sizeBreakdowns, this.options.isSoycExtra() ? sourceInfoMaps : null, dependenciesAndRecorder.getLeft(), jjsmap, internedLiteralByVariableName, unifiedAst.getModuleMetrics(), unifiedAst.getPrecompilationMetrics(), compilationMetrics, this.options.isSoycHtmlDisabled()));
    }

    private void addSyntheticArtifacts(UnifiedAst unifiedAst, Permutation permutation, long startTimeMs, int permutationId, JavaToJavaScriptMap jjsmap, Pair<SyntheticArtifact, MultipleDependencyGraphRecorder> dependenciesAndRecorder, Map<JsName, JsLiteral> internedLiteralByVariableName, boolean isSourceMapsEnabled, String[] jsFragments, SizeBreakdown[] sizeBreakdowns, List<JsSourceMap> sourceInfoMaps, PermutationResult permutationResult) throws IOException, UnableToCompleteException {
        assert (internedLiteralByVariableName != null);
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.PERMUTATION_ARTIFACTS, new String[0]);
        CompilationMetricsArtifact compilationMetrics = this.addCompilerMetricsArtifact(unifiedAst, permutation, startTimeMs, sizeBreakdowns, permutationResult);
        this.addSoycArtifacts(unifiedAst, permutationId, jjsmap, dependenciesAndRecorder, internedLiteralByVariableName, jsFragments, sizeBreakdowns, sourceInfoMaps, permutationResult, compilationMetrics);
        this.addSourceMapArtifacts(permutationId, jjsmap, dependenciesAndRecorder, isSourceMapsEnabled, sizeBreakdowns, sourceInfoMaps, permutationResult);
        this.maybeAddGeneratedArtifacts(permutationResult);
        event.end(new String[0]);
    }

    private void generateJavaScriptCode(JavaToJavaScriptMap jjsMap, String[] jsFragments, StatementRanges[] ranges, SizeBreakdown[] sizeBreakdowns, List<JsSourceMap> sourceInfoMaps, boolean sourceMapsEnabled) {
        SpeedTracerLogger.Event generateJavascriptEvent = SpeedTracerLogger.start(CompilerEventType.GENERATE_JAVASCRIPT, new String[0]);
        for (int i = 0; i < jsFragments.length; ++i) {
            DefaultTextOutput out = new DefaultTextOutput(!this.options.isIncrementalCompileEnabled() && this.options.getOutput().shouldMinimize());
            JsReportGenerationVisitor v = new JsReportGenerationVisitor(out, jjsMap, this.options.isJsonSoycEnabled());
            v.accept(this.jsProgram.getFragmentBlock(i));
            StatementRanges statementRanges = v.getStatementRanges();
            String code = out.toString();
            JsSourceMap infoMap = sourceInfoMaps != null ? v.getSourceInfoMap() : null;
            JsAbstractTextTransformer transformer = new JsNoopTransformer(code, statementRanges, infoMap);
            if (this.options.isIncrementalCompileEnabled()) {
                transformer = new JsTypeLinker(this.logger, transformer, v.getClassRanges(), v.getProgramClassRange(), this.getMinimalRebuildCache(), this.jprogram.typeOracle);
                transformer.exec();
            }
            SpeedTracerLogger.Event functionClusterEvent = SpeedTracerLogger.start(CompilerEventType.FUNCTION_CLUSTER, new String[0]);
            if (!sourceMapsEnabled && !this.options.isClosureCompilerFormatEnabled() && this.options.shouldClusterSimilarFunctions() && this.options.getNamespace() == JsNamespaceOption.NONE && this.options.getOutput() == JsOutputOption.OBFUSCATED) {
                transformer = new JsFunctionClusterer(transformer);
                transformer.exec();
            }
            functionClusterEvent.end(new String[0]);
            jsFragments[i] = transformer.getJs();
            ranges[i] = transformer.getStatementRanges();
            if (sizeBreakdowns != null) {
                sizeBreakdowns[i] = v.getSizeBreakdown();
            }
            if (sourceInfoMaps == null) continue;
            sourceInfoMaps.add(transformer.getSourceInfoMap());
        }
        generateJavascriptEvent.end(new String[0]);
    }

    private Collection<? extends Artifact<?>> makeSoycArtifacts(int permutationId, String[] js, SizeBreakdown[] sizeBreakdowns, List<JsSourceMap> sourceInfoMaps, SyntheticArtifact dependencies, JavaToJavaScriptMap jjsmap, Map<JsName, JsLiteral> internedLiteralByVariableName, ModuleMetricsArtifact moduleMetricsArtifact, PrecompilationMetricsArtifact precompilationMetricsArtifact, CompilationMetricsArtifact compilationMetrics, boolean htmlReportsDisabled) throws IOException, UnableToCompleteException {
        Memory.maybeDumpMemory("makeSoycArtifactsStart");
        ArrayList<SyntheticArtifact> soycArtifacts = new ArrayList<SyntheticArtifact>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SpeedTracerLogger.Event soycEvent = SpeedTracerLogger.start(CompilerEventType.MAKE_SOYC_ARTIFACTS, new String[0]);
        SpeedTracerLogger.Event recordSplitPoints = SpeedTracerLogger.start(CompilerEventType.MAKE_SOYC_ARTIFACTS, "phase", "recordSplitPoints");
        SplitPointRecorder.recordSplitPoints(this.jprogram, baos, this.logger);
        SyntheticArtifact splitPoints = new SyntheticArtifact(SoycReportLinker.class, "splitPoints" + permutationId + ".xml.gz", baos.toByteArray());
        soycArtifacts.add(splitPoints);
        recordSplitPoints.end(new String[0]);
        SyntheticArtifact sizeMaps = null;
        if (sizeBreakdowns != null) {
            SpeedTracerLogger.Event recordSizeMap = SpeedTracerLogger.start(CompilerEventType.MAKE_SOYC_ARTIFACTS, "phase", "recordSizeMap");
            baos.reset();
            SizeMapRecorder.recordMap(this.logger, baos, sizeBreakdowns, jjsmap, internedLiteralByVariableName);
            sizeMaps = new SyntheticArtifact(SoycReportLinker.class, "stories" + permutationId + ".xml.gz", baos.toByteArray());
            soycArtifacts.add(sizeMaps);
            recordSizeMap.end(new String[0]);
        }
        if (sourceInfoMaps != null) {
            SpeedTracerLogger.Event recordStories = SpeedTracerLogger.start(CompilerEventType.MAKE_SOYC_ARTIFACTS, "phase", "recordStories");
            baos.reset();
            StoryRecorder.recordStories(this.logger, baos, sourceInfoMaps, js);
            soycArtifacts.add(new SyntheticArtifact(SoycReportLinker.class, "detailedStories" + permutationId + ".xml.gz", baos.toByteArray()));
            recordStories.end(new String[0]);
        }
        if (dependencies != null) {
            soycArtifacts.add(dependencies);
        }
        for (SyntheticArtifact soycArtifact : soycArtifacts) {
            soycArtifact.setVisibility(EmittedArtifact.Visibility.Private);
        }
        if (!htmlReportsDisabled && sizeBreakdowns != null) {
            SpeedTracerLogger.Event generateCompileReport = SpeedTracerLogger.start(CompilerEventType.MAKE_SOYC_ARTIFACTS, "phase", "generateCompileReport");
            ArtifactsOutputDirectory outDir = new ArtifactsOutputDirectory();
            SoycDashboard dashboard = new SoycDashboard(outDir);
            dashboard.startNewPermutation(Integer.toString(permutationId));
            try {
                dashboard.readSplitPoints(this.openWithGunzip(splitPoints));
                if (sizeMaps != null) {
                    dashboard.readSizeMaps(this.openWithGunzip(sizeMaps));
                }
                if (dependencies != null) {
                    dashboard.readDependencies(this.openWithGunzip(dependencies));
                }
                Memory.maybeDumpMemory("soycReadDependenciesEnd");
            }
            catch (ParserConfigurationException e) {
                throw new InternalCompilerException("Error reading compile report information that was just generated", e);
            }
            catch (SAXException e) {
                throw new InternalCompilerException("Error reading compile report information that was just generated", e);
            }
            dashboard.generateForOnePermutation();
            if (moduleMetricsArtifact != null && precompilationMetricsArtifact != null && compilationMetrics != null) {
                dashboard.generateCompilerMetricsForOnePermutation(moduleMetricsArtifact, precompilationMetricsArtifact, compilationMetrics);
            }
            soycArtifacts.addAll(outDir.getArtifacts());
            generateCompileReport.end(new String[0]);
        }
        soycEvent.end(new String[0]);
        return soycArtifacts;
    }

    private SymbolData[] makeSymbolMap(Map<StandardSymbolData, JsName> symbolTable) {
        final HashSet nameUsed = new HashSet();
        final HashMap nameToFragment = new HashMap();
        for (int i = 0; i < this.jsProgram.getFragmentCount(); ++i) {
            final Integer fragId = i;
            new JsVisitor(){

                @Override
                public void endVisit(JsForIn x, JsContext ctx) {
                    if (x.getIterVarName() != null) {
                        nameUsed.add(x.getIterVarName().getIdent());
                    }
                }

                @Override
                public void endVisit(JsFunction x, JsContext ctx) {
                    if (x.getName() != null) {
                        nameToFragment.put(x.getName(), fragId);
                        nameUsed.add(x.getName().getIdent());
                    }
                }

                @Override
                public void endVisit(JsLabel x, JsContext ctx) {
                    nameUsed.add(x.getName().getIdent());
                }

                @Override
                public void endVisit(JsNameOf x, JsContext ctx) {
                    if (x.getName() != null) {
                        nameUsed.add(x.getName().getIdent());
                    }
                }

                @Override
                public void endVisit(JsNameRef x, JsContext ctx) {
                    if (x.isResolved()) {
                        nameUsed.add(x.getName().getIdent());
                    }
                }

                @Override
                public void endVisit(JsParameter x, JsContext ctx) {
                    nameUsed.add(x.getName().getIdent());
                }

                @Override
                public void endVisit(JsVars.JsVar x, JsContext ctx) {
                    nameUsed.add(x.getName().getIdent());
                }
            }.accept(this.jsProgram.getFragmentBlock(i));
        }
        ArrayList<StandardSymbolData> result = new ArrayList<StandardSymbolData>();
        for (Map.Entry<StandardSymbolData, JsName> entry : symbolTable.entrySet()) {
            StandardSymbolData symbolData = entry.getKey();
            symbolData.setSymbolName(entry.getValue().getShortIdent());
            Integer fragNum = (Integer)nameToFragment.get(entry.getValue());
            if (fragNum != null) {
                symbolData.setFragmentNumber(fragNum);
            }
            if (!nameUsed.contains(entry.getValue().getIdent()) && !entry.getKey().isClass()) continue;
            result.add(symbolData);
        }
        return result.toArray(new SymbolData[result.size()]);
    }

    private InputStream openWithGunzip(EmittedArtifact artifact) throws IOException, UnableToCompleteException {
        return new BufferedInputStream(new GZIPInputStream(artifact.getContents(TreeLogger.NULL)));
    }

    private void optimizeJsLoop(Collection<JsNode> toInline) throws InterruptedException {
        OptimizerStats stats;
        int optimizationLevel = this.options.getOptimizationLevel();
        ArrayList<OptimizerStats> allOptimizerStats = Lists.newArrayList();
        int counter = 0;
        do {
            ++counter;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            SpeedTracerLogger.Event optimizeJsEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE_JS, new String[0]);
            stats = new OptimizerStats("Pass " + counter);
            stats.add(JsStaticEval.exec(this.jsProgram));
            stats.add(JsInliner.exec(this.jsProgram, toInline));
            stats.add(JsUnusedFunctionRemover.exec(this.jsProgram));
            allOptimizerStats.add(stats);
            optimizeJsEvent.end(new String[0]);
        } while ((optimizationLevel >= 9 || counter <= optimizationLevel) && stats.didChange());
        if (optimizationLevel > 0) {
            DuplicateClinitRemover.exec(this.jsProgram);
        }
    }

    private Map<JsName, JsLiteral> renameJsSymbols(PermutationProperties properties, JavaToJavaScriptMap jjsmap) throws UnableToCompleteException {
        Map<JsName, JsLiteral> internedLiteralByVariableName = null;
        try {
            switch (this.options.getOutput()) {
                case OBFUSCATED: {
                    internedLiteralByVariableName = this.runObfuscateNamer(this.options, properties, jjsmap);
                    break;
                }
                case PRETTY: {
                    internedLiteralByVariableName = this.runPrettyNamer(this.options, properties, jjsmap);
                    break;
                }
                case DETAILED: {
                    internedLiteralByVariableName = this.runDetailedNamer(properties.getConfigurationProperties());
                    break;
                }
                default: {
                    throw new InternalCompilerException("Unknown output mode");
                }
            }
        }
        catch (JsNamer.IllegalNameException e) {
            this.logger.log(TreeLogger.ERROR, e.getMessage(), e);
            throw new UnableToCompleteException();
        }
        return internedLiteralByVariableName == null ? ImmutableMap.of() : internedLiteralByVariableName;
    }

    private Map<JsName, JsLiteral> runObfuscateNamer(JJSOptions options, PermutationProperties properties, JavaToJavaScriptMap jjsmap) throws JsNamer.IllegalNameException {
        if (options.isIncrementalCompileEnabled()) {
            this.runIncrementalNamer(options, properties.getConfigurationProperties(), jjsmap);
            return null;
        }
        Map<JsName, JsLiteral> internedLiteralByVariableName = this.maybeInternLiterals(31);
        FreshNameGenerator freshNameGenerator = JsObfuscateNamer.exec(this.jsProgram, properties.getConfigurationProperties());
        if (options.shouldRemoveDuplicateFunctions() && JsStackEmulator.getStackMode(properties) == JsStackEmulator.StackMode.STRIP) {
            JsDuplicateFunctionRemover.exec(this.jsProgram, freshNameGenerator);
        }
        return internedLiteralByVariableName;
    }

    private Map<JsName, JsLiteral> runPrettyNamer(JJSOptions options, PermutationProperties properties, JavaToJavaScriptMap jjsmap) throws JsNamer.IllegalNameException {
        if (options.isIncrementalCompileEnabled()) {
            this.runIncrementalNamer(options, properties.getConfigurationProperties(), jjsmap);
            return null;
        }
        Map<JsName, JsLiteral> internedLiteralByVariableName = this.maybeInternLiterals(15);
        JsPrettyNamer.exec(this.jsProgram, properties.getConfigurationProperties());
        return internedLiteralByVariableName;
    }

    private void runIncrementalNamer(JJSOptions options, ConfigurationProperties configurationProperties, JavaToJavaScriptMap jjsmap) throws JsNamer.IllegalNameException {
        JsIncrementalNamer.exec(this.jsProgram, configurationProperties, this.compilerContext.getMinimalRebuildCache().getPersistentPrettyNamerState(), jjsmap, options.getOutput() == JsOutputOption.OBFUSCATED);
    }

    private UnifiedAst precompile(PrecompilationContext precompilationContext) throws UnableToCompleteException {
        try {
            if (precompilationContext.getEntryPoints().length + precompilationContext.getAdditionalRootTypes().length == 0) {
                throw new IllegalArgumentException("entry point(s) required");
            }
            boolean singlePermutation = precompilationContext.getPermutations().length == 1;
            PrecompilationMetricsArtifact precompilationMetrics = precompilationContext.getPrecompilationMetricsArtifact();
            this.jprogram = new JProgram(this.compilerContext.getMinimalRebuildCache());
            this.jprogram.typeOracle.setOptimize(this.options.getOptimizationLevel() > 0);
            this.jsProgram = new JsProgram();
            CompilationState compilationState = this.constructJavaAst(precompilationContext);
            JsniRestrictionChecker.exec(this.logger, this.jprogram);
            JsInteropRestrictionChecker.exec(this.logger, this.jprogram, this.getMinimalRebuildCache());
            this.logTypeOracleMetrics(precompilationMetrics, compilationState);
            Memory.maybeDumpMemory("AstOnly");
            AstDumper.maybeDumpAST(this.jprogram);
            ConfigurationProperties configurationProperties = new ConfigurationProperties(this.module);
            EnumNameObfuscator.exec(this.jprogram, this.logger, configurationProperties, this.options);
            DevirtualizeDefaultMethodForwarding.exec(this.jprogram);
            ReplaceCallsToNativeJavaLangObjectOverrides.exec(this.jprogram);
            ImplementRecordComponents.exec(this.jprogram);
            FixAssignmentsToUnboxOrCast.exec(this.jprogram);
            if (this.options.isEnableAssertions()) {
                AssertionNormalizer.exec(this.jprogram);
            } else {
                AssertionRemover.exec(this.jprogram);
            }
            if (this.module != null && this.options.isRunAsyncEnabled()) {
                ReplaceRunAsyncs.exec(this.logger, this.jprogram);
                ConfigurationProperties config = new ConfigurationProperties(this.module);
                CodeSplitters.pickInitialLoadSequence(this.logger, this.jprogram, config);
            }
            ImplementClassLiteralsAsFields.exec(this.jprogram, this.shouldOptimize());
            this.logAstTypeMetrics(precompilationMetrics);
            SpeedTracerLogger.Event createUnifiedAstEvent = SpeedTracerLogger.start(CompilerEventType.CREATE_UNIFIED_AST, new String[0]);
            UnifiedAst result = new UnifiedAst(this.options, new UnifiedAst.AST(this.jprogram, this.jsProgram), singlePermutation, RecordRebinds.exec(this.jprogram));
            createUnifiedAstEvent.end(new String[0]);
            return result;
        }
        catch (Throwable e) {
            throw CompilationProblemReporter.logAndTranslateException(this.logger, e);
        }
    }

    private String buildEntryMethodHolder(StandardGeneratorContext context, String[] entryPointTypeNames, Set<String> allRootTypes) throws UnableToCompleteException {
        if (entryPointTypeNames.length == 0) {
            return null;
        }
        EntryMethodHolderGenerator entryMethodHolderGenerator = new EntryMethodHolderGenerator();
        context.setCurrentGenerator(EntryMethodHolderGenerator.class);
        String entryMethodHolderTypeName = entryMethodHolderGenerator.generate(this.logger, context, this.module.getCanonicalName());
        context.finish(this.logger);
        allRootTypes.add(entryMethodHolderTypeName);
        this.jprogram.addIndexedTypeName(entryMethodHolderTypeName);
        return entryMethodHolderTypeName;
    }

    private CompilationState constructJavaAst(PrecompilationContext precompilationContext) throws UnableToCompleteException {
        RebindPermutationOracle rpo = precompilationContext.getRebindPermutationOracle();
        CompilationState compilationState = rpo.getCompilationState();
        Memory.maybeDumpMemory("CompStateBuilt");
        this.recordJsoTypes(compilationState.getTypeOracle());
        this.unifyJavaAst(precompilationContext);
        if (this.options.isSoycEnabled() || this.options.isJsonSoycEnabled()) {
            SourceInfoCorrelator.exec(this.jprogram);
        }
        rpo.clear();
        HashSet<String> deletedTypeNames = this.options.isIncrementalCompileEnabled() ? this.getMinimalRebuildCache().computeDeletedTypeNames() : Sets.newHashSet();
        this.jprogram.typeOracle.computeBeforeAST(JTypeOracle.StandardTypes.createFrom(this.jprogram), this.jprogram.getDeclaredTypes(), this.jprogram.getModuleDeclaredTypes(), deletedTypeNames);
        return compilationState;
    }

    private String[] getReferencedJavaClasses() {
        class ClassNameVisitor
        extends JVisitor {
            List<String> classNames = new ArrayList<String>();

            ClassNameVisitor() {
            }

            @Override
            public boolean visit(JClassType x, Context ctx) {
                this.classNames.add(x.getName());
                return true;
            }
        }
        ClassNameVisitor v = new ClassNameVisitor();
        v.accept(this.jprogram);
        return v.classNames.toArray(new String[v.classNames.size()]);
    }

    private void logAstTypeMetrics(PrecompilationMetricsArtifact precompilationMetrics) {
        if (this.options.isCompilerMetricsEnabled()) {
            precompilationMetrics.setAstTypes(this.getReferencedJavaClasses());
        }
    }

    private void logTypeOracleMetrics(PrecompilationMetricsArtifact precompilationMetrics, CompilationState compilationState) {
        if (precompilationMetrics != null) {
            ArrayList<String> finalTypeOracleTypes = Lists.newArrayList();
            for (com.google.gwt.dev.javac.typemodel.JClassType type : compilationState.getTypeOracle().getTypes()) {
                finalTypeOracleTypes.add(type.getPackage().getName() + "." + type.getName());
            }
            precompilationMetrics.setFinalTypeOracleTypes(finalTypeOracleTypes);
        }
    }

    private Set<String> computeRootTypes(String[] entryPointTypeNames, String[] additionalRootTypes, CompilationState compilationState) {
        TreeSet<String> allRootTypes = Sets.newTreeSet();
        Iterables.addAll(allRootTypes, compilationState.getQualifiedJsInteropRootTypesNames());
        Collections.addAll(allRootTypes, entryPointTypeNames);
        Collections.addAll(allRootTypes, additionalRootTypes);
        allRootTypes.addAll(JProgram.CODEGEN_TYPES_SET);
        allRootTypes.addAll(this.jprogram.getTypeNamesToIndex());
        TypeOracle typeOracle = compilationState.getTypeOracle();
        for (com.google.gwt.core.ext.typeinfo.JClassType jClassType : typeOracle.getSingleJsoImplInterfaces()) {
            allRootTypes.add(typeOracle.getSingleJsoImpl(jClassType).getQualifiedSourceName());
        }
        return allRootTypes;
    }

    /*
     * WARNING - void declaration
     */
    private void recordJsoTypes(TypeOracle typeOracle) {
        void var5_7;
        if (!this.options.isIncrementalCompileEnabled()) {
            return;
        }
        HashSet<String> jsoTypeNames = Sets.newHashSet();
        com.google.gwt.dev.javac.typemodel.JClassType[] jClassTypeArray = typeOracle.getJavaScriptObject().getSubtypes();
        int n = jClassTypeArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            com.google.gwt.dev.javac.typemodel.JClassType jClassType = jClassTypeArray[var5_7];
            jsoTypeNames.add(jClassType.getQualifiedBinaryName());
            ++var5_7;
        }
        HashSet<String> singleJsoImplInterfaceNames = Sets.newHashSet();
        for (com.google.gwt.core.ext.typeinfo.JClassType jClassType : typeOracle.getSingleJsoImplInterfaces()) {
            singleJsoImplInterfaceNames.add(jClassType.getQualifiedBinaryName());
        }
        HashSet<String> dualJsoImplInterfaceNames = Sets.newHashSet();
        for (com.google.gwt.core.ext.typeinfo.JClassType jClassType : typeOracle.getDualJsoImplInterfaces()) {
            dualJsoImplInterfaceNames.add(jClassType.getQualifiedBinaryName());
        }
        this.compilerContext.getMinimalRebuildCache().setJsoTypeNames(jsoTypeNames, singleJsoImplInterfaceNames, dualJsoImplInterfaceNames);
    }

    private void synthesizeEntryMethodHolderInit(UnifyAst unifyAst, String[] entryPointTypeNames, String entryMethodHolderTypeName) throws UnableToCompleteException {
        JDeclaredType entryMethodHolderType = unifyAst.findType(entryMethodHolderTypeName, unifyAst.getSourceNameBasedTypeLocator());
        JDeclaredType gwtType = unifyAst.findType("com.google.gwt.core.client.GWT", unifyAst.getSourceNameBasedTypeLocator());
        JDeclaredType entryPointType = unifyAst.findType("com.google.gwt.core.client.EntryPoint", unifyAst.getSourceNameBasedTypeLocator());
        JMethod initMethod = entryMethodHolderType.findMethod("init()V", false);
        JMethod gwtCreateMethod = gwtType.findMethod("create(Ljava/lang/Class;)Ljava/lang/Object;", false);
        JBlock initMethodBlock = ((JMethodBody)initMethod.getBody()).getBlock();
        SourceInfo origin = initMethodBlock.getSourceInfo().makeChild();
        for (String entryPointTypeName : entryPointTypeNames) {
            JDeclaredType specificEntryPointType = unifyAst.findType(entryPointTypeName, unifyAst.getSourceNameBasedTypeLocator());
            if (specificEntryPointType == null) {
                this.logger.log(TreeLogger.ERROR, "Could not find module entry point class '" + entryPointTypeName + "'", null);
                throw new UnableToCompleteException();
            }
            JMethod onModuleLoadMethod = entryPointType.findMethod("onModuleLoad()V", true);
            JMethod specificOnModuleLoadMethod = specificEntryPointType.findMethod("onModuleLoad()V", true);
            if (specificOnModuleLoadMethod != null && specificOnModuleLoadMethod.isStatic()) {
                JMethodCall staticOnModuleLoadCall = new JMethodCall(origin, null, specificOnModuleLoadMethod, new JExpression[0]);
                initMethodBlock.addStmt(staticOnModuleLoadCall.makeStatement());
                continue;
            }
            JClassLiteral entryPointTypeClassLiteral = new JClassLiteral(origin, specificEntryPointType);
            JMethodCall createInstanceCall = new JMethodCall(origin, null, gwtCreateMethod, entryPointTypeClassLiteral);
            JCastOperation castToEntryPoint = new JCastOperation(origin, entryPointType, createInstanceCall);
            JMethodCall instanceOnModuleLoadCall = new JMethodCall(origin, (JExpression)castToEntryPoint, onModuleLoadMethod, new JExpression[0]);
            initMethodBlock.addStmt(instanceOnModuleLoadCall.makeStatement());
        }
    }

    private void unifyJavaAst(PrecompilationContext precompilationContext) throws UnableToCompleteException {
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.UNIFY_AST, new String[0]);
        RebindPermutationOracle rpo = precompilationContext.getRebindPermutationOracle();
        String[] entryPointTypeNames = precompilationContext.getEntryPoints();
        String[] additionalRootTypes = precompilationContext.getAdditionalRootTypes();
        Set<String> allRootTypes = this.computeRootTypes(entryPointTypeNames, additionalRootTypes, rpo.getCompilationState());
        String entryMethodHolderTypeName = this.buildEntryMethodHolder(rpo.getGeneratorContext(), entryPointTypeNames, allRootTypes);
        UnifyAst unifyAst = new UnifyAst(this.logger, this.compilerContext, this.jprogram, this.jsProgram, precompilationContext);
        unifyAst.addRootTypes(allRootTypes);
        if (entryMethodHolderTypeName != null) {
            this.synthesizeEntryMethodHolderInit(unifyAst, entryPointTypeNames, entryMethodHolderTypeName);
        }
        if (entryMethodHolderTypeName != null) {
            this.jprogram.addEntryMethod(this.jprogram.getIndexedMethod(Name.SourceName.getShortClassName(entryMethodHolderTypeName) + ".init"));
        }
        unifyAst.exec();
        event.end(new String[0]);
    }

    private void optimizeJavaToFixedPoint() throws InterruptedException {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, new String[0]);
        ArrayList<OptimizerStats> allOptimizerStats = Lists.newArrayList();
        int passCount = 0;
        int nodeCount = this.jprogram.getNodeCount();
        boolean atMaxLevel = this.options.getOptimizationLevel() == 9;
        int passLimit = atMaxLevel ? 100 : this.options.getOptimizationLevel();
        float minChangeRate = atMaxLevel ? 0.0f : 0.01f;
        FullOptimizerContext optimizerCtx = new FullOptimizerContext(this.jprogram);
        while (++passCount <= passLimit) {
            if (Thread.interrupted()) {
                optimizeEvent.end(new String[0]);
                throw new InterruptedException();
            }
            AstDumper.maybeDumpAST(this.jprogram);
            OptimizerStats stats = this.optimizeJavaOneTime("Pass " + passCount, nodeCount, optimizerCtx);
            allOptimizerStats.add(stats);
            int lastNodeCount = nodeCount;
            nodeCount = this.jprogram.getNodeCount();
            float nodeChangeRate = (float)stats.getNumMods() / (float)lastNodeCount;
            float sizeChangeRate = (float)(lastNodeCount - nodeCount) / (float)lastNodeCount;
            if (!(nodeChangeRate <= minChangeRate) || !(sizeChangeRate <= minChangeRate)) continue;
            break;
        }
        if (this.options.shouldOptimizeDataflow()) {
            this.logger.log(TreeLogger.Type.WARN, "Unsafe dataflow optimization enabled, disable with -XdisableOptimizeDataflow.");
            allOptimizerStats.add(DataflowOptimizer.exec(this.jprogram));
        }
        optimizeEvent.end(new String[0]);
    }

    private boolean shouldOptimize() {
        return this.options.getOptimizationLevel() > 0;
    }

    private ResolveRuntimeTypeReferences.TypeMapper getTypeMapper() {
        if (JjsUtils.closureStyleLiteralsNeeded(this.options)) {
            return new ResolveRuntimeTypeReferences.ClosureUniqueIdTypeMapper(this.jprogram);
        }
        if (this.options.useDetailedTypeIds()) {
            return new ResolveRuntimeTypeReferences.StringTypeMapper(this.jprogram);
        }
        return this.options.isIncrementalCompileEnabled() ? this.compilerContext.getMinimalRebuildCache().getTypeMapper() : new ResolveRuntimeTypeReferences.IntTypeMapper();
    }

    private ResolveRuntimeTypeReferences.TypeOrder getTypeOrder() {
        if (JjsUtils.closureStyleLiteralsNeeded(this.options)) {
            return ResolveRuntimeTypeReferences.TypeOrder.ALPHABETICAL;
        }
        if (this.options.useDetailedTypeIds()) {
            return ResolveRuntimeTypeReferences.TypeOrder.NONE;
        }
        return this.options.isIncrementalCompileEnabled() ? ResolveRuntimeTypeReferences.TypeOrder.ALPHABETICAL : ResolveRuntimeTypeReferences.TypeOrder.FREQUENCY;
    }

    private OptimizerStats optimizeJavaOneTime(String passName, int numNodes, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "phase", "loop");
        this.jprogram.typeOracle.recomputeAfterOptimizations(this.jprogram.getDeclaredTypes());
        OptimizerStats stats = new OptimizerStats(passName);
        JavaAstVerifier.assertProgramIsConsistent(this.jprogram);
        stats.add(Pruner.exec(this.jprogram, true, optimizerCtx).recordVisits(numNodes));
        stats.add(Finalizer.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        stats.add(MakeCallsStatic.exec(this.jprogram, this.options.shouldAddRuntimeChecks(), optimizerCtx).recordVisits(numNodes));
        stats.add(TypeTightener.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        stats.add(MethodCallTightener.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        stats.add(MethodCallSpecializer.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        stats.add(DeadCodeElimination.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        stats.add(MethodInliner.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        if (this.options.shouldInlineLiteralParameters()) {
            stats.add(SameParameterValueOptimizer.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        }
        if (this.options.shouldOrdinalizeEnums()) {
            stats.add(EnumOrdinalizer.exec(this.jprogram, optimizerCtx).recordVisits(numNodes));
        }
        optimizeEvent.end(new String[0]);
        return stats;
    }

    private MinimalRebuildCache getMinimalRebuildCache() {
        return this.compilerContext.getMinimalRebuildCache();
    }

    static {
        InternalCompilerException.preload();
    }

    private static class PermutationResultImpl
    implements PermutationResult {
        private final ArtifactSet artifacts = new ArtifactSet();
        private final byte[][] js;
        private final String jsStrongName;
        private final Permutation permutation;
        private final byte[] serializedSymbolMap;
        private final StatementRanges[] statementRanges;

        public PermutationResultImpl(String[] jsFragments, Permutation permutation, SymbolData[] symbolMap, StatementRanges[] statementRanges) {
            byte[][] bytes = new byte[jsFragments.length][];
            for (int i = 0; i < jsFragments.length; ++i) {
                bytes[i] = Util.getBytes(jsFragments[i]);
            }
            this.js = bytes;
            this.jsStrongName = Util.computeStrongName(bytes);
            this.permutation = permutation;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Util.writeObjectToStream(baos, new Object[]{symbolMap});
                this.serializedSymbolMap = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("Should never happen with in-memory stream", e);
            }
            this.statementRanges = statementRanges;
        }

        @Override
        public void addArtifacts(Collection<? extends Artifact<?>> newArtifacts) {
            this.artifacts.addAll(newArtifacts);
        }

        @Override
        public ArtifactSet getArtifacts() {
            return this.artifacts;
        }

        @Override
        public byte[][] getJs() {
            return this.js;
        }

        @Override
        public String getJsStrongName() {
            return this.jsStrongName;
        }

        @Override
        public Permutation getPermutation() {
            return this.permutation;
        }

        @Override
        public byte[] getSerializedSymbolMap() {
            return this.serializedSymbolMap;
        }

        @Override
        public StatementRanges[] getStatementRanges() {
            return this.statementRanges;
        }
    }
}

