/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.dev.jjs.HasSourceInfo;
import com.google.gwt.dev.jjs.SourceInfo;
import java.util.ArrayList;
import java.util.List;

public class InternalCompilerException
extends RuntimeException {
    private static final ThreadLocal<InternalCompilerException> pendingICE = new ThreadLocal();
    private final List<NodeInfo> nodeTrace = new ArrayList<NodeInfo>();

    public static void preload() {
        NodeInfo.preload();
        pendingICE.set(pendingICE.get());
    }

    public InternalCompilerException(HasSourceInfo node, String message, Throwable cause) {
        this(message, cause);
        this.addNode(node);
    }

    public InternalCompilerException(String message) {
        super(message);
    }

    public InternalCompilerException(String message, Throwable cause) {
        super(message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(HasSourceInfo node) {
        InternalCompilerException other = pendingICE.get();
        if (other != null) {
            return;
        }
        String className = null;
        String description = null;
        SourceInfo sourceInfo = null;
        try {
            pendingICE.set(this);
            className = node.getClass().getName();
            sourceInfo = node.getSourceInfo();
            description = node.toString();
        }
        catch (Throwable e) {
            if (description == null) {
                description = "<source info not available>";
            }
        }
        finally {
            pendingICE.set(null);
        }
        this.addNode(className, description, sourceInfo);
    }

    public void addNode(String className, String description, SourceInfo sourceInfo) {
        this.nodeTrace.add(new NodeInfo(className, description, sourceInfo));
    }

    public List<NodeInfo> getNodeTrace() {
        return this.nodeTrace;
    }

    public static final class NodeInfo {
        private final String className;
        private final String description;
        private final SourceInfo sourceInfo;

        static void preload() {
        }

        NodeInfo(String className, String description, SourceInfo sourceInfo) {
            this.className = className;
            this.description = description;
            this.sourceInfo = sourceInfo;
        }

        public String getClassName() {
            return this.className;
        }

        public String getDescription() {
            return this.description;
        }

        public SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }
    }
}

