/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceInfoCorrelation;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;

public abstract class CorrelationFactory
implements Serializable {
    public abstract Correlation by(JDeclaredType var1);

    public abstract Correlation by(JField var1);

    public abstract Correlation by(JMethod var1);

    public abstract Correlation by(Correlation.Literal var1);

    public abstract SourceInfo makeSourceInfo(SourceOrigin var1);

    public static final class RealCorrelationFactory
    extends CorrelationFactory {
        public static final CorrelationFactory INSTANCE = new RealCorrelationFactory();
        private static final Map<Correlation.Literal, Correlation> LITERAL_CORRELATIONS = new EnumMap<Correlation.Literal, Correlation>(Correlation.Literal.class);
        private final Map<Object, Correlation> canonicalMap = new MapMaker().weakKeys().weakValues().makeMap();

        private RealCorrelationFactory() {
        }

        @Override
        public Correlation by(JDeclaredType type) {
            Correlation toReturn = this.canonicalMap.get(type);
            if (toReturn == null) {
                toReturn = new Correlation(Correlation.Axis.CLASS, type.getName(), type);
                this.canonicalMap.put(type, toReturn);
            }
            return toReturn;
        }

        @Override
        public Correlation by(JField field) {
            Correlation toReturn = this.canonicalMap.get(field);
            if (toReturn == null) {
                toReturn = new Correlation(Correlation.Axis.FIELD, field.getEnclosingType().getName() + "::" + field.getName(), field);
                this.canonicalMap.put(field, toReturn);
            }
            return toReturn;
        }

        @Override
        public Correlation by(JMethod method) {
            Correlation toReturn = this.canonicalMap.get(method);
            if (toReturn == null) {
                toReturn = new Correlation(Correlation.Axis.METHOD, method.getJsniSignature(true, true), method);
                this.canonicalMap.put(method, toReturn);
            }
            return toReturn;
        }

        @Override
        public Correlation by(Correlation.Literal type) {
            assert (LITERAL_CORRELATIONS.containsKey((Object)type));
            return LITERAL_CORRELATIONS.get((Object)type);
        }

        @Override
        public SourceInfo makeSourceInfo(SourceOrigin origin) {
            return new SourceInfoCorrelation(origin);
        }

        static {
            for (Correlation.Literal l : Correlation.Literal.values()) {
                LITERAL_CORRELATIONS.put(l, new Correlation(Correlation.Axis.LITERAL, l.getDescription(), (Serializable)((Object)l)));
            }
        }
    }

    public static final class DummyCorrelationFactory
    extends CorrelationFactory {
        public static final CorrelationFactory INSTANCE = new DummyCorrelationFactory();

        private DummyCorrelationFactory() {
        }

        @Override
        public Correlation by(JDeclaredType type) {
            return null;
        }

        @Override
        public Correlation by(JField field) {
            return null;
        }

        @Override
        public Correlation by(JMethod method) {
            return null;
        }

        @Override
        public Correlation by(Correlation.Literal type) {
            return null;
        }

        @Override
        public SourceInfo makeSourceInfo(SourceOrigin origin) {
            return origin;
        }
    }
}

