/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs;

import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import java.io.Serializable;

public final class Correlation
implements Serializable {
    protected final Serializable astReference;
    protected final Axis axis;
    protected final String ident;

    Correlation(Axis axis, String ident, Serializable astReference) {
        if (axis == null) {
            throw new NullPointerException("axis");
        }
        if (ident == null) {
            throw new NullPointerException("ident");
        }
        if (astReference == null) {
            throw new NullPointerException("astReference");
        }
        this.axis = axis;
        this.ident = ident;
        this.astReference = astReference;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Correlation)) {
            return false;
        }
        Correlation c = (Correlation)obj;
        boolean astSame = this.astReference == c.astReference || this.astReference != null && this.astReference.equals(c.astReference);
        return this.axis == c.axis && astSame;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public JField getField() {
        if (this.axis == Axis.FIELD) {
            return (JField)this.astReference;
        }
        return null;
    }

    public String getIdent() {
        return this.ident;
    }

    public Literal getLiteral() {
        if (this.axis == Axis.LITERAL) {
            return (Literal)((Object)this.astReference);
        }
        return null;
    }

    public JMethod getMethod() {
        if (this.axis == Axis.METHOD) {
            return (JMethod)this.astReference;
        }
        return null;
    }

    public JDeclaredType getType() {
        if (this.axis == Axis.CLASS) {
            return (JDeclaredType)this.astReference;
        }
        if (this.axis == Axis.METHOD) {
            return ((JMethod)this.astReference).getEnclosingType();
        }
        if (this.axis == Axis.FIELD) {
            return ((JField)this.astReference).getEnclosingType();
        }
        return null;
    }

    public int hashCode() {
        return 37 * (this.axis == null ? 1 : this.axis.hashCode()) + (this.astReference == null ? 0 : this.astReference.hashCode()) + 13;
    }

    public String toString() {
        return this.axis.toString() + ": " + this.ident;
    }

    public static enum Literal {
        CLASS("class"),
        STRING("string");

        private final String description;

        private Literal(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum Axis {
        CLASS,
        FIELD,
        LITERAL,
        METHOD;

    }
}

