/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jdt;

import com.google.gwt.dev.jdt.SafeASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeRefVisitor
extends SafeASTVisitor {
    private final CompilationUnitDeclaration cud;

    public TypeRefVisitor(CompilationUnitDeclaration cud) {
        assert (cud != null);
        this.cud = cud;
    }

    @Override
    public void endVisit(ArrayQualifiedTypeReference x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(ArrayQualifiedTypeReference x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(ArrayTypeReference x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(ArrayTypeReference x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(MessageSend messageSend, BlockScope scope) {
        if (messageSend.binding != null && messageSend.binding.isStatic()) {
            this.maybeDispatch(messageSend, messageSend.actualReceiverType);
        }
    }

    @Override
    public void endVisit(ParameterizedQualifiedTypeReference x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(ParameterizedQualifiedTypeReference x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(ParameterizedSingleTypeReference x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(ParameterizedSingleTypeReference x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(QualifiedNameReference x, BlockScope scope) {
        if (x.binding instanceof FieldBinding) {
            this.maybeDispatch(x, x.fieldBinding().declaringClass);
        }
    }

    @Override
    public void endVisit(QualifiedTypeReference x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(QualifiedTypeReference x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(SingleTypeReference x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(SingleTypeReference x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(Wildcard x, BlockScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public void endVisit(Wildcard x, ClassScope scope) {
        this.maybeDispatch(x, x.resolvedType);
    }

    @Override
    public boolean visit(CompilationUnitDeclaration cud, CompilationUnitScope scope) {
        if (this.cud != cud) {
            throw new IllegalStateException("I will only visit the cud I was initialized with");
        }
        return true;
    }

    protected void onBinaryTypeRef(BinaryTypeBinding referencedType, CompilationUnitDeclaration unitOfReferrer, Expression expression) {
    }

    protected void onMissingTypeRef(MissingTypeBinding referencedType, CompilationUnitDeclaration unitOfReferrer, Expression expression) {
    }

    protected abstract void onTypeRef(SourceTypeBinding var1, CompilationUnitDeclaration var2);

    private void maybeDispatch(Expression expression, TypeBinding binding) {
        if (binding == null) {
            return;
        }
        if (binding instanceof SourceTypeBinding) {
            SourceTypeBinding type = (SourceTypeBinding)binding;
            this.onTypeRef(type, this.cud);
        } else if (binding instanceof ArrayBinding) {
            this.maybeDispatch(expression, ((ArrayBinding)binding).leafComponentType);
        } else if (binding instanceof MissingTypeBinding) {
            this.onMissingTypeRef((MissingTypeBinding)binding, this.cud, expression);
        } else if (binding instanceof BinaryTypeBinding) {
            this.onBinaryTypeRef((BinaryTypeBinding)binding, this.cud, expression);
        } else if (binding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding ptBinding = (ParameterizedTypeBinding)binding;
            this.maybeDispatch(expression, ptBinding.genericType());
        } else if (binding instanceof RawTypeBinding) {
            RawTypeBinding rawTypeBinding = (RawTypeBinding)binding;
            this.maybeDispatch(expression, rawTypeBinding.genericType());
        }
    }
}

