/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.BadTypeArgsException;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.ParseException;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.dev.javac.JavaSourceParser;
import com.google.gwt.dev.javac.typemodel.JArrayType;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JGenericType;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JPackage;
import com.google.gwt.dev.javac.typemodel.JParameter;
import com.google.gwt.dev.javac.typemodel.JParameterizedType;
import com.google.gwt.dev.javac.typemodel.JRealClassType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.javac.typemodel.JWildcardType;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.collect.IdentityHashMap;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeOracle
extends com.google.gwt.core.ext.typeinfo.TypeOracle {
    static final int MOD_ABSTRACT = 1;
    static final int MOD_FINAL = 2;
    static final int MOD_NATIVE = 4;
    static final int MOD_PRIVATE = 8;
    static final int MOD_PROTECTED = 16;
    static final int MOD_PUBLIC = 32;
    static final int MOD_STATIC = 64;
    static final int MOD_TRANSIENT = 128;
    static final int MOD_VOLATILE = 256;
    static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    static final JClassType[] NO_JCLASSES = new JClassType[0];
    static final JConstructor[] NO_JCTORS = new JConstructor[0];
    static final JField[] NO_JFIELDS = new JField[0];
    static final JMethod[] NO_JMETHODS = new JMethod[0];
    static final JPackage[] NO_JPACKAGES = new JPackage[0];
    static final JParameter[] NO_JPARAMS = new JParameter[0];
    static final JType[] NO_JTYPES = new JType[0];
    static final String[] NO_STRINGS = new String[0];
    private static final String JSO_CLASS = "com.google.gwt.core.client.JavaScriptObject";
    private final Map<String, JRealClassType> allTypes = new HashMap<String, JRealClassType>();
    private final Map<JType, JArrayType> arrayTypes = new MapMaker().weakKeys().weakValues().makeMap();
    private JClassType javaLangObject;
    private JClassType javaScriptObject;
    private final JavaSourceParser javaSourceParser = new JavaSourceParser();
    private final Map<JClassType, JClassType> jsoSingleImpls = new IdentityHashMap<JClassType, JClassType>();
    private final Set<JClassType> jsoDualImpls = Sets.newHashSet();
    private final Map<String, JPackage> packages = new HashMap<String, JPackage>();
    private final Map<ParameterizedTypeKey, JParameterizedType> parameterizedTypes = new MapMaker().weakValues().makeMap();
    private final List<JRealClassType> recentTypes = new ArrayList<JRealClassType>();
    private JWildcardType unboundWildCardType;
    private final Map<WildCardKey, JWildcardType> wildcardTypes = new MapMaker().weakValues().makeMap();

    public static void sort(JClassType[] types) {
        Arrays.sort(types, new Comparator<JClassType>(){

            @Override
            public int compare(JClassType type1, JClassType type2) {
                String name1 = type1.getQualifiedSourceName();
                String name2 = type2.getQualifiedSourceName();
                return name1.compareTo(name2);
            }
        });
    }

    static String[] modifierBitsToNamesForField(int bits) {
        List<String> strings = TypeOracle.modifierBitsToNamesForMethodsAndFields(bits);
        if (0 != (bits & 0x100)) {
            strings.add("volatile");
        }
        if (0 != (bits & 0x80)) {
            strings.add("transient");
        }
        return strings.toArray(NO_STRINGS);
    }

    static String[] modifierBitsToNamesForMethod(int bits) {
        List<String> strings = TypeOracle.modifierBitsToNamesForMethodsAndFields(bits);
        if (0 != (bits & 1)) {
            strings.add("abstract");
        }
        if (0 != (bits & 4)) {
            strings.add("native");
        }
        return strings.toArray(NO_STRINGS);
    }

    private static JClassType[] cast(com.google.gwt.core.ext.typeinfo.JClassType[] extTypeArgs) {
        JClassType[] result = new JClassType[extTypeArgs.length];
        System.arraycopy(extTypeArgs, 0, result, 0, extTypeArgs.length);
        return result;
    }

    private static List<String> modifierBitsToNamesForMethodsAndFields(int bits) {
        ArrayList<String> strings = new ArrayList<String>();
        if (0 != (bits & 0x20)) {
            strings.add("public");
        }
        if (0 != (bits & 8)) {
            strings.add("private");
        }
        if (0 != (bits & 0x10)) {
            strings.add("protected");
        }
        if (0 != (bits & 0x40)) {
            strings.add("static");
        }
        if (0 != (bits & 2)) {
            strings.add("final");
        }
        return strings;
    }

    public TypeOracle() {
        this.getOrCreatePackage("");
    }

    @Override
    public JPackage findPackage(String pkgName) {
        return this.packages.get(pkgName);
    }

    @Override
    public JClassType findType(String name) {
        assert (Name.isSourceName(name)) : name + " is not a source name";
        return this.allTypes.get(name);
    }

    @Override
    public JClassType findType(String pkgName, String typeName) {
        JClassType type;
        assert (Name.isSourceName(typeName));
        JPackage pkg = this.findPackage(pkgName);
        if (pkg != null && (type = pkg.findType(typeName)) != null) {
            return type;
        }
        return null;
    }

    @Override
    public JArrayType getArrayType(JType componentType) {
        JArrayType arrayType = this.arrayTypes.get(componentType);
        if (arrayType == null) {
            arrayType = new JArrayType(componentType, this);
            this.arrayTypes.put(componentType, arrayType);
        }
        return arrayType;
    }

    @Override
    public JClassType getJavaLangObject() {
        if (this.javaLangObject == null) {
            this.javaLangObject = this.findType("java.lang.Object");
            assert (this.javaLangObject != null);
        }
        return this.javaLangObject;
    }

    public JClassType getJavaScriptObject() {
        if (this.javaScriptObject == null) {
            this.javaScriptObject = this.findType(JSO_CLASS);
            assert (this.javaScriptObject != null);
        }
        return this.javaScriptObject;
    }

    @Override
    public JPackage getOrCreatePackage(String name) {
        JPackage pkg;
        int i = name.lastIndexOf(46);
        if (i != -1) {
            this.getOrCreatePackage(name.substring(0, i));
        }
        if ((pkg = this.packages.get(name)) == null) {
            pkg = new JPackage(name);
            this.packages.put(name, pkg);
        }
        return pkg;
    }

    @Override
    public JPackage getPackage(String pkgName) throws NotFoundException {
        JPackage result = this.findPackage(pkgName);
        if (result == null) {
            throw new NotFoundException(pkgName);
        }
        return result;
    }

    public JPackage[] getPackages() {
        return this.packages.values().toArray(NO_JPACKAGES);
    }

    @Override
    public JParameterizedType getParameterizedType(com.google.gwt.core.ext.typeinfo.JGenericType extGenericType, com.google.gwt.core.ext.typeinfo.JClassType extEnclosingType, com.google.gwt.core.ext.typeinfo.JClassType[] extTypeArgs) {
        JGenericType genericType = (JGenericType)extGenericType;
        JClassType enclosingType = (JClassType)extEnclosingType;
        com.google.gwt.core.ext.typeinfo.JClassType[] typeArgs = TypeOracle.cast(extTypeArgs);
        ParameterizedTypeKey key = new ParameterizedTypeKey(genericType, enclosingType, typeArgs);
        JParameterizedType result = this.parameterizedTypes.get(key);
        if (result != null) {
            return result;
        }
        if (genericType.isMemberType() && !genericType.isStatic() && genericType.getEnclosingType().isGenericType() != null && enclosingType.isParameterized() == null && enclosingType.isRawType() == null) {
            throw new IllegalArgumentException("Generic type '" + genericType.getParameterizedQualifiedSourceName() + "' is a non-static member type, but the enclosing type '" + enclosingType.getQualifiedSourceName() + "' is not a parameterized or raw type");
        }
        JTypeParameter[] typeParameters = genericType.getTypeParameters();
        if (typeArgs.length < typeParameters.length) {
            throw new IllegalArgumentException("Not enough type arguments were specified to parameterize '" + genericType.getParameterizedQualifiedSourceName() + "'");
        }
        result = new JParameterizedType(genericType, enclosingType, (JClassType[])typeArgs);
        this.parameterizedTypes.put(key, result);
        return result;
    }

    @Override
    public JParameterizedType getParameterizedType(com.google.gwt.core.ext.typeinfo.JGenericType genericType, com.google.gwt.core.ext.typeinfo.JClassType[] typeArgs) {
        return this.getParameterizedType(genericType, null, typeArgs);
    }

    @Override
    public JClassType getSingleJsoImpl(com.google.gwt.core.ext.typeinfo.JClassType intf) {
        assert (intf.isInterface() == intf);
        return this.jsoSingleImpls.get(intf);
    }

    @Override
    public Set<? extends com.google.gwt.core.ext.typeinfo.JClassType> getSingleJsoImplInterfaces() {
        return Collections.unmodifiableSet(this.jsoSingleImpls.keySet());
    }

    public Set<? extends com.google.gwt.core.ext.typeinfo.JClassType> getDualJsoImplInterfaces() {
        return Collections.unmodifiableSet(this.jsoDualImpls);
    }

    @Override
    public JClassType getType(String name) throws NotFoundException {
        assert (Name.isSourceName(name));
        JClassType type = this.findType(name);
        if (type == null) {
            throw new NotFoundException(name);
        }
        return type;
    }

    @Override
    public JClassType getType(String pkgName, String topLevelTypeSimpleName) throws NotFoundException {
        assert (Name.isSourceName(topLevelTypeSimpleName));
        JClassType type = this.findType(pkgName, topLevelTypeSimpleName);
        if (type == null) {
            throw new NotFoundException(pkgName + "." + topLevelTypeSimpleName);
        }
        return type;
    }

    public JClassType[] getTypes() {
        Collection<JRealClassType> values = this.allTypes.values();
        JClassType[] result = values.toArray(new JClassType[values.size()]);
        Arrays.sort(result, new Comparator<JClassType>(){

            @Override
            public int compare(JClassType o1, JClassType o2) {
                return o1.getQualifiedSourceName().compareTo(o2.getQualifiedSourceName());
            }
        });
        return result;
    }

    @Override
    public JWildcardType getWildcardType(JWildcardType.BoundType boundType, com.google.gwt.core.ext.typeinfo.JClassType extTypeBound) {
        JClassType typeBound = (JClassType)extTypeBound;
        if (typeBound == this.getJavaLangObject() && (boundType == JWildcardType.BoundType.UNBOUND || boundType == JWildcardType.BoundType.EXTENDS)) {
            if (this.unboundWildCardType == null) {
                this.unboundWildCardType = new JWildcardType(JWildcardType.BoundType.UNBOUND, typeBound);
            }
            return this.unboundWildCardType;
        }
        WildCardKey key = new WildCardKey(boundType, typeBound);
        JWildcardType result = this.wildcardTypes.get(key);
        if (result != null) {
            return result;
        }
        result = new JWildcardType(boundType, typeBound);
        this.wildcardTypes.put(key, result);
        return result;
    }

    @Override
    public JType parse(String type) throws TypeOracleException {
        type = type.replaceAll("\\\\s", "");
        return this.parseImpl(type);
    }

    public void addNewType(JRealClassType newType) {
        String fqcn = newType.getQualifiedSourceName();
        assert (!this.allTypes.containsKey(fqcn)) : "TypeOracle already contains " + fqcn;
        this.allTypes.put(fqcn, newType);
        this.recentTypes.add(newType);
    }

    void finish() {
        this.computeHierarchyRelationships();
        this.computeSingleJsoImplData();
        this.computeDualJsoImplData();
        this.recentTypes.clear();
    }

    JavaSourceParser getJavaSourceParser() {
        return this.javaSourceParser;
    }

    private List<JClassType> classChain(JClassType cls) {
        LinkedList<JClassType> chain = new LinkedList<JClassType>();
        while (cls != null) {
            chain.addFirst(cls);
            cls = cls.getSuperclass();
        }
        return chain;
    }

    private boolean classFullyImplements(JClassType cls, JClassType intf) {
        if (intf.getMethods().length > 0 && !intf.isAssignableFrom(cls)) {
            return false;
        }
        for (JMethod meth : intf.getInheritableMethods()) {
            if (this.classImplementsMethod(cls, meth)) continue;
            return false;
        }
        return true;
    }

    private boolean classImplementsMethod(JClassType cls, JMethod meth) {
        while (cls != null) {
            JMethod found = cls.findMethod(meth.getName(), meth.getParameterTypes());
            if (found != null && !found.isAbstract()) {
                return true;
            }
            cls = cls.getSuperclass();
        }
        return false;
    }

    private void computeHierarchyRelationships() {
        for (JClassType jClassType : this.recentTypes) {
            jClassType.notifySuperTypes();
        }
    }

    private void computeDualJsoImplData() {
        JClassType jsoType = this.findType(JSO_CLASS);
        if (jsoType == null) {
            return;
        }
        block0: for (JClassType jsoInterface : this.jsoSingleImpls.keySet()) {
            for (JClassType subtype : jsoInterface.getSubtypes()) {
                if (jsoType.isAssignableFrom(subtype)) continue;
                this.jsoDualImpls.add(jsoInterface);
                continue block0;
            }
        }
    }

    private void computeSingleJsoImplData() {
        JClassType jsoType = this.findType(JSO_CLASS);
        if (jsoType == null) {
            return;
        }
        for (JClassType jClassType : this.recentTypes) {
            if (!jsoType.isAssignableFrom(jClassType)) continue;
            for (JClassType intf : JClassType.getFlattenedSuperTypeHierarchy(jClassType)) {
                if (intf instanceof JParameterizedType) {
                    intf = ((JParameterizedType)intf).getBaseType();
                }
                if (intf.isInterface() == null) continue;
                if (intf.getOverridableMethods().length == 0) {
                    this.jsoSingleImpls.put(intf, jsoType);
                    continue;
                }
                JClassType previousType = this.jsoSingleImpls.get(intf);
                if (previousType == null) {
                    this.jsoSingleImpls.put(intf, jClassType);
                    continue;
                }
                if (jClassType.isAssignableFrom(previousType)) {
                    this.jsoSingleImpls.put(intf, jClassType);
                    continue;
                }
                if (jClassType.isAssignableTo(previousType)) continue;
                JClassType impl = this.findFullyImplementingBase(intf, jClassType, previousType);
                if (impl != null) {
                    this.jsoSingleImpls.put(intf, impl);
                    continue;
                }
                throw new InternalCompilerException("Already seen an implementing JSO subtype (" + previousType.getName() + ") for interface (" + intf.getName() + ") while examining newly-added type (" + jClassType.getName() + "). This is a bug in JSORestrictionsChecker.");
            }
        }
    }

    private JClassType findFullyImplementingBase(JClassType intf, JClassType a, JClassType b) {
        JClassType common = this.findNearestCommonBase(a, b);
        if (this.classFullyImplements(common, intf)) {
            return common;
        }
        return null;
    }

    private JClassType findNearestCommonBase(JClassType a, JClassType b) {
        List<JClassType> as = this.classChain(a);
        List<JClassType> bs = this.classChain(b);
        JClassType match = null;
        Iterator<JClassType> ait = as.iterator();
        Iterator<JClassType> bit = bs.iterator();
        while (ait.hasNext() && bit.hasNext() && (a = ait.next()).equals(b = bit.next())) {
            match = a;
        }
        return match;
    }

    private JType parseImpl(String type) throws NotFoundException, ParseException, BadTypeArgsException {
        if (type.endsWith("[]")) {
            String remainder = type.substring(0, type.length() - 2);
            JType componentType = this.parseImpl(remainder);
            return this.getArrayType(componentType);
        }
        if (type.endsWith(">")) {
            int bracket = type.indexOf(60);
            if (bracket == -1) {
                throw new ParseException("Mismatched brackets; expected '<' to match subsequent '>'");
            }
            String rawTypeName = type.substring(0, bracket);
            JType rawType = this.parseImpl(rawTypeName);
            if (rawType.isParameterized() != null) {
                throw new BadTypeArgsException("Only non-parameterized classes and interface can be parameterized");
            }
            if (rawType.isClassOrInterface() == null) {
                throw new BadTypeArgsException("Only classes and interface can be parameterized, so " + rawType.getQualifiedSourceName() + " cannot be used in this context");
            }
            if (rawType.isGenericType() == null) {
                throw new BadTypeArgsException("'" + rawType.getQualifiedSourceName() + "' is not a generic type; only generic types can be parameterized");
            }
            String typeArgContents = type.substring(bracket + 1, type.length() - 1);
            com.google.gwt.core.ext.typeinfo.JClassType[] typeArgs = this.parseTypeArgContents(typeArgContents);
            return this.getParameterizedType(rawType.isGenericType(), typeArgs);
        }
        JType result = JPrimitiveType.parse(type);
        if (result != null) {
            return result;
        }
        result = this.findType(type);
        if (result != null) {
            return result;
        }
        throw new NotFoundException("Unable to recognize '" + type + "' as a type name (is it fully qualified?)");
    }

    private void parseTypeArgComponent(List<JClassType> typeArgList, String typeArgComponent) throws NotFoundException, ParseException, BadTypeArgsException {
        JType typeArg = this.parseImpl(typeArgComponent);
        if (typeArg.isPrimitive() != null) {
            throw new BadTypeArgsException("Type arguments cannot be primitives, so '" + typeArg.getQualifiedSourceName() + "' cannot be used in this context");
        }
        typeArgList.add((JClassType)typeArg);
    }

    private JClassType[] parseTypeArgContents(String typeArgContents) throws ParseException, NotFoundException, BadTypeArgsException {
        ArrayList<JClassType> typeArgList = new ArrayList<JClassType>();
        int start = 0;
        int length = typeArgContents.length();
        block5: for (int offset = 0; offset < length; ++offset) {
            char ch = typeArgContents.charAt(offset);
            switch (ch) {
                case '<': {
                    int depth = 1;
                    while (depth > 0) {
                        if (++offset == length) {
                            throw new ParseException("Mismatched brackets; expected '<' to match subsequent '>'");
                        }
                        char ich = typeArgContents.charAt(offset);
                        if (ich == '<') {
                            ++depth;
                            continue;
                        }
                        if (ich != '>') continue;
                        --depth;
                    }
                    continue block5;
                }
                case '>': {
                    throw new ParseException("No matching '<' for '>'");
                }
                case ',': {
                    String typeArgComponent = typeArgContents.substring(start, offset);
                    this.parseTypeArgComponent(typeArgList, typeArgComponent);
                    start = offset + 1;
                    continue block5;
                }
            }
        }
        String typeArgComponent = typeArgContents.substring(start);
        this.parseTypeArgComponent(typeArgList, typeArgComponent);
        JClassType[] typeArgs = typeArgList.toArray(new JClassType[typeArgList.size()]);
        return typeArgs;
    }

    private static class WildCardKey {
        private final JWildcardType.BoundType boundType;
        private final JClassType typeBound;

        public WildCardKey(JWildcardType.BoundType boundType, JClassType typeBound) {
            this.boundType = boundType;
            this.typeBound = typeBound;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WildCardKey)) {
                return false;
            }
            WildCardKey other = (WildCardKey)obj;
            return this.boundType == other.boundType && this.typeBound == other.typeBound;
        }

        public int hashCode() {
            return 29 * this.typeBound.hashCode() + this.boundType.hashCode();
        }
    }

    private static class ParameterizedTypeKey {
        private final JClassType enclosingType;
        private final JGenericType genericType;
        private final com.google.gwt.core.ext.typeinfo.JClassType[] typeArgs;

        public ParameterizedTypeKey(JGenericType genericType, JClassType enclosingType, com.google.gwt.core.ext.typeinfo.JClassType[] typeArgs) {
            this.genericType = genericType;
            this.enclosingType = enclosingType;
            this.typeArgs = typeArgs;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterizedTypeKey)) {
                return false;
            }
            ParameterizedTypeKey other = (ParameterizedTypeKey)obj;
            return this.genericType == other.genericType && this.enclosingType == other.enclosingType && Arrays.equals(this.typeArgs, other.typeArgs);
        }

        public int hashCode() {
            return 29 * this.genericType.hashCode() + 17 * (this.enclosingType == null ? 0 : this.enclosingType.hashCode()) + Arrays.hashCode(this.typeArgs);
        }
    }
}

