/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.dev.javac.typemodel.AbstractMembers;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class Members
extends AbstractMembers {
    private List<JConstructor> constructors = Lists.create();
    private Map<String, JField> fieldMap = Maps.create();
    private List<JField> fields = Lists.create();
    private Map<String, Object> methodMap = Maps.create();
    private List<String> methodOrder = Lists.create();
    private Map<String, JClassType> nestedTypes = Maps.create();

    public Members(JClassType classType) {
        super(classType);
    }

    @Override
    public JField findField(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public JField[] getFields() {
        return this.fields.toArray(TypeOracle.NO_JFIELDS);
    }

    @Override
    public JMethod[] getMethods() {
        ArrayList<JMethod> result = new ArrayList<JMethod>();
        for (String methodName : this.methodOrder) {
            Object object = this.methodMap.get(methodName);
            if (object instanceof JMethod) {
                result.add((JMethod)object);
                continue;
            }
            result.addAll((List)object);
        }
        return result.toArray(TypeOracle.NO_JMETHODS);
    }

    @Override
    public JMethod[] getOverloads(String name) {
        Object object = this.methodMap.get(name);
        if (object == null) {
            return TypeOracle.NO_JMETHODS;
        }
        if (object instanceof JMethod) {
            return new JMethod[]{(JMethod)object};
        }
        List overloads = (List)object;
        return overloads.toArray(TypeOracle.NO_JMETHODS);
    }

    @Override
    protected void addConstructor(JConstructor ctor) {
        assert (!this.constructors.contains(ctor));
        this.constructors = Lists.add(this.constructors, ctor);
    }

    @Override
    protected void addField(JField field) {
        assert (!this.fieldMap.containsKey(field.getName()));
        this.fieldMap = Maps.put(this.fieldMap, field.getName(), field);
        this.fields = Lists.add(this.fields, field);
    }

    @Override
    protected void addMethod(JMethod method) {
        String methodName = method.getName();
        Object object = this.methodMap.get(methodName);
        if (object == null) {
            this.methodMap = Maps.put(this.methodMap, methodName, method);
            this.methodOrder = Lists.add(this.methodOrder, methodName);
        } else if (object instanceof JMethod) {
            ArrayList<JMethod> overloads = new ArrayList<JMethod>(2);
            overloads.add((JMethod)object);
            overloads.add(method);
            this.methodMap = Maps.put(this.methodMap, methodName, overloads);
        } else {
            List overloads = (List)object;
            overloads.add(method);
        }
    }

    @Override
    protected List<JConstructor> doGetConstructors() {
        return this.constructors;
    }

    @Override
    protected Map<String, JClassType> doGetNestedTypes() {
        return this.nestedTypes;
    }

    void addNestedType(JClassType type) {
        this.nestedTypes = Maps.put(this.nestedTypes, type.getSimpleSourceName(), type);
    }
}

