/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.javac.typemodel.Annotations;
import com.google.gwt.dev.javac.typemodel.JArrayType;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JEnumType;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JGenericType;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JPackage;
import com.google.gwt.dev.javac.typemodel.JParameterizedType;
import com.google.gwt.dev.javac.typemodel.JRawType;
import com.google.gwt.dev.javac.typemodel.JWildcardType;
import com.google.gwt.dev.javac.typemodel.Members;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.IdentitySets;
import com.google.gwt.dev.util.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JRealClassType
extends JClassType
implements com.google.gwt.core.ext.typeinfo.JRealClassType {
    private Set<JClassType> allSubtypes = IdentitySets.create();
    private final Annotations annotations = new Annotations();
    private final JPackage declaringPackage;
    private JClassType enclosingType;
    private List<JClassType> interfaces = Lists.create();
    private final boolean isInterface;
    private String lazyQualifiedBinaryName;
    private String lazyQualifiedName;
    private final Members members = new Members(this);
    private int modifierBits;
    private final String simpleName;
    private final String nestedSourceName;
    private final TypeOracle typeOracle;
    private JClassType superclass;
    private long lastModifiedTime;

    JRealClassType(TypeOracle typeOracle, JPackage declaringPackage, String enclosingSimpleName, String simpleName, boolean isInterface) {
        this.typeOracle = typeOracle;
        this.declaringPackage = declaringPackage;
        this.simpleName = StringInterner.get().intern(simpleName);
        this.isInterface = isInterface;
        if (enclosingSimpleName == null) {
            declaringPackage.addType(this);
            this.nestedSourceName = simpleName;
        } else {
            this.nestedSourceName = StringInterner.get().intern(enclosingSimpleName + "." + simpleName);
        }
        typeOracle.addNewType(this);
    }

    public void addLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    public void addModifierBits(int bits) {
        this.modifierBits |= bits;
    }

    @Override
    public JConstructor findConstructor(JType[] paramTypes) {
        return this.members.findConstructor(paramTypes);
    }

    @Override
    public JField findField(String name) {
        return this.members.findField(name);
    }

    @Override
    public JMethod findMethod(String name, JType[] paramTypes) {
        return this.members.findMethod(name, paramTypes);
    }

    @Override
    public JClassType findNestedType(String typeName) {
        return this.members.findNestedType(typeName);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.annotations.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.getAnnotations();
    }

    @Override
    public JConstructor getConstructor(JType[] paramTypes) throws NotFoundException {
        return this.members.getConstructor(paramTypes);
    }

    @Override
    public JConstructor[] getConstructors() {
        return this.members.getConstructors();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.getDeclaredAnnotations();
    }

    @Override
    public JClassType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public JClassType getErasedType() {
        return this;
    }

    @Override
    public JField getField(String name) {
        return this.members.getField(name);
    }

    @Override
    public JField[] getFields() {
        return this.members.getFields();
    }

    @Override
    public JClassType[] getImplementedInterfaces() {
        return this.interfaces.toArray(TypeOracle.NO_JCLASSES);
    }

    @Override
    public JMethod[] getInheritableMethods() {
        return this.members.getInheritableMethods();
    }

    @Override
    public String getJNISignature() {
        String typeName = this.nestedSourceName.replace('.', '$');
        String packageName = this.getPackage().getName().replace('.', '/');
        if (packageName.length() > 0) {
            packageName = packageName + "/";
        }
        return "L" + packageName + typeName + ";";
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public JMethod getMethod(String name, JType[] paramTypes) throws NotFoundException {
        return this.members.getMethod(name, paramTypes);
    }

    @Override
    public JMethod[] getMethods() {
        return this.members.getMethods();
    }

    @Override
    public String getName() {
        return this.nestedSourceName;
    }

    @Override
    public JClassType getNestedType(String typeName) throws NotFoundException {
        return this.members.getNestedType(typeName);
    }

    @Override
    public JClassType[] getNestedTypes() {
        return this.members.getNestedTypes();
    }

    @Override
    public TypeOracle getOracle() {
        return this.typeOracle;
    }

    @Override
    public JMethod[] getOverloads(String name) {
        return this.members.getOverloads(name);
    }

    @Override
    public JMethod[] getOverridableMethods() {
        return this.members.getOverridableMethods();
    }

    @Override
    public JPackage getPackage() {
        return this.declaringPackage;
    }

    @Override
    public String getQualifiedBinaryName() {
        if (this.lazyQualifiedBinaryName == null) {
            this.lazyQualifiedBinaryName = "";
            JPackage pkg = this.getPackage();
            if (!pkg.isDefault()) {
                this.lazyQualifiedBinaryName = pkg.getName() + ".";
            }
            this.lazyQualifiedBinaryName = this.lazyQualifiedBinaryName + this.nestedSourceName.replace('.', '$');
        }
        return this.lazyQualifiedBinaryName;
    }

    @Override
    public String getQualifiedSourceName() {
        if (this.lazyQualifiedName == null) {
            JPackage pkg = this.getPackage();
            this.lazyQualifiedName = !pkg.isDefault() ? pkg.getName() + "." + this.nestedSourceName : this.nestedSourceName;
            this.lazyQualifiedName = StringInterner.get().intern(this.lazyQualifiedName);
        }
        return this.lazyQualifiedName;
    }

    @Override
    public String getSimpleSourceName() {
        return this.simpleName;
    }

    @Override
    public JClassType[] getSubtypes() {
        return this.allSubtypes.toArray(TypeOracle.NO_JCLASSES);
    }

    @Override
    public JClassType getSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isAbstract() {
        return 0 != (this.modifierBits & 1);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.isAnnotationPresent(annotationClass);
    }

    @Override
    public JArrayType isArray() {
        return null;
    }

    @Override
    public JClassType isClass() {
        return this.isInterface ? null : this;
    }

    @Override
    public boolean isDefaultInstantiable() {
        if (this.isInterface() != null || this.isAbstract()) {
            return false;
        }
        if (this.isMemberType() && !this.isStatic()) {
            return false;
        }
        if (this.getConstructors().length == 0) {
            return true;
        }
        JConstructor ctor = this.findConstructor(TypeOracle.NO_JTYPES);
        return ctor != null;
    }

    @Override
    public JEnumType isEnum() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return 0 != (this.getModifierBits() & 2);
    }

    @Override
    public JGenericType isGenericType() {
        return null;
    }

    @Override
    public JClassType isInterface() {
        return this.isInterface ? this : null;
    }

    @Override
    public boolean isMemberType() {
        return this.enclosingType != null;
    }

    @Override
    public JParameterizedType isParameterized() {
        return null;
    }

    @Override
    public JPrimitiveType isPrimitive() {
        return null;
    }

    @Override
    public boolean isPrivate() {
        return 0 != (this.modifierBits & 8);
    }

    @Override
    public boolean isProtected() {
        return 0 != (this.modifierBits & 0x10);
    }

    @Override
    public boolean isPublic() {
        return 0 != (this.modifierBits & 0x20);
    }

    @Override
    public JRawType isRawType() {
        return null;
    }

    @Override
    public boolean isStatic() {
        return 0 != (this.modifierBits & 0x40);
    }

    @Override
    public JWildcardType isWildcard() {
        return null;
    }

    @Override
    public String toString() {
        if (this.isInterface) {
            return "interface " + this.getQualifiedSourceName();
        }
        return "class " + this.getQualifiedSourceName();
    }

    @Override
    protected void acceptSubtype(JClassType me) {
        this.allSubtypes = IdentitySets.add(this.allSubtypes, me);
        this.notifySuperTypesOf(me);
    }

    @Override
    protected void addConstructor(JConstructor ctor) {
        this.members.addConstructor(ctor);
    }

    @Override
    protected void addField(JField field) {
        this.members.addField(field);
    }

    @Override
    protected void addMethod(JMethod method) {
        this.members.addMethod(method);
    }

    @Override
    protected void addNestedType(JClassType type) {
        this.members.addNestedType(type);
    }

    @Override
    protected JClassType findNestedTypeImpl(String[] typeName, int index) {
        return this.members.findNestedTypeImpl(typeName, index);
    }

    @Override
    protected void getInheritableMethodsOnSuperclassesAndThisClass(Map<String, JMethod> methodsBySignature) {
        this.members.getInheritableMethodsOnSuperclassesAndThisClass(methodsBySignature);
    }

    @Override
    protected void getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(Map<String, JMethod> methodsBySignature) {
        this.members.getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(methodsBySignature);
    }

    @Override
    protected int getModifierBits() {
        return this.modifierBits;
    }

    @Override
    protected void notifySuperTypesOf(JClassType me) {
        if (this.superclass != null) {
            this.superclass.acceptSubtype(me);
        }
        for (JClassType intf : this.interfaces) {
            intf.acceptSubtype(me);
        }
    }

    @Override
    protected void removeSubtype(JClassType me) {
        this.allSubtypes = IdentitySets.remove(this.allSubtypes, me);
        if (this.superclass != null) {
            this.superclass.removeSubtype(me);
        }
        for (JClassType intf : this.interfaces) {
            intf.removeSubtype(me);
        }
    }

    void addAnnotations(Map<Class<? extends Annotation>, Annotation> declaredAnnotations) {
        this.annotations.addAnnotations(declaredAnnotations);
    }

    @Override
    void addImplementedInterface(JClassType intf) {
        assert (intf != null);
        this.interfaces = Lists.add(this.interfaces, intf);
    }

    @Override
    JRealClassType getSubstitutedType(JParameterizedType parameterizedType) {
        return this;
    }

    @Override
    void notifySuperTypes() {
        this.notifySuperTypesOf(this);
    }

    @Override
    void removeFromSupertypes() {
        this.removeSubtype(this);
    }

    void setEnclosingType(JClassType enclosingType) {
        assert (this.enclosingType == null);
        assert (enclosingType != null);
        this.enclosingType = enclosingType;
        JRawType rawType = enclosingType.isRawType();
        if (rawType != null) {
            enclosingType = rawType.getGenericType();
        }
        enclosingType.addNestedType(this);
    }

    @Override
    void setSuperclass(JClassType type) {
        JRealClassType realSuperType;
        assert (type != null);
        assert (this.isInterface() == null);
        this.superclass = type;
        if (type.isParameterized() != null) {
            realSuperType = type.isParameterized().getBaseType();
        } else if (type.isRawType() != null) {
            realSuperType = type.isRawType().getGenericType();
        } else if (type instanceof JRealClassType) {
            realSuperType = (JRealClassType)type;
        } else {
            throw new IllegalArgumentException("Unknown type for " + type);
        }
        this.annotations.setParent(realSuperType.annotations);
    }
}

