/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.javac.typemodel.AbstractMembers;
import com.google.gwt.dev.javac.typemodel.DelegateMembers;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JGenericType;
import com.google.gwt.dev.javac.typemodel.JMaybeParameterizedType;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JRawType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.javac.typemodel.JWildcardType;
import com.google.gwt.dev.javac.typemodel.Substitution;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.collect.IdentityHashMap;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JParameterizedType
extends JMaybeParameterizedType
implements com.google.gwt.core.ext.typeinfo.JParameterizedType {
    private final JClassType enclosingType;
    private List<JClassType> interfaces;
    private Map<JTypeParameter, JClassType> lazySubstitutionMap;
    private JClassType lazySuperclass;
    private final AbstractMembers members;
    private final List<JClassType> typeArgs;

    private static JParameterizedType createParameterizedTypeRecursive(JGenericType baseType, Map<JTypeParameter, JClassType> substitutionMap) {
        JGenericType isGenericEnclosingType;
        JClassType enclosingType = baseType.getEnclosingType();
        if (baseType.isMemberType() && !baseType.isStatic() && (isGenericEnclosingType = enclosingType.isGenericType()) != null) {
            enclosingType = JParameterizedType.createParameterizedTypeRecursive(isGenericEnclosingType, substitutionMap);
        }
        JTypeParameter[] typeParameters = baseType.getTypeParameters();
        com.google.gwt.core.ext.typeinfo.JClassType[] newTypeArgs = new JClassType[typeParameters.length];
        TypeOracle oracle = baseType.getOracle();
        for (int i = 0; i < newTypeArgs.length; ++i) {
            JClassType newTypeArg = substitutionMap.get(typeParameters[i]);
            if (newTypeArg == null) {
                newTypeArg = oracle.getWildcardType(JWildcardType.BoundType.EXTENDS, typeParameters[i].getFirstBound());
            }
            newTypeArgs[i] = newTypeArg;
        }
        JParameterizedType parameterizedType = oracle.getParameterizedType(baseType, enclosingType, newTypeArgs);
        return parameterizedType;
    }

    JParameterizedType(JGenericType baseType, JClassType enclosingType, JClassType[] typeArgs) {
        super.setBaseType(baseType);
        this.enclosingType = enclosingType;
        final JParameterizedType parameterizedType = this;
        this.members = new DelegateMembers(this, baseType, new Substitution(){

            @Override
            public JClassType getSubstitution(JClassType type) {
                return type.getSubstitutedType(parameterizedType);
            }
        });
        this.typeArgs = Lists.create(typeArgs);
        assert (this.typeArgs.indexOf(null) == -1) : "Unresolved typeArg creating JParameterizedType from " + baseType;
    }

    @Override
    public JConstructor findConstructor(JType[] paramTypes) {
        return this.members.findConstructor(paramTypes);
    }

    @Override
    public JField findField(String name) {
        return this.members.findField(name);
    }

    @Override
    public JMethod findMethod(String name, JType[] paramTypes) {
        return this.members.findMethod(name, paramTypes);
    }

    @Override
    public JClassType findNestedType(String typeName) {
        return this.members.findNestedType(typeName);
    }

    @Override
    public JConstructor getConstructor(JType[] paramTypes) throws NotFoundException {
        return this.members.getConstructor(paramTypes);
    }

    @Override
    public JConstructor[] getConstructors() {
        return this.members.getConstructors();
    }

    @Override
    public JClassType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public JField getField(String name) {
        return this.members.getField(name);
    }

    @Override
    public JField[] getFields() {
        return this.members.getFields();
    }

    @Override
    public JClassType[] getImplementedInterfaces() {
        if (this.interfaces == null) {
            JClassType[] intfs;
            this.interfaces = new ArrayList<JClassType>();
            for (JClassType intf : intfs = this.getBaseType().getImplementedInterfaces()) {
                JClassType newIntf = intf.getSubstitutedType(this);
                this.interfaces.add(newIntf);
            }
            this.interfaces = Lists.normalize(this.interfaces);
        }
        return this.interfaces.toArray(TypeOracle.NO_JCLASSES);
    }

    @Override
    public JMethod[] getInheritableMethods() {
        return this.members.getInheritableMethods();
    }

    @Override
    public JMethod getMethod(String name, JType[] paramTypes) throws NotFoundException {
        return this.members.getMethod(name, paramTypes);
    }

    @Override
    public JMethod[] getMethods() {
        return this.members.getMethods();
    }

    @Override
    public JClassType getNestedType(String typeName) throws NotFoundException {
        return this.members.getNestedType(typeName);
    }

    @Override
    public JClassType[] getNestedTypes() {
        return this.members.getNestedTypes();
    }

    @Override
    public JMethod[] getOverloads(String name) {
        return this.members.getOverloads(name);
    }

    @Override
    public JMethod[] getOverridableMethods() {
        return this.members.getOverridableMethods();
    }

    @Override
    public String getParameterizedQualifiedSourceName() {
        StringBuilder sb = new StringBuilder();
        if (this.getEnclosingType() != null) {
            sb.append(this.getEnclosingType().getParameterizedQualifiedSourceName());
            sb.append(".");
            sb.append(this.getSimpleSourceName());
        } else {
            sb.append(this.getQualifiedSourceName());
        }
        if (this.typeArgs.size() > 0) {
            sb.append('<');
            boolean needComma = false;
            for (JType jType : this.typeArgs) {
                if (needComma) {
                    sb.append(", ");
                } else {
                    needComma = true;
                }
                sb.append(jType.getParameterizedQualifiedSourceName());
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String getQualifiedBinaryName() {
        return this.getBaseType().getQualifiedBinaryName();
    }

    @Override
    public String getQualifiedSourceName() {
        return this.getBaseType().getQualifiedSourceName();
    }

    @Override
    public JClassType getRawType() {
        return this.getBaseType().getRawType();
    }

    @Override
    public String getSimpleSourceName() {
        return this.getBaseType().getSimpleSourceName();
    }

    @Override
    public JClassType[] getSubtypes() {
        JClassType[] genericSubtypes;
        ArrayList<JClassType> subtypeList = new ArrayList<JClassType>();
        for (JClassType subtype : genericSubtypes = this.getBaseType().getSubtypes()) {
            Map<JTypeParameter, JClassType> substitutions = this.findSubtypeSubstitution(subtype);
            if (substitutions == null) continue;
            JGenericType genericType = subtype.isGenericType();
            if (genericType != null) {
                subtype = JParameterizedType.createParameterizedTypeRecursive(genericType, substitutions);
            } else assert (substitutions.isEmpty());
            subtypeList.add(subtype);
        }
        return subtypeList.toArray(TypeOracle.NO_JCLASSES);
    }

    @Override
    public JClassType getSuperclass() {
        if (this.isInterface() != null) {
            return null;
        }
        if (this.lazySuperclass == null) {
            JGenericType baseType = this.getBaseType();
            JClassType superclass = baseType.getSuperclass();
            assert (superclass != null);
            this.lazySuperclass = superclass.getSubstitutedType(this);
        }
        return this.lazySuperclass;
    }

    public JClassType[] getTypeArgs() {
        return this.typeArgs.toArray(TypeOracle.NO_JCLASSES);
    }

    @Override
    public JGenericType isGenericType() {
        return null;
    }

    @Override
    public JParameterizedType isParameterized() {
        return this;
    }

    @Override
    public JRawType isRawType() {
        return null;
    }

    @Override
    public JWildcardType isWildcard() {
        return null;
    }

    @Override
    public String toString() {
        if (this.isInterface() != null) {
            return "interface " + this.getParameterizedQualifiedSourceName();
        }
        return "class " + this.getParameterizedQualifiedSourceName();
    }

    @Override
    protected JClassType findNestedTypeImpl(String[] typeName, int index) {
        return this.members.findNestedTypeImpl(typeName, index);
    }

    @Override
    protected void getInheritableMethodsOnSuperclassesAndThisClass(Map<String, JMethod> methodsBySignature) {
        this.members.getInheritableMethodsOnSuperclassesAndThisClass(methodsBySignature);
    }

    @Override
    protected void getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(Map<String, JMethod> methodsBySignature) {
        this.members.getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(methodsBySignature);
    }

    @Override
    JClassType getSubstitutedType(JParameterizedType parameterizedType) {
        this.maybeInitializeTypeParameterSubstitutionMap();
        if (this == parameterizedType) {
            return this;
        }
        com.google.gwt.core.ext.typeinfo.JClassType[] newTypeArgs = new JClassType[this.typeArgs.size()];
        for (int i = 0; i < newTypeArgs.length; ++i) {
            newTypeArgs[i] = this.typeArgs.get(i).getSubstitutedType(parameterizedType);
        }
        return this.getOracle().getParameterizedType(this.getBaseType(), this.getEnclosingType(), newTypeArgs);
    }

    JClassType getTypeParameterSubstitution(JTypeParameter typeParameter) {
        this.maybeInitializeTypeParameterSubstitutionMap();
        JClassType substitute = this.lazySubstitutionMap.get(typeParameter);
        if (substitute != null) {
            return substitute;
        }
        return typeParameter;
    }

    boolean hasTypeArgs(JClassType[] otherArgTypes) {
        if (otherArgTypes.length != this.typeArgs.size()) {
            return false;
        }
        for (int i = 0; i < otherArgTypes.length; ++i) {
            if (otherArgTypes[i] == this.typeArgs.get(i)) continue;
            return false;
        }
        return true;
    }

    void maybeInitializeTypeParameterSubstitutionMap() {
        if (this.lazySubstitutionMap != null) {
            return;
        }
        this.lazySubstitutionMap = new IdentityHashMap<JTypeParameter, JClassType>();
        JParameterizedType currentParameterizedType = this;
        while (currentParameterizedType != null) {
            JClassType maybeParameterizedType;
            JGenericType genericType = currentParameterizedType.getBaseType();
            JTypeParameter[] typeParameters = genericType.getTypeParameters();
            JClassType[] typeArguments = currentParameterizedType.getTypeArgs();
            for (JTypeParameter typeParameter : typeParameters) {
                this.lazySubstitutionMap.put(typeParameter, typeArguments[typeParameter.getOrdinal()]);
            }
            if (currentParameterizedType.isStatic() || (maybeParameterizedType = currentParameterizedType.getEnclosingType()) == null || maybeParameterizedType.isParameterized() == null) break;
            currentParameterizedType = maybeParameterizedType.isParameterized();
        }
        this.lazySubstitutionMap = Maps.normalize(this.lazySubstitutionMap);
    }

    void setTypeArguments(JClassType[] typeArgs) {
        this.typeArgs.addAll(Arrays.asList(typeArgs));
    }

    private Map<JTypeParameter, JClassType> findSubtypeSubstitution(JClassType subtype) {
        IdentityHashMap<JTypeParameter, JClassType> substitutions = new IdentityHashMap<JTypeParameter, JClassType>();
        Set<JClassType> supertypeHierarchy = JParameterizedType.getFlattenedSuperTypeHierarchy(subtype);
        if (supertypeHierarchy.contains(this)) {
            return substitutions;
        }
        for (JClassType candidate : supertypeHierarchy) {
            JParameterizedType parameterizedCandidate = candidate.isParameterized();
            if (parameterizedCandidate == null || parameterizedCandidate.getBaseType() != this.getBaseType()) continue;
            JClassType[] candidateTypeArgs = parameterizedCandidate.getTypeArgs();
            JClassType[] myTypeArgs = this.getTypeArgs();
            for (int i = 0; i < myTypeArgs.length; ++i) {
                JClassType myTypeArg = myTypeArgs[i];
                JClassType otherTypeArg = candidateTypeArgs[i];
                if (myTypeArg == otherTypeArg) continue;
                JTypeParameter otherTypeParameter = otherTypeArg.isTypeParameter();
                if (otherTypeParameter == null) {
                    return null;
                }
                if (!otherTypeParameter.isAssignableFrom(myTypeArg)) {
                    return null;
                }
                substitutions.put(otherTypeParameter, myTypeArg);
            }
        }
        return substitutions;
    }
}

