/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.ImmutableAnnotations;
import com.google.gwt.dev.javac.typemodel.JAbstractMethod;
import com.google.gwt.dev.util.StringInterner;
import java.lang.annotation.Annotation;
import java.util.Map;

public class JParameter
implements com.google.gwt.core.ext.typeinfo.JParameter {
    private final ImmutableAnnotations annotations;
    private boolean argNameIsReal;
    private final JAbstractMethod enclosingMethod;
    private String name;
    private JType type;

    JParameter(JAbstractMethod enclosingMethod, JParameter srcParam) {
        this.enclosingMethod = enclosingMethod;
        this.type = srcParam.type;
        this.name = srcParam.name;
        this.argNameIsReal = srcParam.argNameIsReal;
        this.annotations = srcParam.annotations;
    }

    JParameter(JAbstractMethod enclosingMethod, JType type, String name, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, boolean argNameIsReal) {
        this.enclosingMethod = enclosingMethod;
        this.type = type;
        this.name = StringInterner.get().intern(name);
        this.argNameIsReal = argNameIsReal;
        enclosingMethod.addParameter(this);
        this.annotations = ImmutableAnnotations.EMPTY.plus(declaredAnnotations);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.annotations.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.getDeclaredAnnotations();
    }

    @Override
    public JAbstractMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    @Override
    public String getName() {
        if (!this.argNameIsReal) {
            this.name = this.enclosingMethod.getRealParameterName(this);
            this.argNameIsReal = true;
        }
        return this.name;
    }

    @Override
    public JType getType() {
        return this.type;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.isAnnotationPresent(annotationClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getParameterizedQualifiedSourceName());
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    void setType(JType type) {
        this.type = type;
    }
}

