/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.javac.typemodel.ImmutableAnnotations;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JRealClassType;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;

public class JPackage
implements com.google.gwt.core.ext.typeinfo.JPackage {
    private ImmutableAnnotations annotations = ImmutableAnnotations.EMPTY;
    private final String name;
    private Map<String, JRealClassType> types = Maps.create();

    JPackage(String name) {
        this.name = name;
    }

    @Override
    public JClassType findType(String typeName) {
        String[] parts = typeName.split("\\.");
        return this.findType(parts);
    }

    @Override
    public JClassType findType(String[] typeName) {
        return this.findTypeImpl(typeName, 0);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.annotations.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.getDeclaredAnnotations();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JClassType getType(String typeName) throws NotFoundException {
        JClassType result = this.findType(typeName);
        if (result == null) {
            throw new NotFoundException();
        }
        return result;
    }

    public JClassType[] getTypes() {
        return this.types.values().toArray(TypeOracle.NO_JCLASSES);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.isAnnotationPresent(annotationClass);
    }

    @Override
    public boolean isDefault() {
        return "".equals(this.name);
    }

    public String toString() {
        return "package " + this.name;
    }

    void addAnnotations(Map<Class<? extends Annotation>, Annotation> additions) {
        this.annotations = this.annotations.plus(additions);
    }

    void addType(JRealClassType type) {
        this.types = Maps.put(this.types, type.getSimpleSourceName(), type);
    }

    JClassType findTypeImpl(String[] typeName, int index) {
        JClassType found = this.types.get(typeName[index]);
        if (found == null) {
            return null;
        }
        if (index < typeName.length - 1) {
            return found.findNestedTypeImpl(typeName, index + 1);
        }
        return found;
    }
}

