/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.JAbstractMethod;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JParameter;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import java.lang.annotation.Annotation;
import java.util.Map;

public class JMethod
extends JAbstractMethod
implements com.google.gwt.core.ext.typeinfo.JMethod {
    private final JClassType enclosingType;
    private JType returnType;

    JMethod(JClassType enclosingType, JMethod srcMethod) {
        super(srcMethod);
        this.enclosingType = enclosingType;
        this.returnType = srcMethod.returnType;
    }

    JMethod(JClassType enclosingType, String name, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, JTypeParameter[] jtypeParameters) {
        super(name, declaredAnnotations, jtypeParameters);
        this.enclosingType = enclosingType;
        enclosingType.addMethod(this);
    }

    @Override
    public JClassType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public String getJsniSignature() {
        StringBuilder sb = new StringBuilder("@");
        sb.append(this.getEnclosingType().getQualifiedSourceName());
        sb.append("::");
        sb.append(this.getName());
        sb.append("(");
        for (JParameter param : this.getParameters()) {
            sb.append(param.getType().getJNISignature());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getReadableDeclaration() {
        return this.getReadableDeclaration(this.getModifierBits());
    }

    @Override
    public String getReadableDeclaration(boolean noAccess, boolean noNative, boolean noStatic, boolean noFinal, boolean noAbstract) {
        int bits = this.getModifierBits();
        if (noAccess) {
            bits &= 0xFFFFFFC7;
        }
        if (noNative) {
            bits &= 0xFFFFFFFB;
        }
        if (noStatic) {
            bits &= 0xFFFFFFBF;
        }
        if (noFinal) {
            bits &= 0xFFFFFFFD;
        }
        if (noAbstract) {
            bits &= 0xFFFFFFFE;
        }
        return this.getReadableDeclaration(bits);
    }

    @Override
    public JType getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isAbstract() {
        return 0 != (this.getModifierBits() & 1);
    }

    @Override
    public JConstructor isConstructor() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return 0 != (this.getModifierBits() & 2);
    }

    @Override
    public JMethod isMethod() {
        return this;
    }

    @Override
    public boolean isNative() {
        return 0 != (this.getModifierBits() & 4);
    }

    @Override
    public boolean isStatic() {
        return 0 != (this.getModifierBits() & 0x40);
    }

    public String toString() {
        return this.getReadableDeclaration();
    }

    String getReadableDeclaration(int modifierBits) {
        String[] names = TypeOracle.modifierBitsToNamesForMethod(modifierBits);
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(name);
            sb.append(" ");
        }
        if (this.getTypeParameters().length > 0) {
            this.toStringTypeParams(sb);
            sb.append(" ");
        }
        sb.append(this.returnType.getParameterizedQualifiedSourceName());
        sb.append(" ");
        sb.append(this.getName());
        this.toStringParamsAndThrows(sb);
        return sb.toString();
    }

    void setReturnType(JType type) {
        this.returnType = type;
    }
}

