/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.ImmutableAnnotations;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JEnumConstant;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.StringInterner;
import java.lang.annotation.Annotation;
import java.util.Map;

public class JField
implements com.google.gwt.core.ext.typeinfo.JField {
    private final ImmutableAnnotations annotations;
    private final JClassType enclosingType;
    private int modifierBits;
    private final String name;
    private JType type;

    JField(JClassType enclosingType, JField srcField) {
        this.annotations = srcField.annotations;
        this.enclosingType = enclosingType;
        this.modifierBits = srcField.modifierBits;
        this.name = srcField.name;
        this.type = srcField.type;
    }

    JField(JClassType enclosingType, String name, Map<Class<? extends Annotation>, Annotation> declaredAnnotations) {
        assert (enclosingType != null);
        this.enclosingType = enclosingType;
        this.name = StringInterner.get().intern(name);
        this.enclosingType.addField(this);
        this.annotations = ImmutableAnnotations.EMPTY.plus(declaredAnnotations);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.annotations.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.getDeclaredAnnotations();
    }

    @Override
    public JClassType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public String getName() {
        assert (this.name != null);
        return this.name;
    }

    @Override
    public JType getType() {
        assert (this.type != null);
        return this.type;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.isAnnotationPresent(annotationClass);
    }

    @Override
    public boolean isDefaultAccess() {
        return 0 == (this.modifierBits & 0x38);
    }

    @Override
    public JEnumConstant isEnumConstant() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return 0 != (this.modifierBits & 2);
    }

    @Override
    public boolean isPrivate() {
        return 0 != (this.modifierBits & 8);
    }

    @Override
    public boolean isProtected() {
        return 0 != (this.modifierBits & 0x10);
    }

    @Override
    public boolean isPublic() {
        return 0 != (this.modifierBits & 0x20);
    }

    @Override
    public boolean isStatic() {
        return 0 != (this.modifierBits & 0x40);
    }

    @Override
    public boolean isTransient() {
        return 0 != (this.modifierBits & 0x80);
    }

    @Override
    public boolean isVolatile() {
        return 0 != (this.modifierBits & 0x100);
    }

    public String toString() {
        String[] names = TypeOracle.modifierBitsToNamesForField(this.modifierBits);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(names[i]);
        }
        if (names.length > 0) {
            sb.append(" ");
        }
        sb.append(this.type.getParameterizedQualifiedSourceName());
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    void addModifierBits(int modifierBits) {
        this.modifierBits |= modifierBits;
    }

    void setType(JType type) {
        this.type = type;
    }
}

