/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.ImmutableAnnotations;
import com.google.gwt.dev.javac.typemodel.JAnnotationMethod;
import com.google.gwt.dev.javac.typemodel.JArrayType;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JParameter;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

public abstract class JAbstractMethod
implements com.google.gwt.core.ext.typeinfo.JAbstractMethod {
    private final ImmutableAnnotations annotations;
    private boolean isVarArgs = false;
    private int modifierBits;
    private final String name;
    private List<JParameter> params = Lists.create();
    private String[] realParameterNames = null;
    private List<JClassType> thrownTypes = Lists.create();
    private List<JTypeParameter> typeParams = Lists.create();

    JAbstractMethod(JAbstractMethod srcMethod) {
        this.annotations = srcMethod.annotations;
        this.isVarArgs = srcMethod.isVarArgs;
        this.modifierBits = srcMethod.modifierBits;
        this.name = srcMethod.name;
    }

    JAbstractMethod(String name, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, JTypeParameter[] jtypeParameters) {
        this.name = StringInterner.get().intern(name);
        this.annotations = ImmutableAnnotations.EMPTY.plus(declaredAnnotations);
        if (jtypeParameters != null) {
            this.typeParams = Lists.create(jtypeParameters);
        }
    }

    @Override
    public JParameter findParameter(String name) {
        for (JParameter param : this.params) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.annotations.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.getDeclaredAnnotations();
    }

    @Override
    public abstract JClassType getEnclosingType();

    @Override
    public JType[] getErasedParameterTypes() {
        JType[] types = new JType[this.params.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.params.get(i).getType().getErasedType();
        }
        return types;
    }

    @Override
    public abstract String getJsniSignature();

    @Override
    public String getName() {
        return this.name;
    }

    public JParameter[] getParameters() {
        return this.params.toArray(TypeOracle.NO_JPARAMS);
    }

    @Override
    public JType[] getParameterTypes() {
        JType[] paramTypes = new JType[this.params.size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = this.params.get(i).getType();
        }
        return paramTypes;
    }

    @Override
    public abstract String getReadableDeclaration();

    public JClassType[] getThrows() {
        return this.thrownTypes.toArray(TypeOracle.NO_JCLASSES);
    }

    public JTypeParameter[] getTypeParameters() {
        return this.typeParams.toArray(new JTypeParameter[this.typeParams.size()]);
    }

    @Override
    public JAnnotationMethod isAnnotationMethod() {
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.isAnnotationPresent(annotationClass);
    }

    @Override
    public abstract JConstructor isConstructor();

    @Override
    public boolean isDefaultAccess() {
        return 0 == (this.modifierBits & 0x38);
    }

    @Override
    public abstract JMethod isMethod();

    @Override
    public boolean isPrivate() {
        return 0 != (this.modifierBits & 8);
    }

    @Override
    public boolean isProtected() {
        return 0 != (this.modifierBits & 0x10);
    }

    @Override
    public boolean isPublic() {
        return 0 != (this.modifierBits & 0x20);
    }

    @Override
    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    protected int getModifierBits() {
        return this.modifierBits;
    }

    protected void toStringParamsAndThrows(StringBuilder sb) {
        sb.append("(");
        boolean needComma = false;
        int c = this.params.size();
        for (int i = 0; i < c; ++i) {
            JParameter param = this.params.get(i);
            if (needComma) {
                sb.append(", ");
            } else {
                needComma = true;
            }
            if (this.isVarArgs() && i == c - 1) {
                JArrayType arrayType = (JArrayType)param.getType().isArray();
                assert (arrayType != null);
                sb.append(arrayType.getComponentType().getParameterizedQualifiedSourceName());
                sb.append("...");
            } else {
                sb.append(param.getType().getParameterizedQualifiedSourceName());
            }
            sb.append(" ");
            sb.append(param.getName());
        }
        sb.append(")");
        if (!this.thrownTypes.isEmpty()) {
            sb.append(" throws ");
            needComma = false;
            for (JClassType thrownType : this.thrownTypes) {
                if (needComma) {
                    sb.append(", ");
                } else {
                    needComma = true;
                }
                sb.append(thrownType.getParameterizedQualifiedSourceName());
            }
        }
    }

    protected void toStringTypeParams(StringBuilder sb) {
        sb.append("<");
        boolean needComma = false;
        for (JTypeParameter typeParam : this.typeParams) {
            if (needComma) {
                sb.append(", ");
            } else {
                needComma = true;
            }
            sb.append(typeParam.getQualifiedSourceName());
        }
        sb.append(">");
    }

    void addModifierBits(int bits) {
        this.modifierBits |= bits;
    }

    void addParameter(JParameter param) {
        this.params = Lists.add(this.params, param);
    }

    void addThrows(JClassType type) {
        this.thrownTypes = Lists.add(this.thrownTypes, type);
    }

    String getRealParameterName(JParameter parameter) {
        if (this.realParameterNames == null) {
            this.fetchRealParameterNames();
        }
        int n = this.params.size();
        for (int i = 0; i < n; ++i) {
            if (this.params.get(i) != parameter) continue;
            String realParameterName = this.realParameterNames == null ? StringInterner.get().intern("arg" + i) : StringInterner.get().intern(this.realParameterNames[i]);
            return realParameterName;
        }
        return null;
    }

    boolean hasParamTypes(JType[] paramTypes) {
        if (this.params.size() != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            JParameter candidate = this.params.get(i);
            if (candidate.getType() == paramTypes[i]) continue;
            return false;
        }
        return true;
    }

    void setVarArgs() {
        this.isVarArgs = true;
    }

    private void fetchRealParameterNames() {
        this.realParameterNames = this.getEnclosingType().getOracle().getJavaSourceParser().getArguments(this);
    }
}

