/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.HasAnnotations;
import com.google.gwt.dev.javac.typemodel.Annotations;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

class ImmutableAnnotations
implements HasAnnotations {
    public static final ImmutableAnnotations EMPTY = new ImmutableAnnotations(){

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }
    };
    private final Map<Class<? extends Annotation>, Annotation> members;

    private ImmutableAnnotations() {
        this.members = Maps.create();
    }

    private ImmutableAnnotations(ImmutableAnnotations base, Map<Class<? extends Annotation>, Annotation> additions) {
        this.members = ImmutableAnnotations.copyOfAnnotations(base, additions);
    }

    public ImmutableAnnotations plus(Map<Class<? extends Annotation>, Annotation> additions) {
        if (additions == null || additions.size() == 0) {
            return this;
        }
        return new ImmutableAnnotations(this, additions);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)annotationClass.cast(this.members.get(annotationClass)));
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ArrayList<Annotation> values = new ArrayList<Annotation>(this.members.values());
        Collections.sort(values, Annotations.ANNOTATION_COMPARATOR);
        return values.toArray(new Annotation[values.size()]);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    private static Map<Class<? extends Annotation>, Annotation> copyOfAnnotations(ImmutableAnnotations base, Map<Class<? extends Annotation>, Annotation> additions) {
        HashMap<Class<? extends Annotation>, Annotation> result = new HashMap<Class<? extends Annotation>, Annotation>();
        result.putAll(base.members);
        for (Annotation addition : additions.values()) {
            Class<? extends Annotation> type = addition.annotationType();
            assert (type != null);
            assert (!result.containsKey(type));
            result.put(type, addition);
        }
        return Maps.normalize(result);
    }
}

