/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.AbstractMembers;
import com.google.gwt.dev.javac.typemodel.JAbstractMethod;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JDelegatingClassType;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JParameter;
import com.google.gwt.dev.javac.typemodel.Substitution;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DelegateMembers
extends AbstractMembers {
    private final JClassType baseType;
    private Map<String, JField> fieldMap;
    private JField[] fields;
    private List<JConstructor> lazyConstructors;
    private Map<String, Object> methodMap;
    private JMethod[] methods;
    private final Substitution substitution;

    public DelegateMembers(JDelegatingClassType enclosingType, JClassType baseType, Substitution substitution) {
        super(enclosingType);
        this.baseType = baseType;
        this.substitution = substitution;
    }

    @Override
    public JField findField(String name) {
        this.initFields();
        return this.fieldMap.get(name);
    }

    @Override
    public JField[] getFields() {
        this.initFields();
        return this.fields.length == 0 ? this.fields : (JField[])this.fields.clone();
    }

    @Override
    public JMethod[] getMethods() {
        this.initMethods();
        return this.methods.length == 0 ? this.methods : (JMethod[])this.methods.clone();
    }

    @Override
    public JMethod[] getOverloads(String name) {
        this.initMethods();
        Object object = this.methodMap.get(name);
        if (object == null) {
            return TypeOracle.NO_JMETHODS;
        }
        if (object instanceof JMethod) {
            return new JMethod[]{(JMethod)object};
        }
        return (JMethod[])((JMethod[])object).clone();
    }

    @Override
    protected void addConstructor(JConstructor ctor) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addField(JField field) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addMethod(JMethod method) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<JConstructor> doGetConstructors() {
        JConstructor[] baseCtors;
        if (this.lazyConstructors != null) {
            return this.lazyConstructors;
        }
        this.lazyConstructors = new ArrayList<JConstructor>();
        for (JConstructor baseCtor : baseCtors = this.baseType.getConstructors()) {
            JConstructor newCtor = new JConstructor(this.getParentType(), baseCtor);
            this.initializeParams(baseCtor, newCtor);
            this.lazyConstructors.add(newCtor);
        }
        this.lazyConstructors = Lists.normalize(this.lazyConstructors);
        return this.lazyConstructors;
    }

    @Override
    protected Map<String, JClassType> doGetNestedTypes() {
        return Maps.create();
    }

    private void initFields() {
        if (this.fields != null) {
            return;
        }
        this.fields = this.baseType.getFields();
        this.fieldMap = new HashMap<String, JField>();
        for (int i = 0; i < this.fields.length; ++i) {
            JField baseField = this.fields[i];
            JField newField = new JField(this.getParentType(), baseField);
            newField.setType(this.substitute(baseField.getType()));
            this.fields[i] = newField;
            this.fieldMap.put(newField.getName(), newField);
        }
        this.fieldMap = Maps.normalize(this.fieldMap);
    }

    private void initializeExceptions(JAbstractMethod srcMethod, JAbstractMethod newMethod) {
        for (JClassType thrown : srcMethod.getThrows()) {
            newMethod.addThrows(thrown);
        }
    }

    private void initializeParams(JAbstractMethod srcMethod, JAbstractMethod newMethod) {
        for (JParameter srcParam : srcMethod.getParameters()) {
            JParameter newParam = new JParameter(newMethod, srcParam);
            newParam.setType(this.substitute(srcParam.getType()));
            newMethod.addParameter(newParam);
        }
    }

    private void initMethods() {
        if (this.methods != null) {
            return;
        }
        this.methods = this.baseType.getMethods();
        this.methodMap = new HashMap<String, Object>();
        for (int i = 0; i < this.methods.length; ++i) {
            ArrayList<JMethod> list;
            JMethod baseMethod = this.methods[i];
            JMethod newMethod = new JMethod(this.getParentType(), baseMethod);
            this.initializeParams(baseMethod, newMethod);
            newMethod.setReturnType(this.substitute(baseMethod.getReturnType()));
            this.initializeExceptions(baseMethod, newMethod);
            this.methods[i] = newMethod;
            String methodName = newMethod.getName();
            Object object = this.methodMap.get(methodName);
            if (object == null) {
                this.methodMap.put(methodName, newMethod);
                continue;
            }
            if (object instanceof JMethod) {
                list = new ArrayList<JMethod>(2);
                list.add((JMethod)object);
                list.add(newMethod);
                this.methodMap.put(methodName, list);
                continue;
            }
            list = (ArrayList<JMethod>)object;
            list.add(newMethod);
        }
        for (String methodName : this.methodMap.keySet()) {
            Object object = this.methodMap.get(methodName);
            if (!(object instanceof List)) continue;
            List list = (List)object;
            this.methodMap.put(methodName, list.toArray(TypeOracle.NO_JMETHODS));
        }
        this.methodMap = Maps.normalize(this.methodMap);
    }

    private JType substitute(JType type) {
        if (type instanceof JClassType) {
            return this.substitution.getSubstitution((JClassType)type);
        }
        return type;
    }
}

