/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.typemodel.JArrayType;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JMaybeParameterizedType;
import com.google.gwt.dev.javac.typemodel.JParameterizedType;
import com.google.gwt.dev.javac.typemodel.JRawType;
import com.google.gwt.dev.javac.typemodel.JRealClassType;
import com.google.gwt.dev.javac.typemodel.JWildcardType;
import java.util.Set;

class AssignabilityChecker {
    AssignabilityChecker() {
    }

    public boolean isAssignable(JClassType from, JClassType to) {
        from = AssignabilityChecker.convertToRawIfGeneric(from);
        if ((to = AssignabilityChecker.convertToRawIfGeneric(to)) == from) {
            return true;
        }
        if (to.isWildcard() != null) {
            return this.isAssignableToWildcardType(from, to.isWildcard());
        }
        if (from.isTypeParameter() != null) {
            return this.isAssignableFromAny(from.isTypeParameter().getBounds(), to);
        }
        if (from.isWildcard() != null) {
            return this.isAssignableFromAny(from.isWildcard().getUpperBounds(), to);
        }
        if (from.isArray() != null) {
            return this.isAssignableFromGenericArrayType(from.isArray(), to);
        }
        if (to.isParameterized() != null) {
            return this.isAssignableToParameterizedType(from, to.isParameterized());
        }
        if (to.isTypeParameter() != null) {
            return this.isAssignableFromAll(from, to.isTypeParameter().getBounds());
        }
        if (to.isArray() != null) {
            return false;
        }
        assert (to instanceof JRealClassType || to instanceof JRawType);
        return this.isAssignableFromRaw(from, to);
    }

    private boolean isAssignableFromAny(JClassType[] fromTypes, JClassType to) {
        for (JClassType from : fromTypes) {
            if (!this.isAssignable(from, to)) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableToWildcardType(JClassType from, JWildcardType to) {
        return this.isAssignable(from, AssignabilityChecker.supertypeBound(to)) && this.isAssignableBySubtypeBound(from, to);
    }

    private boolean isAssignableBySubtypeBound(JClassType from, JWildcardType to) {
        JClassType toSubtypeBound = AssignabilityChecker.subtypeBound(to);
        if (toSubtypeBound == null) {
            return true;
        }
        JClassType fromSubtypeBound = AssignabilityChecker.subtypeBound(from);
        if (fromSubtypeBound == null) {
            return false;
        }
        return this.isAssignable(toSubtypeBound, fromSubtypeBound);
    }

    private boolean isAssignableToParameterizedType(JClassType from, JParameterizedType to) {
        JMaybeParameterizedType parentOfFrom = AssignabilityChecker.asParamterizationOf(from, to);
        if (parentOfFrom == null) {
            return false;
        }
        if (parentOfFrom.isRawType() != null) {
            return true;
        }
        JParameterizedType parameterizedParentOfFrom = parentOfFrom.isParameterized();
        assert (parameterizedParentOfFrom != null);
        JClassType[] fromTypeArgs = parameterizedParentOfFrom.getTypeArgs();
        JClassType[] toTypeArgs = to.getTypeArgs();
        for (int i = 0; i < fromTypeArgs.length; ++i) {
            if (this.matchTypeArgument(fromTypeArgs[i], toTypeArgs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchTypeArgument(JClassType from, JClassType to) {
        if (from == to) {
            return true;
        }
        if (to.isWildcard() != null) {
            return this.isAssignableToWildcardType(from, to.isWildcard());
        }
        return false;
    }

    private boolean isAssignableFromAll(JClassType from, JClassType[] toTypes) {
        for (JClassType to : toTypes) {
            if (this.isAssignable(from, to)) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignableFromGenericArrayType(JArrayType from, JClassType to) {
        if (to.isArray() != null) {
            JType fromComponentType = from.getComponentType();
            JType toComponentType = to.isArray().getComponentType();
            if (toComponentType.isPrimitive() != null || fromComponentType.isPrimitive() != null) {
                return false;
            }
            return this.isAssignable((JClassType)fromComponentType, (JClassType)toComponentType);
        }
        return AssignabilityChecker.isJavaLangObject(to);
    }

    private boolean isAssignableFromRaw(JClassType from, JClassType to) {
        if (AssignabilityChecker.isJavaLangObject(to)) {
            return true;
        }
        Set<JClassType> fromSuperTypeHierarchy = from.getFlattenedSupertypeHierarchy();
        if (fromSuperTypeHierarchy.contains(to)) {
            return true;
        }
        if (to.isRawType() != null) {
            for (JClassType fromSuper : fromSuperTypeHierarchy) {
                if (fromSuper.getErasedType() != to.getErasedType()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isJavaLangObject(JClassType type) {
        return type == type.getOracle().getJavaLangObject();
    }

    private static JClassType convertToRawIfGeneric(JClassType from) {
        return from.isGenericType() != null ? from.isGenericType().getRawType() : from;
    }

    private static JClassType supertypeBound(JWildcardType type) {
        JClassType upperBound = type.getUpperBound();
        return upperBound.isWildcard() != null ? AssignabilityChecker.supertypeBound(upperBound.isWildcard()) : upperBound;
    }

    private static JClassType subtypeBound(JWildcardType type) {
        JClassType[] lowerBounds = type.getLowerBounds();
        return lowerBounds.length == 1 ? AssignabilityChecker.subtypeBound(lowerBounds[0]) : null;
    }

    private static JClassType subtypeBound(JClassType type) {
        return type.isWildcard() != null ? AssignabilityChecker.subtypeBound(type.isWildcard()) : type;
    }

    private static JMaybeParameterizedType asParamterizationOf(JClassType from, JParameterizedType to) {
        for (JClassType parent : from.getFlattenedSupertypeHierarchy()) {
            JMaybeParameterizedType maybeParameterized = parent.isMaybeParameterizedType();
            if (maybeParameterized == null || maybeParameterized.getBaseType() != to.getBaseType()) continue;
            return maybeParameterized;
        }
        return null;
    }
}

