/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.HasAnnotations;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class Annotations
implements HasAnnotations {
    static final Comparator<Annotation> ANNOTATION_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation o1, Annotation o2) {
            return o1.annotationType().getName().compareTo(o2.annotationType().getName());
        }
    };
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    private Map<Class<? extends Annotation>, Annotation> lazyAnnotations = null;
    private Annotations parent;

    Annotations() {
        this.declaredAnnotations = Maps.create();
    }

    Annotations(Map<Class<? extends Annotation>, Annotation> declaredAnnotations) {
        this.declaredAnnotations = Maps.normalize(declaredAnnotations);
    }

    public void addAnnotations(Map<Class<? extends Annotation>, Annotation> additions) {
        assert (this.lazyAnnotations == null);
        if (additions != null) {
            assert (!additions.containsValue(null));
            this.declaredAnnotations = Maps.putAll(this.declaredAnnotations, additions);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        this.initializeAnnotations();
        return (T)((Annotation)annotationClass.cast(this.lazyAnnotations.get(annotationClass)));
    }

    @Override
    public Annotation[] getAnnotations() {
        this.initializeAnnotations();
        ArrayList<Annotation> values = new ArrayList<Annotation>(this.lazyAnnotations.values());
        Collections.sort(values, ANNOTATION_COMPARATOR);
        return values.toArray(new Annotation[values.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ArrayList<Annotation> values = new ArrayList<Annotation>(this.declaredAnnotations.values());
        Collections.sort(values, ANNOTATION_COMPARATOR);
        return values.toArray(new Annotation[values.size()]);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    void setParent(Annotations parent) {
        assert (this.lazyAnnotations == null);
        this.parent = parent;
    }

    private void initializeAnnotations() {
        if (this.lazyAnnotations != null) {
            return;
        }
        if (this.parent != null) {
            this.lazyAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
            this.parent.initializeAnnotations();
            for (Map.Entry<Class<? extends Annotation>, Annotation> entry : this.parent.lazyAnnotations.entrySet()) {
                if (!entry.getValue().annotationType().isAnnotationPresent(Inherited.class)) continue;
                this.lazyAnnotations.put(entry.getKey(), entry.getValue());
            }
            this.lazyAnnotations.putAll(this.declaredAnnotations);
            this.lazyAnnotations = Maps.normalize(this.lazyAnnotations);
        } else {
            this.lazyAnnotations = this.declaredAnnotations;
        }
    }
}

