/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.typemodel;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JConstructor;
import com.google.gwt.dev.javac.typemodel.JField;
import com.google.gwt.dev.javac.typemodel.JMethod;
import com.google.gwt.dev.javac.typemodel.JParameter;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

abstract class AbstractMembers {
    protected final JClassType classType;
    private JMethod[] cachedInheritableMethods;
    private JMethod[] cachedOverridableMethods;

    public AbstractMembers(JClassType classType) {
        this.classType = classType;
    }

    public JConstructor findConstructor(JType[] paramTypes) {
        JConstructor[] ctors;
        for (JConstructor candidate : ctors = this.getConstructors()) {
            if (!candidate.hasParamTypes(paramTypes)) continue;
            return candidate;
        }
        return null;
    }

    public abstract JField findField(String var1);

    public JMethod findMethod(String name, JType[] paramTypes) {
        JMethod[] overloads;
        for (JMethod candidate : overloads = this.getOverloads(name)) {
            if (!candidate.hasParamTypes(paramTypes)) continue;
            return candidate;
        }
        return null;
    }

    public JClassType findNestedType(String typeName) {
        String[] parts = typeName.split("\\.");
        return this.findNestedTypeImpl(parts, 0);
    }

    public JConstructor getConstructor(JType[] paramTypes) throws NotFoundException {
        JConstructor result = this.findConstructor(paramTypes);
        if (result == null) {
            throw new NotFoundException();
        }
        return result;
    }

    public JConstructor[] getConstructors() {
        return this.doGetConstructors().toArray(TypeOracle.NO_JCTORS);
    }

    public JField getField(String name) {
        JField field = this.findField(name);
        assert (field != null);
        return field;
    }

    public abstract JField[] getFields();

    public JMethod[] getInheritableMethods() {
        if (this.cachedInheritableMethods == null) {
            int size;
            TreeMap<String, JMethod> methodsBySignature = new TreeMap<String, JMethod>();
            this.getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(methodsBySignature);
            if (this.classType.isClass() != null) {
                this.getInheritableMethodsOnSuperclassesAndThisClass(methodsBySignature);
            }
            if ((size = methodsBySignature.size()) == 0) {
                this.cachedInheritableMethods = TypeOracle.NO_JMETHODS;
            } else {
                Collection leafMethods = methodsBySignature.values();
                this.cachedInheritableMethods = leafMethods.toArray(new JMethod[size]);
            }
        }
        return this.cachedInheritableMethods;
    }

    public JMethod getMethod(String name, JType[] paramTypes) throws NotFoundException {
        JMethod result = this.findMethod(name, paramTypes);
        if (result == null) {
            throw new NotFoundException();
        }
        return result;
    }

    public abstract JMethod[] getMethods();

    public JClassType getNestedType(String typeName) throws NotFoundException {
        JClassType result = this.findNestedType(typeName);
        if (result == null) {
            throw new NotFoundException();
        }
        return result;
    }

    public JClassType[] getNestedTypes() {
        return this.doGetNestedTypes().values().toArray(TypeOracle.NO_JCLASSES);
    }

    public abstract JMethod[] getOverloads(String var1);

    public JMethod[] getOverridableMethods() {
        if (this.cachedOverridableMethods == null) {
            JMethod[] inheritableMethods = this.getInheritableMethods();
            ArrayList<JMethod> methods = new ArrayList<JMethod>(inheritableMethods.length);
            for (JMethod method : inheritableMethods) {
                if (method.isFinal()) continue;
                methods.add(method);
            }
            int size = methods.size();
            this.cachedOverridableMethods = size == 0 ? TypeOracle.NO_JMETHODS : methods.toArray(new JMethod[size]);
        }
        return this.cachedOverridableMethods;
    }

    protected abstract void addConstructor(JConstructor var1);

    protected abstract void addField(JField var1);

    protected abstract void addMethod(JMethod var1);

    protected abstract List<JConstructor> doGetConstructors();

    protected abstract Map<String, JClassType> doGetNestedTypes();

    protected JClassType findNestedTypeImpl(String[] typeName, int index) {
        JClassType found = this.doGetNestedTypes().get(typeName[index]);
        if (found == null) {
            return null;
        }
        if (index < typeName.length - 1) {
            return found.findNestedTypeImpl(typeName, index + 1);
        }
        return found;
    }

    protected void getInheritableMethodsOnSuperclassesAndThisClass(Map<String, JMethod> methodsBySignature) {
        JMethod[] declaredMethods;
        assert (this.classType.isClass() != null);
        JClassType superClass = this.classType.getSuperclass();
        if (superClass != null) {
            superClass.getInheritableMethodsOnSuperclassesAndThisClass(methodsBySignature);
        }
        for (JMethod method : declaredMethods = this.getMethods()) {
            if (method.isPrivate() || method.isStatic()) continue;
            String sig = this.computeInternalSignature(method);
            methodsBySignature.put(sig, method);
        }
    }

    protected void getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(Map<String, JMethod> methodsBySignature) {
        JMethod[] declaredMethods;
        JClassType[] superIntfs;
        for (JClassType superIntf : superIntfs = this.classType.getImplementedInterfaces()) {
            superIntf.getInheritableMethodsOnSuperinterfacesAndMaybeThisInterface(methodsBySignature);
        }
        if (this.classType.isInterface() == null) {
            return;
        }
        for (JMethod method : declaredMethods = this.getMethods()) {
            String sig = this.computeInternalSignature(method);
            JMethod existing = methodsBySignature.get(sig);
            if (existing != null) {
                JClassType existingType = existing.getEnclosingType();
                JClassType thisType = method.getEnclosingType();
                if (thisType.isAssignableFrom(existingType)) continue;
            }
            methodsBySignature.put(sig, method);
        }
    }

    protected JClassType getParentType() {
        return this.classType;
    }

    private String computeInternalSignature(JMethod method) {
        JParameter[] params;
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(method.getName());
        for (JParameter param : params = method.getParameters()) {
            sb.append("/");
            sb.append(param.getType().getErasedType().getQualifiedSourceName());
        }
        return sb.toString();
    }
}

