/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.asm;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.javac.Resolver;
import com.google.gwt.dev.javac.TypeParameterLookup;
import com.google.gwt.dev.javac.asm.EmptySignatureVisitor;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JGenericType;
import com.google.gwt.dev.javac.typemodel.JParameterizedType;
import com.google.gwt.dev.javac.typemodel.JRealClassType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.javac.typemodel.JWildcardType;
import com.google.gwt.dev.util.Name;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;

public class ResolveTypeSignature
extends EmptySignatureVisitor {
    private final Resolver resolver;
    private final TreeLogger logger;
    private final JType[] returnTypeRef;
    private final TypeParameterLookup lookup;
    private final char wildcardMatch;
    private final JClassType enclosingClass;
    private JClassType outerClass;
    private final List<JType[]> args = new ArrayList<JType[]>();
    private int arrayDepth = 0;

    public ResolveTypeSignature(Resolver resolver, TreeLogger logger, JType[] returnTypeRef, TypeParameterLookup lookup, JClassType enclosingClass) {
        this(resolver, logger, returnTypeRef, lookup, enclosingClass, '=');
    }

    public ResolveTypeSignature(Resolver resovler, TreeLogger logger, JType[] returnTypeRef, TypeParameterLookup lookup, JClassType enclosingClass, char wildcardMatch) {
        this.resolver = resovler;
        this.logger = logger;
        this.returnTypeRef = returnTypeRef;
        this.lookup = lookup;
        this.enclosingClass = enclosingClass;
        this.wildcardMatch = wildcardMatch;
    }

    @Override
    public SignatureVisitor visitArrayType() {
        ++this.arrayDepth;
        return this;
    }

    @Override
    public void visitBaseType(char descriptor) {
        switch (descriptor) {
            case 'V': {
                this.returnTypeRef[0] = JPrimitiveType.VOID;
                break;
            }
            case 'B': {
                this.returnTypeRef[0] = JPrimitiveType.BYTE;
                break;
            }
            case 'J': {
                this.returnTypeRef[0] = JPrimitiveType.LONG;
                break;
            }
            case 'Z': {
                this.returnTypeRef[0] = JPrimitiveType.BOOLEAN;
                break;
            }
            case 'I': {
                this.returnTypeRef[0] = JPrimitiveType.INT;
                break;
            }
            case 'S': {
                this.returnTypeRef[0] = JPrimitiveType.SHORT;
                break;
            }
            case 'C': {
                this.returnTypeRef[0] = JPrimitiveType.CHAR;
                break;
            }
            case 'F': {
                this.returnTypeRef[0] = JPrimitiveType.FLOAT;
                break;
            }
            case 'D': {
                this.returnTypeRef[0] = JPrimitiveType.DOUBLE;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized base type " + descriptor);
            }
        }
        this.visitEnd();
    }

    @Override
    public void visitClassType(String internalName) {
        assert (Name.isInternalName(internalName));
        this.outerClass = this.enclosingClass;
        JRealClassType classType = this.resolver.findByInternalName(internalName);
        if (classType == null) {
            this.logger.log(TreeLogger.ERROR, "Unable to find class " + internalName);
            this.returnTypeRef[0] = this.resolver.getTypeOracle().getJavaLangObject();
            return;
        }
        if (!this.resolver.resolveClass(this.logger, classType)) {
            // empty if block
        }
        this.returnTypeRef[0] = classType;
    }

    @Override
    public void visitEnd() {
        if (this.returnTypeRef[0] == null) {
            return;
        }
        this.resolveGenerics();
    }

    @Override
    public void visitInnerClassType(String innerName) {
        assert (this.returnTypeRef[0] != null);
        this.resolveGenerics();
        JClassType searchClass = this.outerClass = (JClassType)this.returnTypeRef[0];
        try {
            JParameterizedType pt = searchClass.isParameterized();
            if (pt != null) {
                searchClass = pt.getBaseType();
            }
            this.returnTypeRef[0] = searchClass.getNestedType(innerName);
        }
        catch (NotFoundException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to resolve inner class " + innerName + " in " + searchClass, e);
        }
    }

    @Override
    public void visitTypeArgument() {
        JType[] arg = new JType[]{this.resolver.getTypeOracle().getWildcardType(JWildcardType.BoundType.UNBOUND, this.resolver.getTypeOracle().getJavaLangObject())};
        this.args.add(arg);
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        JType[] arg = new JType[1];
        this.args.add(arg);
        return new ResolveTypeSignature(this.resolver, this.logger, arg, this.lookup, null, wildcard);
    }

    @Override
    public void visitTypeVariable(String name) {
        this.returnTypeRef[0] = this.lookup.lookup(name);
        this.visitEnd();
    }

    private void mergeTypeParamBounds(JTypeParameter[] typeParams, JClassType[] typeArgs) {
        int n = typeArgs.length;
        for (int i = 0; i < n; ++i) {
            JWildcardType wildcard;
            JWildcardType jWildcardType = wildcard = typeArgs[i] == null ? null : typeArgs[i].isWildcard();
            if (wildcard == null || wildcard.getBoundType() != JWildcardType.BoundType.UNBOUND || wildcard.getBaseType() != this.resolver.getTypeOracle().getJavaLangObject() || typeParams[i].getBaseType() == null) continue;
            typeArgs[i] = this.resolver.getTypeOracle().getWildcardType(JWildcardType.BoundType.UNBOUND, typeParams[i].getBaseType());
        }
    }

    private JType resolveGeneric(JType type, JClassType outer, JClassType[] typeArgs) {
        JGenericType genericType = (JGenericType)type.isGenericType();
        if (genericType != null) {
            int actual = typeArgs.length;
            JTypeParameter[] typeParams = genericType.getTypeParameters();
            int expected = typeParams.length;
            if (actual == 0 && expected > 0) {
                type = genericType.getRawType();
            } else {
                if (actual != expected) {
                    throw new IllegalStateException("Incorrect # of type parameters to " + genericType.getQualifiedBinaryName() + ": expected " + expected + ", actual=" + actual);
                }
                JClassType genericEnc = genericType.getEnclosingType();
                if (outer == null && genericEnc != null) {
                    JClassType[] outerArgs = null;
                    JGenericType genericEncGeneric = genericEnc.isGenericType();
                    if (genericEncGeneric != null) {
                        JTypeParameter[] encTypeParams = genericEncGeneric.getTypeParameters();
                        int n = encTypeParams.length;
                        outerArgs = new JClassType[n];
                        for (int i = 0; i < n; ++i) {
                            outerArgs[i] = this.lookup.lookup(encTypeParams[i].getName());
                            if (outerArgs[i] == null) {
                                for (int j = 0; j < expected; ++j) {
                                    if (!typeParams[j].getName().equals(encTypeParams[j].getName())) continue;
                                    outerArgs[i] = typeArgs[j];
                                    break;
                                }
                            }
                            assert (outerArgs[i] != null) : "Unable to resolve type parameter " + encTypeParams[i].getName() + " in enclosing type " + genericEnc + " of type " + genericType;
                        }
                    }
                    outer = (JClassType)this.resolveGeneric(genericEnc, null, outerArgs);
                }
                try {
                    this.mergeTypeParamBounds(typeParams, typeArgs);
                    type = this.resolver.getTypeOracle().getParameterizedType(genericType, outer, typeArgs);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Unable to build parameterized type ");
                    buf.append(genericType);
                    String prefix = " with args <";
                    for (JClassType typeArg : typeArgs) {
                        buf.append(prefix).append(typeArg.getName());
                        prefix = ", ";
                    }
                    if (", ".equals(prefix)) {
                        buf.append('>');
                    }
                    this.logger.log(TreeLogger.ERROR, buf.toString(), e);
                    type = genericType.getRawType();
                }
            }
        }
        return type;
    }

    private void resolveGenerics() {
        JGenericType genericType = (JGenericType)this.returnTypeRef[0].isGenericType();
        if (genericType != null) {
            int actual = this.args.size();
            JClassType[] typeArgs = new JClassType[actual];
            for (int i = 0; i < actual; ++i) {
                JType type = this.args.get(i)[0];
                if (!(type instanceof JClassType)) {
                    this.logger.log(TreeLogger.ERROR, "Parameterized type argument is " + type + ", expected reference type");
                    continue;
                }
                typeArgs[i] = (JClassType)type;
            }
            this.returnTypeRef[0] = this.resolveGeneric(genericType, this.outerClass, typeArgs);
            this.args.clear();
        }
        for (int i = 0; i < this.arrayDepth; ++i) {
            this.returnTypeRef[0] = this.resolver.getTypeOracle().getArrayType(this.returnTypeRef[0]);
        }
        switch (this.wildcardMatch) {
            case '=': {
                break;
            }
            case '*': {
                this.returnTypeRef[0] = this.resolver.getTypeOracle().getWildcardType(JWildcardType.BoundType.UNBOUND, (JClassType)this.returnTypeRef[0]);
                break;
            }
            case '+': {
                this.returnTypeRef[0] = this.resolver.getTypeOracle().getWildcardType(JWildcardType.BoundType.EXTENDS, (JClassType)this.returnTypeRef[0]);
                break;
            }
            case '-': {
                this.returnTypeRef[0] = this.resolver.getTypeOracle().getWildcardType(JWildcardType.BoundType.SUPER, (JClassType)this.returnTypeRef[0]);
            }
        }
        if (this.returnTypeRef[0] instanceof JClassType) {
            this.outerClass = (JClassType)this.returnTypeRef[0];
        }
    }
}

