/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.asm;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.Resolver;
import com.google.gwt.dev.javac.TypeParameterLookup;
import com.google.gwt.dev.javac.asm.CollectAnnotationData;
import com.google.gwt.dev.javac.asm.CollectMethodData;
import com.google.gwt.dev.javac.asm.EmptySignatureVisitor;
import com.google.gwt.dev.javac.asm.ResolveTypeSignature;
import com.google.gwt.dev.javac.typemodel.JAbstractMethod;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;

public class ResolveMethodSignature
extends EmptySignatureVisitor {
    private final MethodArgNamesLookup allMethodArgs;
    private final String[] argNames;
    private final boolean argNamesAreReal;
    private final Type[] argTypes;
    private ArrayList<JType[]> bounds = null;
    private JTypeParameter currentParam = null;
    private final List<JClassType[]> exceptions = new ArrayList<JClassType[]>();
    private final boolean hasReturnType;
    private final TreeLogger logger;
    private final JAbstractMethod method;
    private final CollectMethodData methodData;
    private final List<JType[]> params = new ArrayList<JType[]>();
    private final Resolver resolver;
    private final JType[] returnType = new JType[1];
    private final TypeParameterLookup typeParamLookup;

    public ResolveMethodSignature(Resolver resolver, TreeLogger logger, JAbstractMethod method, TypeParameterLookup typeParamLookup, boolean hasReturnType, CollectMethodData methodData, Type[] argTypes, String[] argNames, boolean argNamesAreReal, MethodArgNamesLookup allMethodArgs) {
        this.resolver = resolver;
        this.logger = logger;
        this.method = method;
        this.typeParamLookup = typeParamLookup;
        this.hasReturnType = hasReturnType;
        this.methodData = methodData;
        this.argTypes = argTypes;
        this.argNames = argNames;
        this.argNamesAreReal = argNamesAreReal;
        this.allMethodArgs = allMethodArgs;
    }

    public boolean finish() {
        String[] lookupArgNames;
        boolean failed = false;
        this.finishBound();
        if (this.hasReturnType) {
            failed |= this.returnType[0] == null;
            this.resolver.setReturnType(this.method, this.returnType[0]);
        }
        List<CollectAnnotationData>[] argAnnotations = this.methodData.getArgAnnotations();
        if (this.argTypes.length != this.params.size()) {
            throw new IllegalStateException("Arg count mismatch between method descriptor (" + this.methodData.getDesc() + ") and signature (" + this.methodData.getSignature() + ")");
        }
        String[] names = this.argNames;
        boolean namesAreReal = this.argNamesAreReal;
        if (!namesAreReal && (lookupArgNames = this.allMethodArgs.lookup(this.method, this.methodData)) != null) {
            names = lookupArgNames;
            namesAreReal = true;
        }
        for (int i = 0; i < this.argTypes.length; ++i) {
            JType argType = this.params.get(i)[0];
            if (argType == null) {
                failed = true;
                continue;
            }
            HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
            this.resolver.resolveAnnotations(this.logger, argAnnotations[i], declaredAnnotations);
            this.resolver.newParameter(this.method, argType, names[i], declaredAnnotations, namesAreReal);
        }
        for (JClassType[] exc : this.exceptions) {
            if (exc[0] == null) {
                failed = true;
                continue;
            }
            this.resolver.addThrows(this.method, exc[0]);
        }
        return !failed;
    }

    @Override
    public SignatureVisitor visitArrayType() {
        assert (false) : "visitArrayType called on ResolveClassTypeVariables";
        return null;
    }

    @Override
    public SignatureVisitor visitClassBound() {
        JType[] bound = new JClassType[1];
        this.bounds.add(bound);
        return new ResolveTypeSignature(this.resolver, this.logger, bound, this.typeParamLookup, null);
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        JType[] exc = new JClassType[1];
        this.exceptions.add((JClassType[])exc);
        return new ResolveTypeSignature(this.resolver, this.logger, exc, this.typeParamLookup, null);
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        this.finishBound();
        this.currentParam = this.typeParamLookup.lookup(name);
        this.bounds = new ArrayList();
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        JType[] bound = new JType[1];
        this.bounds.add(bound);
        return new ResolveTypeSignature(this.resolver, this.logger, bound, this.typeParamLookup, null);
    }

    @Override
    public SignatureVisitor visitParameterType() {
        JType[] param = new JType[1];
        this.params.add(param);
        return new ResolveTypeSignature(this.resolver, this.logger, param, this.typeParamLookup, null);
    }

    @Override
    public SignatureVisitor visitReturnType() {
        return new ResolveTypeSignature(this.resolver, this.logger, this.returnType, this.typeParamLookup, null);
    }

    private void finishBound() {
        if (this.currentParam != null) {
            int n = this.bounds.size();
            JClassType[] boundTypes = new JClassType[n];
            for (int i = 0; i < n; ++i) {
                boundTypes[i] = (JClassType)this.bounds.get(i)[0];
            }
            this.currentParam.setBounds(boundTypes);
            this.currentParam = null;
            this.bounds = null;
        }
    }
}

