/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.asm;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.javac.Resolver;
import com.google.gwt.dev.javac.TypeParameterLookup;
import com.google.gwt.dev.javac.asm.EmptySignatureVisitor;
import com.google.gwt.dev.javac.asm.ResolveTypeSignature;
import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JRealClassType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;

public class ResolveClassSignature
extends EmptySignatureVisitor {
    private ArrayList<JType[]> bounds = null;
    private JTypeParameter currentParam = null;
    private final List<JType[]> interfaces = new ArrayList<JType[]>();
    private final TreeLogger logger;
    private final TypeParameterLookup lookup;
    private final Resolver resolver;
    private final JType[] superClass = new JType[1];
    private final JRealClassType type;

    public ResolveClassSignature(Resolver resolver, TreeLogger logger, JRealClassType type, TypeParameterLookup lookup) {
        this.resolver = resolver;
        this.logger = logger;
        this.type = type;
        this.lookup = lookup;
    }

    public void finish() {
        if (this.currentParam != null) {
            int n = this.bounds.size();
            JClassType[] boundTypes = new JClassType[n];
            for (int i = 0; i < n; ++i) {
                boundTypes[i] = (JClassType)this.bounds.get(i)[0];
            }
            this.currentParam.setBounds(boundTypes);
            this.currentParam = null;
            this.bounds = null;
        }
        if (this.superClass[0] != null) {
            if (this.type.isInterface() != null) {
                assert (this.superClass[0].equals(this.resolver.getTypeOracle().getJavaLangObject()));
            } else {
                this.resolver.setSuperClass(this.type, (JClassType)this.superClass[0]);
            }
            this.superClass[0] = null;
        }
        for (JType[] intfRef : this.interfaces) {
            if (intfRef[0] == null) continue;
            this.resolver.addImplementedInterface(this.type, (JClassType)intfRef[0]);
        }
        this.interfaces.clear();
    }

    @Override
    public SignatureVisitor visitArrayType() {
        throw new IllegalStateException("visitArrayType called on ResolveClassTypeVariables");
    }

    @Override
    public SignatureVisitor visitClassBound() {
        JType[] bound = new JType[1];
        this.bounds.add(bound);
        return new ResolveTypeSignature(this.resolver, this.logger, bound, this.lookup, null);
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        this.finish();
        this.currentParam = this.lookup.lookup(name);
        this.bounds = new ArrayList();
    }

    @Override
    public SignatureVisitor visitInterface() {
        this.finish();
        JType[] intf = new JType[1];
        this.interfaces.add(intf);
        return new ResolveTypeSignature(this.resolver, this.logger, intf, this.lookup, null);
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        JType[] bound = new JType[1];
        this.bounds.add(bound);
        return new ResolveTypeSignature(this.resolver, this.logger, bound, this.lookup, null);
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.finish();
        return new ResolveTypeSignature(this.resolver, this.logger, this.superClass, this.lookup, null);
    }
}

