/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.asm;

import com.google.gwt.dev.javac.asm.CollectAnnotationData;
import com.google.gwt.dev.javac.asm.CollectClassData;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CollectMethodData
extends MethodVisitor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final List<CollectAnnotationData> annotations = new ArrayList<CollectAnnotationData>();
    private final String name;
    private final String desc;
    private final String signature;
    private final String[] exceptions;
    private Type[] argTypes;
    private final String[] argNames;
    private final List<CollectAnnotationData>[] paramAnnots;
    private boolean actualArgNames = false;
    private final int access;
    private int syntheticArgs;
    private int longDoubleCounter;

    public CollectMethodData(CollectClassData.ClassType classType, int access, String name, String desc, String signature, String[] exceptions) {
        super(589824);
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = exceptions;
        this.syntheticArgs = 0;
        this.argTypes = Type.getArgumentTypes(desc);
        if (classType.hasHiddenConstructorArg() && "<init>".equals(name)) {
            if (this.argTypes.length < 1) {
                throw new IllegalStateException("Missing synthetic argument in constructor");
            }
            this.syntheticArgs = 1;
            int n = this.argTypes.length - this.syntheticArgs;
            Type[] newArgTypes = new Type[n];
            System.arraycopy(this.argTypes, this.syntheticArgs, newArgTypes, 0, n);
            this.argTypes = newArgTypes;
        }
        this.argNames = new String[this.argTypes.length];
        this.paramAnnots = new List[this.argTypes.length];
        for (int i = 0; i < this.argNames.length; ++i) {
            this.argNames[i] = "arg" + i;
            this.paramAnnots[i] = new ArrayList<CollectAnnotationData>();
        }
        if (this.argNames.length == 0) {
            this.actualArgNames = true;
        }
    }

    public int getAccess() {
        return this.access;
    }

    public List<CollectAnnotationData> getAnnotations() {
        return this.annotations;
    }

    public List<CollectAnnotationData>[] getArgAnnotations() {
        return this.paramAnnots;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    public String getDesc() {
        return this.desc;
    }

    public String[] getExceptions() {
        return this.exceptions == null ? EMPTY_STRING_ARRAY : this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean hasActualArgNames() {
        return this.actualArgNames;
    }

    public String toString() {
        return "method " + this.name;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        CollectAnnotationData av = new CollectAnnotationData(desc, visible);
        this.annotations.add(av);
        return av;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index == 0) {
            this.longDoubleCounter = 0;
        } else {
            index -= this.longDoubleCounter;
        }
        if ((this.access & 8) == 0) {
            --index;
        }
        if (index >= 0 && index < this.argNames.length) {
            this.actualArgNames = true;
            this.argNames[index] = name;
        }
        if ("J".equals(desc) || "D".equals(desc)) {
            ++this.longDoubleCounter;
        }
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        CollectAnnotationData av = new CollectAnnotationData(desc, visible);
        if (parameter >= this.syntheticArgs) {
            this.paramAnnots[parameter - this.syntheticArgs].add(av);
        }
        return av;
    }
}

