/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.asm;

import com.google.gwt.dev.javac.asm.CollectAnnotationData;
import com.google.gwt.dev.javac.asm.CollectFieldData;
import com.google.gwt.dev.javac.asm.CollectMethodData;
import com.google.gwt.dev.javac.asmbridge.EmptyVisitor;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.StringInterner;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class CollectClassData
extends EmptyVisitor {
    private int access;
    private final List<CollectAnnotationData> annotations = new ArrayList<CollectAnnotationData>();
    private ClassType classType = ClassType.TopLevel;
    private String enclosingInternalName;
    private String enclosingMethodDesc;
    private String enclosingMethodName;
    private final List<CollectFieldData> fields = new ArrayList<CollectFieldData>();
    private String[] interfaceInternalNames;
    private String internalName;
    private String nestedSourceName;
    private final List<CollectMethodData> methods = new ArrayList<CollectMethodData>();
    private String signature;
    private String source = null;
    private String superInternalName;

    public int getAccess() {
        return this.access;
    }

    public List<CollectAnnotationData> getAnnotations() {
        return this.annotations;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public String getEnclosingInternalName() {
        return this.enclosingInternalName;
    }

    public String getEnclosingMethodDesc() {
        return this.enclosingMethodDesc;
    }

    public String getEnclosingMethodName() {
        return this.enclosingMethodName;
    }

    public List<CollectFieldData> getFields() {
        return this.fields;
    }

    public String[] getInterfaceInternalNames() {
        return this.interfaceInternalNames;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public List<CollectMethodData> getMethods() {
        return this.methods;
    }

    public String getNestedSourceName() {
        return this.nestedSourceName;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSource() {
        return this.source;
    }

    public String getSuperInternalName() {
        return this.superInternalName;
    }

    public boolean hasNoExternalName() {
        return this.classType.hasNoExternalName();
    }

    public boolean isAnonymous() {
        return this.classType == ClassType.Anonymous;
    }

    public String toString() {
        return "class " + this.internalName;
    }

    @Override
    public void visit(int version, int access, String internalName, String signature, String superInternalName, String[] interfaces) {
        this.access = access;
        assert (Name.isInternalName(internalName));
        this.internalName = internalName;
        this.signature = signature;
        this.superInternalName = superInternalName;
        this.interfaceInternalNames = interfaces;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        CollectAnnotationData av = new CollectAnnotationData(desc, visible);
        this.annotations.add(av);
        return av;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.classType == ClassType.TopLevel) {
            this.nestedSourceName = this.internalName.substring(this.internalName.lastIndexOf(47) + 1);
        } else if (this.classType == ClassType.Anonymous) {
            this.nestedSourceName = null;
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        CollectFieldData fv = new CollectFieldData(access, name, desc, signature, value);
        this.fields.add(fv);
        return fv;
    }

    @Override
    public void visitInnerClass(String internalName, String enclosingInternalName, String innerName, int access) {
        this.buildNestedSourceName(internalName, enclosingInternalName, innerName);
        if (this.internalName.equals(internalName)) {
            if (enclosingInternalName != null) {
                this.enclosingInternalName = enclosingInternalName;
            }
            this.access = access;
            boolean isStatic = (access & 8) != 0;
            switch (this.classType) {
                case TopLevel: {
                    this.classType = isStatic ? ClassType.Nested : ClassType.Inner;
                    break;
                }
                case Anonymous: {
                    if (innerName == null) break;
                    this.classType = ClassType.Local;
                    break;
                }
                case Inner: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected INNERCLASS with type of " + (Object)((Object)this.classType));
                }
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        CollectMethodData mv = new CollectMethodData(this.classType, access, name, desc, signature, exceptions);
        this.methods.add(mv);
        return mv;
    }

    @Override
    public void visitOuterClass(String enclosingInternalName, String enclosingMethodName, String enclosingMethodDesc) {
        this.enclosingInternalName = enclosingInternalName;
        this.enclosingMethodName = enclosingMethodName;
        this.enclosingMethodDesc = enclosingMethodDesc;
        this.classType = ClassType.Anonymous;
    }

    @Override
    public void visitSource(String source, String debug) {
        this.source = source;
    }

    private void buildNestedSourceName(String internalName, String enclosingInternalName, String innerName) {
        if (this.classType == ClassType.Anonymous || enclosingInternalName == null) {
            return;
        }
        if (!this.internalName.startsWith(internalName + "$") && !this.internalName.equals(internalName)) {
            return;
        }
        if (this.nestedSourceName == null) {
            this.nestedSourceName = enclosingInternalName.substring(enclosingInternalName.lastIndexOf(47) + 1);
        }
        this.nestedSourceName = this.nestedSourceName + "." + innerName;
    }

    public static enum ClassType {
        Anonymous{

            @Override
            public boolean hasNoExternalName() {
                return true;
            }
        }
        ,
        Inner{

            @Override
            public boolean hasHiddenConstructorArg() {
                return true;
            }
        }
        ,
        Local{

            @Override
            public boolean hasNoExternalName() {
                return true;
            }
        }
        ,
        Nested,
        TopLevel;


        public boolean hasHiddenConstructorArg() {
            return false;
        }

        public boolean hasNoExternalName() {
            return false;
        }
    }

    public static class AnnotationEnum {
        private final String desc;
        private final String value;

        public AnnotationEnum(String desc, String value) {
            this.desc = StringInterner.get().intern(desc);
            this.value = StringInterner.get().intern(value);
        }

        public String getDesc() {
            return this.desc;
        }

        public String getValue() {
            return this.value;
        }
    }
}

