/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac.asm;

import com.google.gwt.dev.javac.asm.CollectClassData;
import com.google.gwt.dev.util.StringInterner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;

public class CollectAnnotationData
extends AnnotationVisitor {
    private final AnnotationData annotation;
    private final Callback<AnnotationData> callback;

    public CollectAnnotationData(String desc, boolean visible) {
        this(desc, visible, null);
    }

    CollectAnnotationData(String desc, boolean visible, Callback<AnnotationData> callback) {
        super(589824);
        this.annotation = new AnnotationData(desc, visible);
        this.callback = callback;
    }

    public AnnotationData getAnnotation() {
        return this.annotation;
    }

    @Override
    public void visit(String name, Object value) {
        this.annotation.addValue(name, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(final String name, String desc) {
        return new CollectAnnotationData(desc, true, new Callback<AnnotationData>(){

            @Override
            public void call(AnnotationData value) {
                CollectAnnotationData.this.annotation.addValue(name, value);
            }
        });
    }

    @Override
    public AnnotationVisitor visitArray(final String name) {
        return new MyAnnotationArrayVisitor(new Callback<Object>(){

            @Override
            public void call(Object value) {
                CollectAnnotationData.this.annotation.addValue(name, value);
            }
        });
    }

    @Override
    public void visitEnd() {
        if (this.callback != null) {
            this.callback.call(this.annotation);
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.annotation.addValue(name, new CollectClassData.AnnotationEnum(desc, value));
    }

    private static interface Callback<T> {
        public void call(T var1);
    }

    public static class MyAnnotationArrayVisitor
    extends AnnotationVisitor {
        private final Callback<Object> callback;
        private final List<Object> values = new ArrayList<Object>();

        public MyAnnotationArrayVisitor(Callback<Object> callback) {
            super(589824);
            this.callback = callback;
        }

        @Override
        public void visit(String name, Object value) {
            this.values.add(value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new CollectAnnotationData(desc, true, new Callback<AnnotationData>(){

                @Override
                public void call(AnnotationData value) {
                    values.add(value);
                }
            });
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new MyAnnotationArrayVisitor(new Callback<Object>(){

                @Override
                public void call(Object value) {
                    values.add(value);
                }
            });
        }

        @Override
        public void visitEnd() {
            this.callback.call(this.values.toArray());
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.values.add(new CollectClassData.AnnotationEnum(desc, value));
        }
    }

    public static class AnnotationData {
        private final String desc;
        private final Map<String, Object> values = new HashMap<String, Object>();
        private final boolean visible;

        protected AnnotationData(String desc, boolean visible) {
            this.desc = StringInterner.get().intern(desc);
            this.visible = visible;
        }

        public void addValue(String name, Object value) {
            this.values.put(StringInterner.get().intern(name), value);
        }

        public String getDesc() {
            return this.desc;
        }

        public Map<String, Object> getValues() {
            return this.values;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

