/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;

public class UnusedImportsRemover {
    private Set<String> usedNames = new HashSet<String>();

    public static void exec(CompilationUnitDeclaration cud) {
        new UnusedImportsRemover().execImpl(cud);
    }

    /*
     * WARNING - void declaration
     */
    void execImpl(CompilationUnitDeclaration cud) {
        void var6_11;
        if (cud.imports == null) {
            return;
        }
        AccumulateNamesVisitor astVisitor = new AccumulateNamesVisitor();
        if (cud.types != null) {
            for (Statement statement : cud.types) {
                ((TypeDeclaration)statement).traverse((ASTVisitor)astVisitor, cud.scope);
            }
        }
        if (cud.currentPackage != null && cud.currentPackage.annotations != null) {
            for (Statement statement : cud.currentPackage.annotations) {
                ((Annotation)statement).traverse((ASTVisitor)astVisitor, (BlockScope)null);
            }
        }
        ArrayList<ImportReference> newImports = new ArrayList<ImportReference>();
        ImportReference[] importReferenceArray = cud.imports;
        int n = importReferenceArray.length;
        boolean bl = false;
        while (var6_11 < n) {
            ImportReference importRef = importReferenceArray[var6_11];
            String importName = new String(importRef.getImportName()[importRef.getImportName().length - 1]);
            if (importName.equals("*") || importRef.trailingStarPosition > 0 || this.usedNames.contains(importName)) {
                newImports.add(importRef);
            }
            ++var6_11;
        }
        if (newImports.size() != cud.imports.length) {
            cud.imports = newImports.toArray(new ImportReference[newImports.size()]);
        }
    }

    private class AccumulateNamesVisitor
    extends ASTVisitor {
        private AccumulateNamesVisitor() {
        }

        @Override
        public void endVisit(SingleNameReference singleNameReference, BlockScope scope) {
            this.addName(singleNameReference);
        }

        @Override
        public void endVisit(SingleNameReference singleNameReference, ClassScope scope) {
            this.addName(singleNameReference);
        }

        @Override
        public void endVisit(SingleTypeReference singleTypeReference, BlockScope scope) {
            this.addName(singleTypeReference);
        }

        @Override
        public void endVisit(SingleTypeReference singleTypeReference, ClassScope scope) {
            this.addName(singleTypeReference);
        }

        @Override
        public void endVisit(MessageSend messageSend, BlockScope scope) {
            if (messageSend.receiver instanceof ThisReference) {
                UnusedImportsRemover.this.usedNames.add(new String(messageSend.selector));
            }
        }

        @Override
        public void endVisit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
            this.addName(arrayTypeReference);
        }

        @Override
        public void endVisit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
            this.addName(arrayTypeReference);
        }

        @Override
        public void endVisit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
            this.addName(arrayQualifiedTypeReference);
        }

        @Override
        public void endVisit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
            this.addName(arrayQualifiedTypeReference);
        }

        @Override
        public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope scope) {
            this.addName(parameterizedQualifiedTypeReference);
        }

        @Override
        public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
            this.addName(parameterizedQualifiedTypeReference);
        }

        @Override
        public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
            this.addName(parameterizedSingleTypeReference);
        }

        @Override
        public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
            this.addName(parameterizedSingleTypeReference);
        }

        @Override
        public void endVisit(QualifiedTypeReference qualifiedTypeReference, BlockScope scope) {
            this.addName(qualifiedTypeReference);
        }

        @Override
        public void endVisit(QualifiedTypeReference qualifiedTypeReference, ClassScope scope) {
            this.addName(qualifiedTypeReference);
        }

        @Override
        public void endVisit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
            this.addName(qualifiedNameReference);
        }

        @Override
        public void endVisit(QualifiedNameReference qualifiedNameReference, ClassScope scope) {
            this.addName(qualifiedNameReference);
        }

        public void addName(QualifiedNameReference reference) {
            UnusedImportsRemover.this.usedNames.add(new String(reference.tokens[0]));
        }

        public void addName(QualifiedTypeReference reference) {
            UnusedImportsRemover.this.usedNames.add(new String(reference.tokens[0]));
        }

        public void addName(SingleTypeReference reference) {
            UnusedImportsRemover.this.usedNames.add(new String(reference.token));
        }

        public void addName(SingleNameReference reference) {
            UnusedImportsRemover.this.usedNames.add(new String(reference.token));
        }
    }
}

