/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.javac.MemoryUnitCache;
import com.google.gwt.dev.javac.PersistentUnitCache;
import com.google.gwt.dev.javac.UnitCache;
import com.google.gwt.dev.jjs.JJSOptions;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.util.tools.shared.Md5Utils;
import com.google.gwt.util.tools.shared.StringUtils;
import java.io.File;

public class UnitCacheSingleton {
    public static final String GWT_PERSISTENTUNITCACHE = "gwt.persistentunitcache";
    private static final String GWT_PERSISTENTUNITCACHEDIR = "gwt.persistentunitcachedir";
    private static final String configPropertyValue = System.getProperty("gwt.persistentunitcache", "true");
    private static final boolean usePersistent = configPropertyValue.length() == 0 || Boolean.parseBoolean(configPropertyValue);
    private static UnitCache instance = null;

    public static synchronized void clearCache() throws UnableToCompleteException {
        if (instance == null) {
            return;
        }
        instance.clear();
    }

    public static String getRelevantOptionsHash(JJSOptions options) {
        return StringUtils.toHexString(Md5Utils.getMd5Digest(Joiner.on('-').join(options.getJsInteropExportFilter(), options.shouldGenerateJsInteropExports(), new Object[]{options.getSourceLevel()}).getBytes()));
    }

    public static synchronized UnitCache get(TreeLogger logger, File specifiedCacheDir, JJSOptions options) {
        return UnitCacheSingleton.get(logger, specifiedCacheDir, null, options);
    }

    public static synchronized UnitCache get(TreeLogger logger, File specifiedCacheDir, File fallbackCacheDir, JJSOptions options) {
        assert (logger != null);
        if (instance == null) {
            File propertyCacheDir;
            String propertyCachePath = System.getProperty(GWT_PERSISTENTUNITCACHEDIR);
            File file = propertyCacheDir = propertyCachePath != null ? new File(propertyCachePath) : null;
            if (usePersistent) {
                File actualCacheDir = null;
                if (specifiedCacheDir != null) {
                    actualCacheDir = specifiedCacheDir;
                } else if (propertyCacheDir != null) {
                    actualCacheDir = propertyCacheDir;
                } else if (fallbackCacheDir != null) {
                    actualCacheDir = fallbackCacheDir;
                } else {
                    logger.log(TreeLogger.TRACE, "Persistent caching disabled - no directory specified.\nTo enable persistent unit caching use -Dgwt.persistentunitcachedir=<dir>");
                }
                if (actualCacheDir != null) {
                    try {
                        instance = new PersistentUnitCache(logger, actualCacheDir, UnitCacheSingleton.getRelevantOptionsHash(options));
                        return instance;
                    }
                    catch (UnableToCompleteException unableToCompleteException) {
                        // empty catch block
                    }
                }
            }
            instance = new MemoryUnitCache();
        }
        return instance;
    }
}

