/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.typemodel.JClassType;
import com.google.gwt.dev.javac.typemodel.JGenericType;
import com.google.gwt.dev.javac.typemodel.JTypeParameter;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.collect.Maps;
import java.util.LinkedList;
import java.util.Map;

public class TypeParameterLookup {
    private LinkedList<Map<String, JTypeParameter>> scopeStack = new LinkedList();

    public JTypeParameter lookup(String name) {
        for (Map map : this.scopeStack) {
            JTypeParameter result = (JTypeParameter)map.get(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void popScope() {
        this.scopeStack.remove();
    }

    public void pushEnclosingScopes(JClassType type) {
        if (type == null) {
            return;
        }
        this.pushEnclosingScopes(type.getEnclosingType());
        JGenericType genericType = type.isGenericType();
        if (genericType != null) {
            this.pushScope(genericType.getTypeParameters());
        }
    }

    public void pushScope(JTypeParameter[] typeParams) {
        this.scopeStack.addFirst(this.buildScope(typeParams));
    }

    private Map<String, JTypeParameter> buildScope(JTypeParameter[] typeParams) {
        switch (typeParams.length) {
            case 0: {
                return Maps.create();
            }
            case 1: {
                return Maps.create(typeParams[0].getName(), typeParams[0]);
            }
        }
        HashMap<String, JTypeParameter> scope = new HashMap<String, JTypeParameter>();
        for (JTypeParameter typeParam : typeParams) {
            scope.put(typeParam.getName(), typeParam);
        }
        return scope;
    }
}

