/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.CachedGeneratorResult;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.IncrementalGenerator;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.RebindResult;
import com.google.gwt.core.ext.RebindRuleResolver;
import com.google.gwt.core.ext.SubsetFilteringPropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.impl.ResourceLocatorImpl;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.GeneratedResource;
import com.google.gwt.core.ext.linker.impl.StandardGeneratedResource;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.cfg.RuleGenerateWith;
import com.google.gwt.dev.javac.CachedGeneratorResultImpl;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.GeneratedUnit;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.dev.resource.impl.AbstractResourceOracle;
import com.google.gwt.dev.util.DiskCache;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.dev.util.collect.IdentityHashMap;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.io.Files;
import com.google.gwt.util.tools.Utility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class StandardGeneratorContext
implements GeneratorContext {
    private static final String GENERATOR_VERSION_ID_KEY = "generator-version-id";
    private static DiskCache diskCache = DiskCache.INSTANCE;
    private static final Map<String, CompilerEventType> eventsByGeneratorType = new HashMap<String, CompilerEventType>();
    private final ArtifactSet allGeneratedArtifacts;
    private final Map<String, GeneratedUnit> committedGeneratedCups = new HashMap<String, GeneratedUnit>();
    private CompilationState compilationState;
    private Class<? extends Generator> currentGenerator;
    private final File genDir;
    private final Map<Class<? extends Generator>, Generator> generators = new IdentityHashMap<Class<? extends Generator>, Generator>();
    private ArtifactSet newlyGeneratedArtifacts = new ArtifactSet();
    private final Set<String> newlyGeneratedTypeNames = new HashSet<String>();
    private final Map<String, PendingResource> pendingResources = new HashMap<String, PendingResource>();
    private transient PropertyOracle propertyOracle;
    private RebindRuleResolver rebindRuleResolver;
    private final Map<PrintWriter, Generated> uncommittedGeneratedCupsByPrintWriter = new IdentityHashMap<PrintWriter, Generated>();
    private CachedGeneratorResultImpl cachedRebindResult = null;
    private boolean generatorResultCachingEnabled = false;
    private List<String> cachedTypeNamesToReuse = null;
    private boolean isProdMode;
    private CompilerContext compilerContext;
    private String currentRebindBinaryTypeName;
    private final ResourceOracle buildResourceOracle;

    public StandardGeneratorContext(CompilerContext compilerContext, CompilationState compilationState, ArtifactSet allGeneratedArtifacts, boolean isProdMode) {
        this.compilerContext = compilerContext;
        this.compilationState = compilationState;
        this.genDir = compilerContext.getOptions().getGenDir();
        this.allGeneratedArtifacts = allGeneratedArtifacts;
        this.isProdMode = isProdMode;
        this.buildResourceOracle = new RecordingResourceOracle(compilerContext.getBuildResourceOracle());
        ResourceLocatorImpl.resetClassLoaderLoadWarningCount();
    }

    public void addGeneratedUnit(GeneratedUnit gu) {
        if (!this.committedGeneratedCups.containsKey(gu.getTypeName())) {
            this.committedGeneratedCups.put(gu.getTypeName(), gu);
        }
    }

    public void addGeneratedUnits(Collection<GeneratedUnit> generatedUnits) {
        for (GeneratedUnit gu : generatedUnits) {
            this.addGeneratedUnit(gu);
        }
    }

    public void addGeneratedUnitsFromCache() {
        if (this.cachedRebindResult != null && this.cachedRebindResult.getGeneratedUnits() != null) {
            this.addGeneratedUnits(this.cachedRebindResult.getGeneratedUnits());
        }
    }

    public void addGeneratedUnitsMarkedForReuseFromCache() {
        if (this.cachedTypeNamesToReuse != null && this.cachedRebindResult != null) {
            for (String typeName : this.cachedTypeNamesToReuse) {
                GeneratedUnit gu = this.cachedRebindResult.getGeneratedUnit(typeName);
                if (gu == null) continue;
                this.addGeneratedUnit(gu);
            }
        }
    }

    @Override
    public boolean checkRebindRuleAvailable(String sourceTypeName) {
        if (this.rebindRuleResolver != null) {
            return this.rebindRuleResolver.checkRebindRuleResolvable(sourceTypeName);
        }
        return false;
    }

    public void clear() {
        this.compilationState = null;
        this.generators.clear();
    }

    @Override
    public final void commit(TreeLogger logger, PrintWriter pw) {
        Generated gcup = this.uncommittedGeneratedCupsByPrintWriter.get(pw);
        if (gcup == null) {
            logger.log(TreeLogger.WARN, "Generator attempted to commit an unknown PrintWriter", null);
            return;
        }
        gcup.commit(logger);
        this.uncommittedGeneratedCupsByPrintWriter.remove(pw);
        this.committedGeneratedCups.put(gcup.getTypeName(), gcup);
        if (this.currentGenerator == null) {
            return;
        }
        StandardGeneratedResource debuggerSource = new StandardGeneratedResource(gcup.getSourceMapPath(), gcup.getSourceToken());
        debuggerSource.setVisibility(EmittedArtifact.Visibility.Source);
        this.commitArtifact(logger, debuggerSource);
    }

    @Override
    public void commitArtifact(TreeLogger logger, Artifact<?> artifact) {
        this.allGeneratedArtifacts.replace(artifact);
        this.newlyGeneratedArtifacts.add(artifact);
    }

    public void commitArtifactsFromCache(TreeLogger logger) {
        if (this.cachedRebindResult != null && this.cachedRebindResult.getArtifacts() != null) {
            for (Artifact<?> art : this.cachedRebindResult.getArtifacts()) {
                this.commitArtifact(logger, art);
            }
        }
    }

    @Override
    public GeneratedResource commitResource(TreeLogger logger, OutputStream os) throws UnableToCompleteException {
        PendingResource pendingResource = null;
        String partialPath = null;
        if (os instanceof PendingResource && (pendingResource = (PendingResource)os) != this.pendingResources.get(partialPath = pendingResource.getPartialPath())) {
            pendingResource = null;
        }
        if (pendingResource == null) {
            logger.log(TreeLogger.WARN, "Generator attempted to commit an unknown OutputStream", null);
            throw new UnableToCompleteException();
        }
        StandardGeneratedResource toReturn = new StandardGeneratedResource(partialPath, pendingResource.takeBytes());
        this.commitArtifact(logger, toReturn);
        this.pendingResources.remove(pendingResource.getPartialPath());
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactSet finish(TreeLogger logger) throws UnableToCompleteException {
        ArtifactSet artifactSet;
        block8: {
            this.abortUncommittedResources(logger);
            try {
                if (this.isDirty()) {
                    String msg = "Assimilating generated source";
                    TreeLogger branch = logger.branch(TreeLogger.DEBUG, msg, null);
                    TreeLogger subBranch = null;
                    if (branch.isLoggable(TreeLogger.DEBUG)) {
                        subBranch = branch.branch(TreeLogger.DEBUG, "Generated source files...", null);
                    }
                    for (GeneratedUnit gcup : this.committedGeneratedCups.values()) {
                        String qualifiedTypeName = gcup.getTypeName();
                        if (subBranch == null) continue;
                        subBranch.log(TreeLogger.DEBUG, qualifiedTypeName, null);
                    }
                    this.compilationState.addGeneratedCompilationUnits(logger, this.committedGeneratedCups.values());
                }
                artifactSet = this.newlyGeneratedArtifacts;
                if (this.uncommittedGeneratedCupsByPrintWriter.isEmpty()) break block8;
                String msg = "For the following type(s), generated source was never committed (did you forget to call commit()?)";
                logger = logger.branch(TreeLogger.WARN, msg, null);
            }
            catch (Throwable throwable) {
                if (!this.uncommittedGeneratedCupsByPrintWriter.isEmpty()) {
                    String msg = "For the following type(s), generated source was never committed (did you forget to call commit()?)";
                    logger = logger.branch(TreeLogger.WARN, msg, null);
                    for (Generated unit : this.uncommittedGeneratedCupsByPrintWriter.values()) {
                        logger.log(TreeLogger.WARN, unit.getTypeName(), null);
                    }
                }
                this.reset();
                throw throwable;
            }
            for (Generated unit : this.uncommittedGeneratedCupsByPrintWriter.values()) {
                logger.log(TreeLogger.WARN, unit.getTypeName(), null);
            }
        }
        this.reset();
        return artifactSet;
    }

    public boolean isDirty() {
        return !this.committedGeneratedCups.isEmpty();
    }

    public void reset() {
        this.uncommittedGeneratedCupsByPrintWriter.clear();
        this.committedGeneratedCups.clear();
        this.newlyGeneratedTypeNames.clear();
        this.newlyGeneratedArtifacts = new ArtifactSet();
        this.cachedTypeNamesToReuse = null;
    }

    public Set<String> getActiveLinkerNames() {
        return this.compilerContext.getModule().getActiveLinkerNames();
    }

    public ArtifactSet getArtifacts() {
        return new ArtifactSet(this.newlyGeneratedArtifacts);
    }

    @Override
    public CachedGeneratorResult getCachedGeneratorResult() {
        return this.cachedRebindResult;
    }

    public GeneratorContext getCanonicalContext() {
        return this;
    }

    public CompilationState getCompilationState() {
        return this.compilationState;
    }

    public Map<String, GeneratedUnit> getGeneratedUnitMap() {
        return this.committedGeneratedCups;
    }

    @Override
    public final PropertyOracle getPropertyOracle() {
        return this.propertyOracle;
    }

    @Override
    public ResourceOracle getResourcesOracle() {
        return this.buildResourceOracle;
    }

    @Override
    public final TypeOracle getTypeOracle() {
        return this.compilationState.getTypeOracle();
    }

    @Override
    public boolean isGeneratorResultCachingEnabled() {
        return this.generatorResultCachingEnabled;
    }

    @Override
    public boolean isProdMode() {
        return this.isProdMode;
    }

    public String runGenerator(TreeLogger logger, Class<? extends Generator> generatorClass, String typeName) throws UnableToCompleteException {
        RebindResult result = this.runGeneratorIncrementally(logger, generatorClass, typeName);
        return result.getResultTypeName();
    }

    public RebindResult runGeneratorIncrementally(TreeLogger logger, Class<? extends Generator> generatorClass, String typeName) throws UnableToCompleteException {
        String msg = "Invoking generator " + generatorClass.getName();
        logger = logger.branch(TreeLogger.DEBUG, msg, null);
        Generator generator = this.generators.get(generatorClass);
        if (generator == null) {
            try {
                generator = generatorClass.newInstance();
                this.generators.put(generatorClass, generator);
            }
            catch (Throwable e) {
                logger.log(TreeLogger.ERROR, "Unexpected error trying to instantiate Generator '" + generatorClass.getName() + "'", e);
                throw new UnableToCompleteException();
            }
        }
        this.setCurrentGenerator(generatorClass);
        boolean loggable = logger.isLoggable(TreeLogger.DEBUG);
        long before = loggable ? System.currentTimeMillis() : 0L;
        String generatorClassName = generator.getClass().getName();
        CompilerEventType type = eventsByGeneratorType.get(generatorClassName);
        if (type == null) {
            type = CompilerEventType.GENERATOR_OTHER;
        }
        SpeedTracerLogger.Event generatorEvent = SpeedTracerLogger.start(type, "class", generatorClassName, "type", typeName);
        PropertyOracle originalPropertyOracle = this.propertyOracle;
        try {
            RebindResult result;
            this.propertyOracle = new SubsetFilteringPropertyOracle(RuleGenerateWith.getAccessedPropertyNames(generator.getClass()), originalPropertyOracle, generatorClassName + "'s RunsLocal annotation may need to be updated.");
            if (generator instanceof IncrementalGenerator) {
                Long cachedVersionId;
                IncrementalGenerator incGenerator = (IncrementalGenerator)generator;
                if (this.cachedRebindResult != null && (cachedVersionId = (Long)this.cachedRebindResult.getClientData(GENERATOR_VERSION_ID_KEY)) != null && cachedVersionId.longValue() != incGenerator.getVersionId()) {
                    if (logger.isLoggable(TreeLogger.TRACE)) {
                        logger.log(TreeLogger.TRACE, "Got version mismatch with cached generator result for " + typeName + ", invalidating cached result");
                    }
                    this.cachedRebindResult = null;
                }
                result = incGenerator.generateIncrementally(logger, this, typeName);
                result.putClientData(GENERATOR_VERSION_ID_KEY, Long.valueOf(incGenerator.getVersionId()));
            } else {
                result = IncrementalGenerator.generateNonIncrementally(logger, generator, this, typeName);
            }
            if (loggable) {
                long after = System.currentTimeMillis();
                msg = "Generator returned type '" + result.getResultTypeName() + "; mode " + (Object)((Object)result.getRebindMode()) + "; in " + (after - before) + " ms";
                logger.log(TreeLogger.DEBUG, msg, null);
            }
            RebindResult rebindResult = result;
            return rebindResult;
        }
        catch (AssertionError e) {
            logger.log(TreeLogger.ERROR, "Generator '" + generatorClass.getName() + "' failed an assertion while rebinding '" + typeName + "'", (Throwable)((Object)e));
            throw new UnableToCompleteException();
        }
        catch (RuntimeException e) {
            logger.log(TreeLogger.ERROR, "Generator '" + generatorClass.getName() + "' threw an exception while rebinding '" + typeName + "'", e);
            throw new UnableToCompleteException();
        }
        finally {
            this.propertyOracle = originalPropertyOracle;
            generatorEvent.end(new String[0]);
        }
    }

    public void setCachedGeneratorResult(CachedGeneratorResult cachedRebindResult) {
        this.cachedRebindResult = (CachedGeneratorResultImpl)cachedRebindResult;
    }

    public void setCurrentGenerator(Class<? extends Generator> currentGenerator) {
        this.currentGenerator = currentGenerator;
    }

    public void setCurrentRebindBinaryTypeName(String currentRebindBinaryTypeName) {
        this.currentRebindBinaryTypeName = currentRebindBinaryTypeName;
    }

    public void setGeneratorResultCachingEnabled(boolean enabled) {
        this.generatorResultCachingEnabled = enabled;
    }

    public void setPropertyOracle(PropertyOracle propertyOracle) {
        this.propertyOracle = propertyOracle;
    }

    public void setRebindRuleResolver(RebindRuleResolver resolver) {
        this.rebindRuleResolver = resolver;
    }

    @Override
    public PrintWriter tryCreate(TreeLogger logger, String packageName, String simpleTypeName) {
        GeneratedUnitImpl gcup;
        String typeName = packageName.length() == 0 ? simpleTypeName : packageName + '.' + simpleTypeName;
        this.compilerContext.getMinimalRebuildCache().associateReboundTypeWithGeneratedCompilationUnitName(this.currentRebindBinaryTypeName, typeName);
        JClassType existingType = this.getTypeOracle().findType(packageName, simpleTypeName);
        if (existingType != null) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Type '" + typeName + "' already exists and will not be re-created ", null);
            }
            return null;
        }
        if (this.newlyGeneratedTypeNames.contains(typeName)) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw, true){

            @Override
            public void println() {
                super.print('\n');
                super.flush();
            }
        };
        if (this.genDir == null) {
            gcup = new GeneratedUnitImpl(sw, typeName);
        } else {
            File dir = new File(this.genDir, packageName.replace('.', File.separatorChar));
            dir.mkdirs();
            File srcFile = new File(dir, simpleTypeName + ".java");
            if (srcFile.exists()) {
                srcFile.delete();
            }
            gcup = new GeneratedUnitWithFile(srcFile, sw, typeName);
        }
        this.uncommittedGeneratedCupsByPrintWriter.put(pw, gcup);
        this.newlyGeneratedTypeNames.add(typeName);
        return pw;
    }

    @Override
    public OutputStream tryCreateResource(TreeLogger logger, String partialPath) throws UnableToCompleteException {
        logger = logger.branch(TreeLogger.DEBUG, "Preparing pending output resource '" + partialPath + "'", null);
        if (partialPath == null || partialPath.trim().equals("")) {
            logger.log(TreeLogger.ERROR, "The resource name must be a non-empty string", null);
            throw new UnableToCompleteException();
        }
        if (new File(partialPath).isAbsolute()) {
            logger.log(TreeLogger.ERROR, "Resource paths are intended to be relative to the compiled output directory and cannot be absolute", null);
            throw new UnableToCompleteException();
        }
        if (partialPath.indexOf(92) >= 0) {
            logger.log(TreeLogger.ERROR, "Resource paths must contain forward slashes (not backslashes) to denote subdirectories", null);
            throw new UnableToCompleteException();
        }
        if (this.compilerContext.getPublicResourceOracle().getResource(partialPath) != null) {
            logger.log(TreeLogger.WARN, "Cannot create resource '" + partialPath + "' because it already exists on the public path", null);
            return null;
        }
        SortedSet<GeneratedResource> resources = this.allGeneratedArtifacts.find(GeneratedResource.class);
        for (GeneratedResource resource : resources) {
            if (!partialPath.equals(resource.getPartialPath())) continue;
            return null;
        }
        if (this.pendingResources.containsKey(partialPath)) {
            logger.log(TreeLogger.WARN, "The file '" + partialPath + "' is already a pending resource", null);
            return null;
        }
        PendingResource pendingResource = new PendingResource(partialPath);
        this.pendingResources.put(partialPath, pendingResource);
        return pendingResource;
    }

    @Override
    public boolean tryReuseTypeFromCache(String typeName) {
        if (!this.isGeneratorResultCachingEnabled() || this.cachedRebindResult == null || !this.cachedRebindResult.isTypeCached(typeName)) {
            return false;
        }
        if (this.cachedTypeNamesToReuse == null) {
            this.cachedTypeNamesToReuse = new ArrayList<String>();
        }
        this.cachedTypeNamesToReuse.add(typeName);
        return true;
    }

    private void abortUncommittedResources(TreeLogger logger) {
        if (this.pendingResources.isEmpty()) {
            return;
        }
        logger = logger.branch(TreeLogger.WARN, "The following resources will not be created because they were never committed (did you forget to call commit()?)", null);
        for (Map.Entry<String, PendingResource> entry : this.pendingResources.entrySet()) {
            logger.log(TreeLogger.WARN, entry.getKey());
            entry.getValue().abort();
        }
        this.pendingResources.clear();
    }

    static {
        eventsByGeneratorType.put("com.google.gwt.resources.rebind.context.InlineClientBundleGenerator", CompilerEventType.GENERATOR_CLIENT_BUNDLE);
        eventsByGeneratorType.put("com.google.gwt.i18n.rebind.LocalizableGenerator", CompilerEventType.GENERATOR_I18N);
        eventsByGeneratorType.put("com.google.gwt.i18n.rebind.LocaleInfoGenerator", CompilerEventType.GENERATOR_I18N);
        eventsByGeneratorType.put("com.google.gwt.i18n.rebind.CurrencyListGenerator", CompilerEventType.GENERATOR_I18N);
        eventsByGeneratorType.put("com.google.gwt.i18n.rebind.CustomDateTimeFormatGenerator", CompilerEventType.GENERATOR_I18N);
        eventsByGeneratorType.put("com.google.gwt.user.rebind.rpc.ServiceInterfaceProxyGenerator", CompilerEventType.GENERATOR_RPC);
        eventsByGeneratorType.put("com.google.gwt.uibinder.rebind.UiBinderGenerator", CompilerEventType.GENERATOR_UIBINDER);
        eventsByGeneratorType.put("com.google.gwt.inject.rebind.GinjectorGenerator", CompilerEventType.GENERATOR_GIN);
    }

    private static class PendingResource
    extends OutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final String partialPath;

        public PendingResource(String partialPath) {
            this.partialPath = partialPath;
        }

        public void abort() {
            this.baos = null;
        }

        public String getPartialPath() {
            return this.partialPath;
        }

        public byte[] takeBytes() {
            byte[] result = this.baos.toByteArray();
            this.baos = null;
            return result;
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.baos == null) {
                throw new IOException("stream closed");
            }
            this.baos.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.baos == null) {
                throw new IOException("stream closed");
            }
            this.baos.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.baos == null) {
                throw new IOException("stream closed");
            }
            this.baos.write(b);
        }
    }

    private static class GeneratedUnitWithFile
    extends GeneratedUnitImpl {
        private final File file;

        public GeneratedUnitWithFile(File file, StringWriter pw, String typeName) {
            super(pw, typeName);
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit(TreeLogger logger) {
            super.commit(logger);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.file);
                diskCache.transferToStream(this.sourceToken, fos);
            }
            catch (IOException e) {
                try {
                    logger.log(TreeLogger.WARN, "Error writing out generated unit at '" + this.file.getAbsolutePath() + "': " + e);
                }
                catch (Throwable throwable) {
                    Utility.close(fos);
                    throw throwable;
                }
                Utility.close(fos);
            }
            Utility.close(fos);
        }

        @Override
        public String optionalFileLocation() {
            return this.file.exists() ? Util.stripJarPathPrefix(this.file.getAbsolutePath()) : null;
        }
    }

    public static class GeneratedUnitImpl
    implements Generated {
        protected long sourceToken = -1L;
        private long creationTime;
        private String strongHash;
        private StringWriter sw;
        private final String typeName;

        public GeneratedUnitImpl(StringWriter sw, String typeName) {
            this.typeName = typeName;
            this.sw = sw;
        }

        @Override
        public void abort() {
            this.sw = null;
        }

        @Override
        public void commit(TreeLogger logger) {
            String source = this.sw.toString();
            this.strongHash = Util.computeStrongName(Util.getBytes(source));
            this.sourceToken = diskCache.writeString(source);
            this.sw = null;
            this.creationTime = System.currentTimeMillis();
        }

        @Override
        public long creationTime() {
            return this.creationTime;
        }

        @Override
        public String getSource() {
            if (this.sw != null) {
                throw new IllegalStateException("source not committed");
            }
            return diskCache.readString(this.sourceToken);
        }

        @Override
        public String getSourceMapPath() {
            return "gen/" + this.getTypeName().replace('.', '/') + ".java";
        }

        @Override
        public long getSourceToken() {
            if (this.sw != null) {
                throw new IllegalStateException("source not committed");
            }
            return this.sourceToken;
        }

        @Override
        public String getStrongHash() {
            return this.strongHash;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String optionalFileLocation() {
            return null;
        }
    }

    private static interface Generated
    extends GeneratedUnit {
        public void abort();

        public void commit(TreeLogger var1);
    }

    private class RecordingResourceOracle
    extends AbstractResourceOracle {
        private final ResourceOracle wrappedResourceOracle;

        public RecordingResourceOracle(ResourceOracle wrappedResourceOracle) {
            this.wrappedResourceOracle = wrappedResourceOracle;
        }

        @Override
        public void clear() {
            this.wrappedResourceOracle.clear();
        }

        @Override
        public Set<String> getPathNames() {
            return this.wrappedResourceOracle.getPathNames();
        }

        @Override
        public Resource getResource(String pathName) {
            pathName = Files.simplifyPath(pathName);
            StandardGeneratorContext.this.compilerContext.getMinimalRebuildCache().associateReboundTypeWithInputResource(StandardGeneratorContext.this.currentRebindBinaryTypeName, pathName);
            return this.wrappedResourceOracle.getResource(pathName);
        }

        @Override
        public Set<Resource> getResources() {
            return this.wrappedResourceOracle.getResources();
        }
    }
}

