/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import java.util.concurrent.TimeUnit;

class ProgressLogger {
    private static final long NANOSECONDS_IN_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final double ETR_ACCURACY_THRESHOLD = 0.05;
    private static final int LOG_BLACKOUT_PERIOD = 5;
    private static final long LOG_BLACKOUT_PERIOD_NANOS = 5L * NANOSECONDS_IN_SECOND;
    private final TreeLogger logger;
    private final TreeLogger.Type logLevel;
    private final int maxProgressUnits;
    private final int percentageIncrement;
    private final NanoSource nanoSource;
    private long startNanos = 0L;
    private boolean timerStarted = false;
    private long nextPercentage = 0L;

    ProgressLogger(TreeLogger logger, TreeLogger.Type logLevel, int maxProgressUnits, int percentageIncrement) {
        this.logger = logger;
        this.logLevel = logLevel;
        this.maxProgressUnits = maxProgressUnits;
        this.percentageIncrement = percentageIncrement;
        this.nanoSource = new NanoSource(){

            @Override
            public long getNanos() {
                return System.nanoTime();
            }
        };
    }

    boolean isTimerStarted() {
        return this.timerStarted;
    }

    void startTimer() {
        this.startNanos = this.nanoSource.getNanos();
        this.timerStarted = true;
    }

    void updateProgress(int progressUnits) {
        if (!this.logger.isLoggable(this.logLevel)) {
            return;
        }
        if (!this.timerStarted) {
            throw new IllegalStateException("#updateProgress() called before #startTimer().");
        }
        double progress = (double)progressUnits / (double)this.maxProgressUnits;
        double currentPercentage = 100.0 * progress;
        long elapsedNanos = this.nanoSource.getNanos() - this.startNanos;
        if (currentPercentage < (double)this.nextPercentage && progressUnits != this.maxProgressUnits) {
            return;
        }
        if (elapsedNanos < LOG_BLACKOUT_PERIOD_NANOS) {
            return;
        }
        long displayedPercentage = (long)this.percentageIncrement * Math.round(Math.floor(currentPercentage / (double)this.percentageIncrement));
        if (progressUnits == this.maxProgressUnits) {
            displayedPercentage = 100L;
        }
        if (progress >= 0.05) {
            double estimatedTotalNanos = (double)elapsedNanos / progress;
            double estimatedNanosRemaining = estimatedTotalNanos - (double)elapsedNanos;
            double estimatedSecondsRemaining = estimatedNanosRemaining / (double)NANOSECONDS_IN_SECOND;
            this.logger.log(this.logLevel, String.format("%d%% complete (ETR: %d seconds)", displayedPercentage, Math.round(estimatedSecondsRemaining)));
        } else {
            this.logger.log(this.logLevel, String.format("%d%% complete (ETR: ?)", displayedPercentage));
        }
        this.nextPercentage += (long)this.percentageIncrement;
    }

    static interface NanoSource {
        public long getNanos();
    }
}

