/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.PersistentUnitCache;
import com.google.gwt.dev.util.CompilerVersion;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.util.tools.Utility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PersistentUnitCacheDir {
    private static final String DIRECTORY_NAME = "gwt-unitCache";
    private static final String CACHE_FILE_PREFIX = "gwt-unitCache-";
    static final String CURRENT_VERSION_CACHE_FILE_PREFIX = "gwt-unitCache-" + CompilerVersion.getHash();
    private final TreeLogger logger;
    private final File dir;
    private final String filePrefix;
    private OpenFile openFile;

    PersistentUnitCacheDir(TreeLogger logger, File parentDir, String cacheFilePrefix) throws UnableToCompleteException {
        this.logger = logger;
        this.filePrefix = CURRENT_VERSION_CACHE_FILE_PREFIX + "-" + cacheFilePrefix + "-";
        try {
            parentDir = parentDir.getCanonicalFile();
        }
        catch (IOException e) {
            logger.log(TreeLogger.WARN, "Can't get canonical directory for " + parentDir.getAbsolutePath(), e);
            throw new UnableToCompleteException();
        }
        this.dir = PersistentUnitCacheDir.chooseCacheDir(parentDir);
        if (!this.dir.isDirectory() && !this.dir.mkdirs()) {
            logger.log(TreeLogger.WARN, "Can't create directory: " + this.dir.getAbsolutePath());
            throw new UnableToCompleteException();
        }
        if (!this.dir.canRead()) {
            logger.log(TreeLogger.Type.WARN, "Can't read directory: " + this.dir.getAbsolutePath());
            throw new UnableToCompleteException();
        }
        logger.log(TreeLogger.TRACE, "Persistent unit cache dir set to: " + this.dir.getAbsolutePath());
        this.openFile = new OpenFile(logger, PersistentUnitCacheDir.createEmptyCacheFile(logger, this.dir, this.filePrefix));
    }

    String getPath() {
        return this.dir.getAbsolutePath();
    }

    synchronized int getClosedCacheFileCount() {
        return this.selectClosedFiles(this.listFiles(this.filePrefix)).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void loadUnitMap(PersistentUnitCache destination) {
        SpeedTracerLogger.Event loadPersistentUnitEvent = SpeedTracerLogger.start(DevModeEventType.LOAD_PERSISTENT_UNIT_CACHE, new String[0]);
        if (this.logger.isLoggable(TreeLogger.TRACE)) {
            this.logger.log(TreeLogger.TRACE, "Looking for previously cached Compilation Units in " + this.getPath());
        }
        try {
            List<File> files = this.selectClosedFiles(this.listFiles(this.filePrefix));
            for (File cacheFile : files) {
                this.loadOrDeleteCacheFile(cacheFile, destination);
            }
        }
        finally {
            loadPersistentUnitEvent.end(new String[0]);
        }
    }

    synchronized void deleteClosedCacheFiles() {
        SpeedTracerLogger.Event deleteEvent = SpeedTracerLogger.start(DevModeEventType.DELETE_CACHE, new String[0]);
        this.logger.log(TreeLogger.TRACE, "Deleting cache files from " + this.dir);
        List<File> allVersionsList = this.listFiles(CACHE_FILE_PREFIX);
        int deleteCount = 0;
        for (File candidate : allVersionsList) {
            if (!this.deleteUnlessOpen(candidate)) continue;
            ++deleteCount;
        }
        this.logger.log(TreeLogger.TRACE, "Deleted " + deleteCount + " cache files from " + this.dir);
        deleteEvent.end(new String[0]);
    }

    synchronized void rotate() throws UnableToCompleteException {
        this.logger.log(TreeLogger.Type.TRACE, "Rotating persistent unit cache");
        if (this.openFile != null) {
            this.openFile.close(this.logger);
            this.openFile = null;
        }
        this.openFile = new OpenFile(this.logger, PersistentUnitCacheDir.createEmptyCacheFile(this.logger, this.dir, this.filePrefix));
    }

    synchronized boolean deleteUnlessOpen(File cacheFile) {
        if (this.isOpen(cacheFile)) {
            return false;
        }
        this.logger.log(TreeLogger.Type.TRACE, "Deleting file: " + cacheFile);
        boolean deleted = cacheFile.delete();
        if (!deleted) {
            this.logger.log(TreeLogger.Type.WARN, "Unable to delete file: " + cacheFile);
        }
        return deleted;
    }

    synchronized void writeUnit(CompilationUnit unit) throws UnableToCompleteException {
        if (this.openFile == null) {
            this.logger.log(TreeLogger.Type.TRACE, "Skipped writing compilation unit to cache because no file is open");
            return;
        }
        this.openFile.writeUnit(this.logger, unit);
    }

    synchronized void closeCurrentFile() {
        if (this.openFile != null) {
            this.openFile.close(this.logger);
            this.openFile = null;
        }
    }

    @VisibleForTesting
    static File chooseCacheDir(File parentDir) {
        return new File(parentDir, DIRECTORY_NAME);
    }

    private boolean isOpen(File f) {
        return this.openFile != null && this.openFile.file.equals(f);
    }

    /*
     * Exception decompiling
     */
    private void loadOrDeleteCacheFile(File cacheFile, PersistentUnitCache destination) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<File> listFiles(String prefix) {
        File[] files = this.dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> out = Lists.newArrayList();
        for (File file : files) {
            if (!file.getName().startsWith(prefix)) continue;
            out.add(file);
        }
        Collections.sort(out);
        return out;
    }

    private List<File> selectClosedFiles(Iterable<File> fileList) {
        ArrayList<File> closedFiles = Lists.newArrayList();
        for (File file : fileList) {
            if (this.isOpen(file)) continue;
            closedFiles.add(file);
        }
        return closedFiles;
    }

    private static File createEmptyCacheFile(TreeLogger logger, File dir, String filePrefix) throws UnableToCompleteException {
        File newFile = null;
        long timestamp = System.currentTimeMillis();
        try {
            while (!(newFile = new File(dir, filePrefix + String.format("%016X", timestamp++))).createNewFile()) {
            }
        }
        catch (IOException ex) {
            logger.log(TreeLogger.WARN, "Can't create new cache log file " + newFile.getAbsolutePath() + ".", ex);
            throw new UnableToCompleteException();
        }
        if (!newFile.canWrite()) {
            logger.log(TreeLogger.WARN, "Can't write to new cache log file " + newFile.getAbsolutePath() + ".");
            throw new UnableToCompleteException();
        }
        return newFile;
    }

    private static class OpenFile {
        private final File file;
        private final ObjectOutputStream stream;
        private int unitsWritten = 0;

        OpenFile(TreeLogger logger, File toOpen) throws UnableToCompleteException {
            logger.log(TreeLogger.Type.TRACE, "Opening cache file: " + toOpen);
            ObjectOutputStream newStream = OpenFile.openObjectStream(logger, toOpen);
            this.file = toOpen;
            this.stream = newStream;
            this.unitsWritten = 0;
        }

        boolean writeUnit(TreeLogger logger, CompilationUnit unit) throws UnableToCompleteException {
            try {
                this.stream.writeObject(unit);
                ++this.unitsWritten;
                return true;
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Error saving compilation unit to cache file: " + this.file, e);
                throw new UnableToCompleteException();
            }
        }

        void close(TreeLogger logger) {
            logger.log(TreeLogger.Type.TRACE, "Closing cache file: " + this.file + " (" + this.unitsWritten + " units written)");
            Utility.close(this.stream);
            if (this.unitsWritten == 0) {
                logger.log(TreeLogger.Type.TRACE, "Deleting empty file: " + this.file);
                boolean deleted = this.file.delete();
                if (!deleted) {
                    logger.log(TreeLogger.Type.INFO, "Couldn't delete persistent unit cache file: " + this.file);
                }
            }
        }

        private static ObjectOutputStream openObjectStream(TreeLogger logger, File file) throws UnableToCompleteException {
            FileOutputStream fstream = null;
            try {
                fstream = new FileOutputStream(file);
                return new ObjectOutputStream(new BufferedOutputStream(fstream));
            }
            catch (IOException e) {
                logger.log(TreeLogger.Type.ERROR, "Can't open persistent unit cache file", e);
                Utility.close(fstream);
                throw new UnableToCompleteException();
            }
        }
    }
}

