/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.javac.CachedCompilationUnit;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.ContentId;
import com.google.gwt.dev.javac.MemoryUnitCache;
import com.google.gwt.dev.javac.PersistentUnitCacheDir;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

class PersistentUnitCache
extends MemoryUnitCache {
    static final int CACHE_FILE_THRESHOLD = 40;
    private final BackgroundService backgroundService;
    private Semaphore cleanupInProgress = new Semaphore(1);
    private AtomicInteger newUnitsSinceLastCleanup = new AtomicInteger();
    private final String relevantOptionsHash;

    PersistentUnitCache(TreeLogger logger, File parentDir, String relevantOptionsHash) throws UnableToCompleteException {
        this.relevantOptionsHash = relevantOptionsHash;
        this.backgroundService = new BackgroundService(logger, parentDir, this);
    }

    @Override
    public void add(CompilationUnit newUnit) {
        this.internalAdd(newUnit);
    }

    @VisibleForTesting
    Future<?> internalAdd(CompilationUnit newUnit) {
        Preconditions.checkNotNull(newUnit);
        this.backgroundService.waitForCacheToLoad();
        this.addNewUnit(newUnit);
        return this.backgroundService.asyncWriteUnit(newUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnableToCompleteException {
        this.backgroundService.asyncClearCache();
        this.backgroundService.finishAndShutdown();
        PersistentUnitCache persistentUnitCache = this;
        synchronized (persistentUnitCache) {
            super.clear();
        }
        this.backgroundService.start();
    }

    @Override
    public void cleanup(TreeLogger logger) {
        logger.log(TreeLogger.Type.TRACE, "PersistentUnitCache cleanup requested");
        this.backgroundService.waitForCacheToLoad();
        if (this.backgroundService.isShutdown()) {
            logger.log(TreeLogger.TRACE, "Skipped PersistentUnitCache cleanup because it's shut down");
            return;
        }
        if (!this.cleanupInProgress.tryAcquire()) {
            return;
        }
        int addCallCount = this.newUnitsSinceLastCleanup.getAndSet(0);
        logger.log(TreeLogger.TRACE, "Added " + addCallCount + " units to PersistentUnitCache since last cleanup");
        if (addCallCount == 0) {
            logger.log(TreeLogger.TRACE, "Skipped PersistentUnitCache because no units were added");
            this.cleanupInProgress.release();
            return;
        }
        int closedCount = this.backgroundService.getClosedCacheFileCount();
        if (closedCount < 40) {
            logger.log(TreeLogger.TRACE, "Rotating PersistentUnitCache file because only " + closedCount + " files were added.");
            this.backgroundService.asyncRotate(this.cleanupInProgress);
            return;
        }
        logger.log(TreeLogger.Type.TRACE, "Compacting persistent unit cache files");
        this.backgroundService.asyncCompact(this.getUnitsToSaveToDisk(), this.cleanupInProgress);
    }

    @VisibleForTesting
    void waitForCleanup() throws InterruptedException {
        this.cleanupInProgress.acquire();
        this.cleanupInProgress.release();
    }

    @VisibleForTesting
    void shutdown() throws InterruptedException, ExecutionException {
        this.backgroundService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit find(ContentId contentId) {
        this.backgroundService.waitForCacheToLoad();
        PersistentUnitCache persistentUnitCache = this;
        synchronized (persistentUnitCache) {
            return super.find(contentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit find(String resourcePath) {
        this.backgroundService.waitForCacheToLoad();
        PersistentUnitCache persistentUnitCache = this;
        synchronized (persistentUnitCache) {
            return super.find(resourcePath);
        }
    }

    @Override
    public synchronized void remove(CompilationUnit unit) {
        super.remove(unit);
    }

    private synchronized void addNewUnit(CompilationUnit unit) {
        this.newUnitsSinceLastCleanup.incrementAndGet();
        super.add(unit);
    }

    synchronized void maybeAddLoadedUnit(CachedCompilationUnit unit) {
        MemoryUnitCache.UnitCacheEntry entry = new MemoryUnitCache.UnitCacheEntry(unit, MemoryUnitCache.UnitOrigin.PERSISTENT);
        MemoryUnitCache.UnitCacheEntry existingEntry = (MemoryUnitCache.UnitCacheEntry)this.unitMap.get(unit.getResourcePath());
        if (existingEntry != null && unit.getLastModified() >= existingEntry.getUnit().getLastModified()) {
            super.remove(existingEntry.getUnit());
            this.unitMap.put(unit.getResourcePath(), entry);
            this.unitMapByContentId.put(unit.getContentId(), entry);
        } else if (existingEntry == null) {
            this.unitMap.put(unit.getResourcePath(), entry);
            this.unitMapByContentId.put(unit.getContentId(), entry);
        }
    }

    private synchronized List<CompilationUnit> getUnitsToSaveToDisk() {
        ArrayList<CompilationUnit> result = Lists.newArrayList();
        for (MemoryUnitCache.UnitCacheEntry entry : this.unitMap.values()) {
            result.add(Preconditions.checkNotNull(entry.getUnit()));
        }
        return result;
    }

    private static class BackgroundService {
        private final TreeLogger logger;
        private final PersistentUnitCacheDir cacheDir;
        private ExecutorService service;
        private PersistentUnitCache cacheToLoad;
        private Future<?> loadingDone;

        BackgroundService(TreeLogger logger, File parentDir, PersistentUnitCache cacheToLoad) throws UnableToCompleteException {
            this.logger = logger;
            this.cacheDir = new PersistentUnitCacheDir(logger, parentDir, cacheToLoad.relevantOptionsHash);
            this.cacheToLoad = cacheToLoad;
            this.start();
        }

        public void finishAndShutdown() throws UnableToCompleteException {
            this.service.shutdown();
            try {
                if (!this.service.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.logger.log(TreeLogger.WARN, "Persistent Unit Cache shutdown tasks took longer than 30 seconds to complete.");
                    throw new UnableToCompleteException();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void start() {
            assert (this.service == null || this.service.isTerminated());
            this.service = Executors.newSingleThreadExecutor();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Future<?> status = this.asyncShutdown();
                        status.get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException status) {
                    }
                    catch (RejectedExecutionException status) {
                    }
                    catch (ExecutionException e) {
                        logger.log(TreeLogger.ERROR, "Error during shutdown", e);
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    finally {
                        this.shutdownNow();
                    }
                }
            });
            this.loadingDone = this.service.submit(new Runnable(){

                @Override
                public void run() {
                    cacheDir.loadUnitMap(cacheToLoad);
                }
            });
        }

        synchronized void waitForCacheToLoad() {
            if (this.loadingDone == null) {
                return;
            }
            try {
                this.loadingDone.get();
                this.loadingDone = null;
            }
            catch (InterruptedException e) {
                throw new InternalCompilerException("Interrupted waiting for PersistentUnitCache to load.", e);
            }
            catch (ExecutionException e) {
                this.logger.log(TreeLogger.ERROR, "Failed to load PersistentUnitCache.", e);
                this.loadingDone = null;
            }
        }

        boolean isShutdown() {
            return this.service.isShutdown();
        }

        @VisibleForTesting
        void shutdown() throws InterruptedException, ExecutionException {
            this.logger.log(TreeLogger.Type.INFO, "PersistentUnitCache shutdown requested");
            try {
                this.asyncShutdown().get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        int getClosedCacheFileCount() {
            return this.cacheDir.getClosedCacheFileCount();
        }

        Future<?> asyncRotate(final Semaphore cleanupInProgress) {
            return this.service.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        cacheDir.rotate();
                    }
                    catch (UnableToCompleteException e) {
                        this.shutdownNow();
                    }
                    finally {
                        cleanupInProgress.release();
                    }
                }
            });
        }

        Future<?> asyncCompact(final List<CompilationUnit> unitsToSave, final Semaphore cleanupInProgress) {
            return this.service.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (CompilationUnit unit : unitsToSave) {
                            cacheDir.writeUnit(unit);
                        }
                        cacheDir.deleteClosedCacheFiles();
                        cacheDir.rotate();
                    }
                    catch (UnableToCompleteException e) {
                        this.shutdownNow();
                    }
                    finally {
                        cleanupInProgress.release();
                    }
                }
            });
        }

        Future<?> asyncClearCache() {
            Future<?> status = this.service.submit(new Runnable(){

                @Override
                public void run() {
                    cacheDir.closeCurrentFile();
                    cacheDir.deleteClosedCacheFiles();
                }
            });
            this.service.shutdown();
            return status;
        }

        Future<?> asyncWriteUnit(final CompilationUnit unit) {
            try {
                return this.service.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cacheDir.writeUnit(unit);
                        }
                        catch (UnableToCompleteException e) {
                            this.shutdownNow();
                        }
                    }
                });
            }
            catch (RejectedExecutionException ex) {
                return null;
            }
        }

        Future<?> asyncShutdown() {
            Future<?> status = this.service.submit(new Runnable(){

                @Override
                public void run() {
                    cacheDir.closeCurrentFile();
                    this.shutdownNow();
                }
            });
            this.service.shutdown();
            return status;
        }

        private void shutdownNow() {
            this.logger.log(TreeLogger.TRACE, "Shutting down PersistentUnitCache thread");
            this.service.shutdownNow();
        }
    }
}

