/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.jdt.SafeASTVisitor;
import com.google.gwt.dev.util.Name;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public abstract class MethodVisitor {
    protected static String getMemberSignature(AbstractMethodDeclaration method) {
        String name = String.valueOf(method.selector);
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        if (method.arguments != null) {
            for (Argument param : method.arguments) {
                sb.append(param.binding.type.signature());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public void collect(CompilationUnitDeclaration cud, String sourceMapPath) {
        cud.traverse((ASTVisitor)new SafeASTVisitor(){

            @Override
            public void endVisit(TypeDeclaration type, ClassScope scope) {
                MethodVisitor.this.collectMethods(type);
            }

            @Override
            public void endVisit(TypeDeclaration type, CompilationUnitScope scope) {
                MethodVisitor.this.collectMethods(type);
            }

            @Override
            public void endVisitValid(TypeDeclaration type, BlockScope scope) {
                MethodVisitor.this.collectMethods(type);
            }
        }, cud.scope);
    }

    protected abstract boolean interestingMethod(AbstractMethodDeclaration var1);

    protected abstract void processMethod(TypeDeclaration var1, AbstractMethodDeclaration var2, String var3);

    private void collectMethods(TypeDeclaration typeDecl) {
        AbstractMethodDeclaration[] methods = typeDecl.methods;
        if (methods == null) {
            return;
        }
        String enclosingType = null;
        boolean lazyInitialized = false;
        for (AbstractMethodDeclaration method : methods) {
            if (!this.interestingMethod(method)) continue;
            if (!lazyInitialized) {
                enclosingType = Name.InternalName.toBinaryName(String.valueOf(typeDecl.binding.constantPoolName()));
                lazyInitialized = true;
            }
            this.processMethod(typeDecl, method, enclosingType);
        }
    }
}

