/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.dev.javac.MethodArgNamesLookup;
import com.google.gwt.dev.javac.MethodVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

public class MethodParamCollector {
    public static MethodArgNamesLookup collect(CompilationUnitDeclaration cud, String sourceMapPath) {
        MethodArgNamesLookup methodArgs = new MethodArgNamesLookup();
        new Visitor(methodArgs).collect(cud, sourceMapPath);
        methodArgs.freeze();
        return methodArgs;
    }

    private static class Visitor
    extends MethodVisitor {
        private final MethodArgNamesLookup methodArgs;

        public Visitor(MethodArgNamesLookup methodArgs) {
            this.methodArgs = methodArgs;
        }

        @Override
        protected boolean interestingMethod(AbstractMethodDeclaration method) {
            if (method.arguments == null || method.arguments.length == 0) {
                return false;
            }
            MethodBinding binding = method.binding;
            return binding != null && !binding.declaringClass.isLocalType();
        }

        @Override
        protected void processMethod(TypeDeclaration typeDecl, AbstractMethodDeclaration method, String enclosingType) {
            this.methodArgs.store(enclosingType, method);
        }
    }
}

