/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.dev.javac.asm.CollectMethodData;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;

public class MethodArgNamesLookup
implements Serializable {
    private Map<String, String[]> methodArgs = new HashMap<String, String[]>();

    public void freeze() {
        this.methodArgs = Maps.normalizeUnmodifiable(this.methodArgs);
    }

    public String[] lookup(JAbstractMethod method, CollectMethodData methodData) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getEnclosingType().getQualifiedBinaryName());
        buf.append('.').append(method.getName());
        buf.append(methodData.getDesc());
        String key = buf.toString();
        return this.methodArgs.get(key);
    }

    public void mergeFrom(MethodArgNamesLookup other) {
        this.methodArgs.putAll(other.methodArgs);
    }

    public void store(String enclosingType, AbstractMethodDeclaration method) {
        if (method.binding == null) {
            return;
        }
        int n = method.arguments.length;
        String[] argNames = new String[n];
        for (int i = 0; i < n; ++i) {
            argNames[i] = StringInterner.get().intern(String.valueOf(method.arguments[i].name));
        }
        StringBuilder buf = new StringBuilder();
        buf.append(enclosingType).append('.').append(method.selector);
        buf.append(method.binding.signature());
        String key = StringInterner.get().intern(buf.toString());
        this.methodArgs.put(key, argNames);
    }

    String[] getMethods() {
        return this.methodArgs.keySet().toArray(new String[0]);
    }

    String[] lookup(String methodName) {
        return this.methodArgs.get(methodName);
    }
}

