/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.ContentId;
import com.google.gwt.dev.javac.UnitCache;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Map;

public class MemoryUnitCache
implements UnitCache {
    protected final Map<String, UnitCacheEntry> unitMap = Maps.newHashMap();
    protected final Map<ContentId, UnitCacheEntry> unitMapByContentId = Maps.newHashMap();

    @Override
    public void add(CompilationUnit newUnit) {
        UnitCacheEntry newEntry = new UnitCacheEntry(newUnit, UnitOrigin.RUN_TIME);
        String resourcePath = newUnit.getResourcePath();
        UnitCacheEntry oldEntry = this.unitMap.get(resourcePath);
        if (oldEntry != null) {
            this.remove(oldEntry.getUnit());
        }
        this.unitMap.put(resourcePath, newEntry);
        this.unitMapByContentId.put(newUnit.getContentId(), newEntry);
    }

    @Override
    public synchronized void cleanup(TreeLogger logger) {
    }

    @Override
    public void clear() throws UnableToCompleteException {
        this.unitMap.clear();
        this.unitMapByContentId.clear();
    }

    @Override
    public CompilationUnit find(ContentId contentId) {
        UnitCacheEntry entry = this.unitMapByContentId.get(contentId);
        if (entry != null) {
            return entry.getUnit();
        }
        return null;
    }

    @Override
    public CompilationUnit find(String resourcePath) {
        UnitCacheEntry entry = this.unitMap.get(resourcePath);
        if (entry != null) {
            return entry.getUnit();
        }
        return null;
    }

    @Override
    public void remove(CompilationUnit unit) {
        this.unitMap.remove(unit.getResourcePath());
        this.unitMapByContentId.remove(unit.getContentId());
    }

    protected static enum UnitOrigin {
        PERSISTENT,
        RUN_TIME;

    }

    protected static class UnitCacheEntry {
        private final UnitOrigin origin;
        private final CompilationUnit unit;

        protected UnitCacheEntry(CompilationUnit unit, UnitOrigin source) {
            this.unit = unit;
            this.origin = source;
        }

        public UnitOrigin getOrigin() {
            return this.origin;
        }

        public CompilationUnit getUnit() {
            return this.unit;
        }
    }
}

