/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.client.UnsafeNativeLong;
import com.google.gwt.dev.javac.GWTProblem;
import com.google.gwt.dev.javac.JdtUtil;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.JsniMethodCollector;
import com.google.gwt.dev.jdt.SafeASTVisitor;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.util.InstalledHelpInfo;
import com.google.gwt.dev.util.JsniRef;
import com.google.gwt.dev.util.collect.Stack;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class JsniReferenceResolver {
    private static final char[] INIT_CTOR_CHARS = "<init>".toCharArray();
    private static final char[][] UNSAFE_LONG_ANNOTATION_CHARS = CharOperation.splitOn('.', UnsafeNativeLong.class.getName().toCharArray());
    private final CompilationUnitDeclaration cud;
    private final List<ImportReference> cudImports;
    private final Map<MethodDeclaration, JsniMethod> jsniMethods;
    private final Map<String, Binding> jsniRefs;
    private final Stack<Set<String>> suppressWarningsStack = new Stack();
    private final TypeResolver typeResolver;

    public static void resolve(CompilationUnitDeclaration cud, List<ImportReference> cudOriginalImports, Map<MethodDeclaration, JsniMethod> jsniMethods, Map<String, Binding> jsniRefs, TypeResolver typeResolver) {
        new JsniReferenceResolver(cud, cudOriginalImports, typeResolver, jsniMethods, jsniRefs).resolve();
    }

    private JsniReferenceResolver(CompilationUnitDeclaration cud, List<ImportReference> cudImports, TypeResolver typeResolver, Map<MethodDeclaration, JsniMethod> jsniMethods, Map<String, Binding> jsniRefs) {
        this.cud = cud;
        this.cudImports = cudImports;
        this.typeResolver = typeResolver;
        this.jsniMethods = jsniMethods;
        this.jsniRefs = jsniRefs;
    }

    private void resolve() {
        this.cud.traverse((ASTVisitor)new JsniDeclChecker(), this.cud.scope);
    }

    private boolean containsLong(TypeBinding type) {
        if (!(type instanceof BaseTypeBinding)) {
            return false;
        }
        BaseTypeBinding btb = (BaseTypeBinding)type;
        return btb.id == 7;
    }

    private boolean hasUnsafeLongsAnnotation(MethodDeclaration meth, ClassScope scope) {
        if (meth.annotations == null) {
            return false;
        }
        for (Annotation annot : meth.annotations) {
            if (!this.isUnsafeLongAnnotation(annot, scope)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnsafeLongAnnotation(Annotation annot, ClassScope scope) {
        if (annot.type == null) {
            return false;
        }
        TypeBinding resolved = annot.type.resolveType(scope);
        if (resolved == null || !(resolved instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding rb = (ReferenceBinding)resolved;
        return CharOperation.equals(rb.compoundName, UNSAFE_LONG_ANNOTATION_CHARS);
    }

    private void longAccessError(ASTNode node, String message) {
        GWTProblem.recordError(node, this.cud, message, new InstalledHelpInfo("longJsniRestriction.html"));
    }

    private static void resolveJsniRef(JsniRef jsniRef, FieldBinding fieldBinding) {
        if (fieldBinding == null) {
            return;
        }
        jsniRef.setResolvedClassName(JdtUtil.getSourceName(fieldBinding.declaringClass));
        jsniRef.setResolvedMemberWithSignature(new String(fieldBinding.name));
    }

    private static void resolveJsniRef(JsniRef jsniRef, MethodBinding methodBinding) {
        if (methodBinding == null) {
            return;
        }
        ReferenceBinding declaringClassBinding = methodBinding.declaringClass;
        jsniRef.setResolvedClassName(JdtUtil.getSourceName(declaringClassBinding));
        jsniRef.setResolvedMemberWithSignature(JdtUtil.formatMethodSignature(methodBinding));
    }

    private class JsniReferenceResolverVisitor
    extends JsModVisitor {
        private final boolean hasUnsafeLongsAnnotation;
        private final MethodDeclaration method;
        private static final String WARN_NOT_CAPTURING_QUALIFIER = "Instance method reference '%2$s.%3$s' loses its instance ('%8$s') when assigned; to remove this warning either assign to a local variable or construct the proper closure using an anonymous function or by calling Function.prototype.bind";
        private static final String ERR_ILLEGAL_ARRAY_OR_PRIMITIVE_REFERENCE = "Referencing member '%2$s.%4$s': 'class' is the only legal reference for arrays and primitive types";
        private static final String ERR_ILLEGAL_ASSIGNMENT_TO_CLASS_LITERAL = "Illegal assignment to class literal '%2$s.%3$s'";
        private static final String ERR_UNABLE_TO_RESOLVE_CLASS = "Referencing class '%2$s': unable to resolve class";
        private static final String ERR_ILLEGAL_ANONYMOUS_INNER_CLASS = "Referencing class '%2$s': JSNI references to anonymous classes are illegal";
        private static final String ERR_ILLEGAL_PARAMETER = "Parameter %8$d of method '%2$s.%3$s': type '%9$s' may not be passed out of JSNI code";
        private static final String ERR_ILLEGAL_RETURN_TYPE = "Referencing method '%2$s.%3$s': return type '%8$s' is not safe to access in JSNI code";
        private static final String ERR_MISSING_QUALIFIER_INSTANCE_METHOD = "Missing qualifier on instance method '%2$s.%3$s'";
        private static final String ERR_UNNECESSARY_QUALIFIER_STATIC_METHOD = "Unnecessary qualifier on static method '%2$s.%3$s'";
        private static final String ERR_MISSING_QUALIFIER_INSTANCE_FIELD = "Missing qualifier on instance field '%2$s.%3$s'";
        private static final String ERR_UNNECESSARY_QUALIFIER_STATIC_FIELD = "Unnecessary qualifier on static field '%2$s.%3$s'";
        private static final String ERR_ILLEGAL_ASSIGNMENT_TO_METHOD = "Illegal assignment to method '%2$s.%3$s'";
        private static final String ERR_UNABLE_TO_RESOLVE_METHOD = "Referencing method '%2$s.%4$s': unable to resolve method in class '%6$s'";
        private static final String ERR_UNABLE_TO_RESOLVE_FIELD = "Referencing field '%2$s.%4$s': unable to resolve field in class '%6$s'";
        private static final String ERR_AMBIGUOUS_WILDCARD_MATCH = "Referencing method '%2$s.%4$s': ambiguous wildcard match; both '%8$s' and '%9$s' match";
        private static final String ERR_UNSAFE_FIELD_ACCESS = "Referencing field '%2$s.%3$s': type '%8$s' is not safe to access in JSNI code";
        private static final String ERR_ILLEGAL_ASSIGNMENT_TO_COMPILE_TIME_CONSTANT = "Illegal assignment to compile-time constant '%2$s.%3$s'";
        private static final String ERR_MALFORMED_JSNI_IDENTIFIER = "Malformed JSNI identifier '%8$s'";
        private static final String WARN_DEPRECATED_CLASS = "Referencing deprecated class '%2$s'";
        private static final String WARN_DEPRECATED_METHOD = "Referencing method '%2$s.%3$s': method '%6$s.%7$s' is deprecated";
        private static final String WARN_DEPRECATED_FIELD = "Referencing field '%2$s.%3$s': field '%6$s.%7$s' is deprecated";

        public JsniReferenceResolverVisitor(MethodDeclaration method, boolean hasUnsafeLongsAnnotation) {
            this.method = method;
            this.hasUnsafeLongsAnnotation = hasUnsafeLongsAnnotation;
        }

        public void resolve(JsFunction function) {
            this.accept(function);
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            if (!x.getOperator().isAssignment()) {
                return;
            }
            if (!(x.getArg1() instanceof JsNameRef) || !(x.getArg2() instanceof JsNameRef)) {
                return;
            }
            JsNameRef lhs = (JsNameRef)x.getArg1();
            JsNameRef rhs = (JsNameRef)x.getArg2();
            if (!rhs.isJsniReference() || !(JsniReferenceResolver.this.jsniRefs.get(rhs.getIdent()) instanceof MethodBinding)) {
                return;
            }
            if (rhs.getQualifier() == null) {
                return;
            }
            if (lhs.getQualifier() == null) {
                return;
            }
            JsniRef jsniRef = JsniRef.parse(rhs.getIdent());
            this.emitWarning("unsafe", WARN_NOT_CAPTURING_QUALIFIER, x.getSourceInfo(), jsniRef, rhs.getQualifier().toSource());
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            String ident = x.getIdent();
            if (!x.isJsniReference()) {
                return;
            }
            JsniRef jsniRef = JsniRef.parse(ident);
            if (jsniRef == null) {
                this.emitError(ERR_MALFORMED_JSNI_IDENTIFIER, x.getSourceInfo(), null, ident);
                return;
            }
            Binding binding = this.resolveReference(x.getSourceInfo(), jsniRef, x.getQualifier() != null, ctx.isLvalue());
            assert (!x.isResolved());
            if (!ident.equals(jsniRef.getResolvedReference())) {
                ident = jsniRef.getResolvedReference();
                JsNameRef newRef = new JsNameRef(x.getSourceInfo(), ident, x.getQualifier());
                ctx.replaceMe(newRef);
            }
            if (binding != null) {
                JsniReferenceResolver.this.jsniRefs.put(ident, binding);
            }
        }

        private void resolveClassReference(JsniRef jsniRef) {
            String originalName = jsniRef.className();
            String importedClassName = originalName;
            if (importedClassName.contains(".")) {
                importedClassName = importedClassName.substring(0, importedClassName.indexOf("."));
            }
            for (ReferenceBinding declaringClass = this.method.binding.declaringClass; declaringClass != null; declaringClass = declaringClass.enclosingTypeAt(1)) {
                String declaringClassName = JdtUtil.getSourceName(declaringClass);
                if (declaringClassName.equals(importedClassName) || declaringClassName.endsWith("." + importedClassName)) {
                    jsniRef.setResolvedClassName((String)declaringClassName + originalName.substring(importedClassName.length()));
                    return;
                }
                String fullClassName = JdtUtil.getBinaryName(declaringClass) + "$" + originalName.replace('.', '$');
                if (JsniReferenceResolver.this.typeResolver.resolveType(fullClassName) == null) continue;
                jsniRef.setResolvedClassName(JdtUtil.getSourceName(declaringClass) + "." + originalName);
                return;
            }
            for (ImportReference importReference : JsniReferenceResolver.this.cudImports) {
                String nameFromImport = JdtUtil.asDottedString(importReference.getImportName());
                if (importReference.isStatic() || importReference.trailingStarPosition != 0 || !nameFromImport.endsWith("." + importedClassName)) continue;
                jsniRef.setResolvedClassName(nameFromImport + originalName.substring(importedClassName.length()));
                return;
            }
            String currentPackageBinaryClassName = JdtUtil.getBinaryName(CharOperation.charToString(this.method.binding.declaringClass.qualifiedPackageName()), originalName);
            if (JsniReferenceResolver.this.typeResolver.resolveType(currentPackageBinaryClassName) != null) {
                jsniRef.setResolvedClassName(JdtUtil.getSourceName(CharOperation.charToString(this.method.binding.declaringClass.qualifiedPackageName()), originalName));
                return;
            }
            ArrayList<String> importPackages = Lists.newArrayList("java.lang");
            for (ImportReference importReference : JsniReferenceResolver.this.cudImports) {
                if (importReference.isStatic() || importReference.trailingStarPosition == 0) continue;
                importPackages.add(JdtUtil.asDottedString(importReference.getImportName()));
            }
            for (String importPackage : importPackages) {
                String fullClassName = importPackage + "." + originalName.replace('.', '$');
                if (JsniReferenceResolver.this.typeResolver.resolveType(fullClassName) == null) continue;
                jsniRef.setResolvedClassName(importPackage + "." + originalName);
                return;
            }
            jsniRef.setResolvedClassName(jsniRef.className());
        }

        private boolean isEnclosingClass(TypeBinding clazz, TypeBinding maybeEnclosingClass) {
            for (TypeBinding currentClass = clazz; currentClass != null; currentClass = currentClass.enclosingType()) {
                if (currentClass != maybeEnclosingClass) continue;
                return true;
            }
            return false;
        }

        private FieldBinding checkAndResolveFieldRef(SourceInfo errorInfo, ReferenceBinding clazz, JsniRef jsniRef, boolean hasQualifier, boolean isLvalue) {
            assert (jsniRef.isField());
            FieldBinding target = this.getField(clazz, jsniRef);
            if (target == null) {
                this.emitError(ERR_UNABLE_TO_RESOLVE_FIELD, errorInfo, jsniRef, new Object[0]);
                return null;
            }
            JsniReferenceResolver.resolveJsniRef(jsniRef, target);
            if (target.isDeprecated() && !this.isEnclosingClass(this.method.binding.declaringClass, target.declaringClass)) {
                this.emitWarning("deprecation", WARN_DEPRECATED_FIELD, errorInfo, jsniRef, new Object[0]);
            }
            if (isLvalue && target.constant() != Constant.NotAConstant) {
                this.emitError(ERR_ILLEGAL_ASSIGNMENT_TO_COMPILE_TIME_CONSTANT, errorInfo, jsniRef, new Object[0]);
            }
            if (target.isStatic() && hasQualifier) {
                this.emitError(ERR_UNNECESSARY_QUALIFIER_STATIC_FIELD, errorInfo, jsniRef, new Object[0]);
            } else if (!target.isStatic() && !hasQualifier) {
                this.emitError(ERR_MISSING_QUALIFIER_INSTANCE_FIELD, errorInfo, jsniRef, new Object[0]);
            }
            if (this.hasUnsafeLongsAnnotation) {
                return target;
            }
            if (JsniReferenceResolver.this.containsLong(target.type)) {
                this.emitError(ERR_UNSAFE_FIELD_ACCESS, errorInfo, jsniRef, this.typeString(target.type));
            }
            return target;
        }

        private MethodBinding checkAndResolveMethodRef(SourceInfo errorInfo, ReferenceBinding clazz, JsniRef jsniRef, boolean hasQualifier, boolean isLvalue) {
            boolean needsQualifer;
            assert (jsniRef.isMethod());
            List<MethodBinding> targets = this.getMatchingMethods(clazz, jsniRef);
            if (targets.size() > 1) {
                this.emitError(ERR_AMBIGUOUS_WILDCARD_MATCH, errorInfo, jsniRef, JdtUtil.formatBinding(targets.get(0)), JdtUtil.formatBinding(targets.get(1)));
                return null;
            }
            if (targets.isEmpty()) {
                this.emitError(ERR_UNABLE_TO_RESOLVE_METHOD, errorInfo, jsniRef, new Object[0]);
                return null;
            }
            MethodBinding target = targets.get(0);
            JsniReferenceResolver.resolveJsniRef(jsniRef, target);
            if (target.isDeprecated() && !this.isEnclosingClass(this.method.binding.declaringClass, target.declaringClass)) {
                this.emitWarning("deprecation", WARN_DEPRECATED_METHOD, errorInfo, jsniRef, new Object[0]);
            }
            if (isLvalue) {
                this.emitError(ERR_ILLEGAL_ASSIGNMENT_TO_METHOD, errorInfo, jsniRef, new Object[0]);
            }
            boolean bl = needsQualifer = !target.isStatic() && !target.isConstructor();
            if (!needsQualifer && hasQualifier) {
                this.emitError(ERR_UNNECESSARY_QUALIFIER_STATIC_METHOD, errorInfo, jsniRef, new Object[0]);
            } else if (needsQualifer && !hasQualifier) {
                this.emitError(ERR_MISSING_QUALIFIER_INSTANCE_METHOD, errorInfo, jsniRef, new Object[0]);
            }
            if (this.hasUnsafeLongsAnnotation) {
                return target;
            }
            if (JsniReferenceResolver.this.containsLong(target.returnType)) {
                this.emitError(ERR_ILLEGAL_RETURN_TYPE, errorInfo, jsniRef, this.typeString(target.returnType));
            }
            if (target.parameters != null) {
                int i = 0;
                for (TypeBinding paramType : target.parameters) {
                    ++i;
                    if (!JsniReferenceResolver.this.containsLong(paramType)) continue;
                    this.emitError(ERR_ILLEGAL_PARAMETER, errorInfo, jsniRef, i, this.typeString(paramType));
                }
            }
            return target;
        }

        private Binding resolveReference(SourceInfo errorInfo, JsniRef jsniRef, boolean hasQualifier, boolean isLvalue) {
            ReferenceBinding clazz;
            boolean isPrimitive;
            this.resolveClassReference(jsniRef);
            String className = jsniRef.getResolvedClassName();
            MethodScope cfr_ignored_0 = this.method.scope;
            TypeBinding binding = MethodScope.getBaseType(className.toCharArray());
            if (binding != null) {
                isPrimitive = true;
                clazz = null;
            } else {
                isPrimitive = false;
                clazz = this.findClass(className);
                binding = clazz;
            }
            if (binding != null && binding.isAnonymousType()) {
                this.emitError(ERR_ILLEGAL_ANONYMOUS_INNER_CLASS, errorInfo, jsniRef, new Object[0]);
                return null;
            }
            if (binding == null) {
                this.emitError(ERR_UNABLE_TO_RESOLVE_CLASS, errorInfo, jsniRef, new Object[0]);
                return null;
            }
            if (clazz != null && clazz.isDeprecated() && !this.isEnclosingClass(this.method.binding.declaringClass, clazz)) {
                this.emitWarning("deprecation", WARN_DEPRECATED_CLASS, errorInfo, jsniRef, new Object[0]);
            }
            if (jsniRef.isField() && "class".equals(jsniRef.memberName())) {
                if (isLvalue) {
                    this.emitError(ERR_ILLEGAL_ASSIGNMENT_TO_CLASS_LITERAL, errorInfo, jsniRef, new Object[0]);
                    return null;
                }
                jsniRef.setResolvedClassName(JdtUtil.getSourceName(binding));
                jsniRef.setResolvedMemberWithSignature(jsniRef.memberSignature());
                if (jsniRef.isArray()) {
                    ArrayBinding arrayBinding = this.method.scope.createArrayType(binding, jsniRef.getDimensions());
                    return arrayBinding;
                }
                return binding;
            }
            if (jsniRef.isArray() || isPrimitive) {
                this.emitError(ERR_ILLEGAL_ARRAY_OR_PRIMITIVE_REFERENCE, errorInfo, jsniRef, new Object[0]);
                return null;
            }
            assert (clazz != null);
            if (jsniRef.isMethod()) {
                return this.checkAndResolveMethodRef(errorInfo, clazz, jsniRef, hasQualifier, isLvalue);
            }
            return this.checkAndResolveFieldRef(errorInfo, clazz, jsniRef, hasQualifier, isLvalue);
        }

        private String formatMessage(String msg, JsniRef jsniRef, Object ... extraPars) {
            Object[] formatParameters = new Object[extraPars.length + 7];
            if (jsniRef != null) {
                formatParameters[0] = jsniRef.toString();
                formatParameters[1] = jsniRef.fullClassName();
                formatParameters[2] = jsniRef.memberName();
                formatParameters[3] = jsniRef.memberSignature();
                formatParameters[4] = jsniRef.getResolvedReference();
                formatParameters[5] = jsniRef.getFullResolvedClassName();
                formatParameters[6] = jsniRef.getResolvedMemberSignature();
            }
            for (int i = 0; i < extraPars.length; ++i) {
                formatParameters[i + 7] = extraPars[i];
            }
            return String.format(msg, formatParameters);
        }

        private void emitError(String msg, SourceInfo errorInfo, JsniRef jsniRef, Object ... extraPars) {
            JsniMethodCollector.reportJsniError(errorInfo, this.method, this.formatMessage(msg, jsniRef, extraPars));
        }

        private void emitWarning(String category, String msg, SourceInfo errorInfo, JsniRef jsniRef, Object ... extraPars) {
            for (Set suppressWarnings : JsniReferenceResolver.this.suppressWarningsStack) {
                if (!suppressWarnings.contains(category) && !suppressWarnings.contains("all")) continue;
                return;
            }
            JsniMethodCollector.reportJsniWarning(errorInfo, this.method, this.formatMessage(msg, jsniRef, extraPars));
        }

        private ReferenceBinding findClass(String className) {
            ReferenceBinding binding = JsniReferenceResolver.this.typeResolver.resolveType(className);
            assert (!(binding instanceof ProblemReferenceBinding));
            assert (!(binding instanceof UnresolvedReferenceBinding));
            return binding;
        }

        private FieldBinding getField(ReferenceBinding clazz, JsniRef jsniRef) {
            assert (jsniRef.isField());
            return clazz.getField(jsniRef.memberName().toCharArray(), false);
        }

        private MethodBinding getMatchingConstructor(ReferenceBinding clazz, JsniRef jsniRef) {
            for (MethodBinding constructorBinding : clazz.getMethods(INIT_CTOR_CHARS)) {
                StringBuilder methodSig = new StringBuilder();
                if (clazz instanceof NestedTypeBinding) {
                    NestedTypeBinding nestedBinding = (NestedTypeBinding)clazz;
                    if (nestedBinding.enclosingInstances != null) {
                        for (int i = 0; i < nestedBinding.enclosingInstances.length; ++i) {
                            SyntheticArgumentBinding arg = nestedBinding.enclosingInstances[i];
                            methodSig.append(arg.type.signature());
                        }
                    }
                }
                if (constructorBinding.parameters != null) {
                    for (TypeBinding binding : constructorBinding.parameters) {
                        methodSig.append(binding.signature());
                    }
                }
                if (!methodSig.toString().equals(jsniRef.paramTypesString())) continue;
                return constructorBinding;
            }
            return null;
        }

        private boolean isMethodVisibleToJsniRef(ReferenceBinding jsniClassQualifier, MethodBinding targetMethod) {
            return jsniClassQualifier == targetMethod.declaringClass || targetMethod.isPublic() || !targetMethod.isPrivate() && this.method.binding.declaringClass.getPackage() == targetMethod.declaringClass.getPackage() || targetMethod.isProtected() && targetMethod.declaringClass.isSuperclassOf(this.method.binding.declaringClass);
        }

        private List<MethodBinding> getMatchingMethods(ReferenceBinding clazz, JsniRef jsniRef) {
            assert (jsniRef.isMethod());
            ArrayList<MethodBinding> foundMethods = Lists.newArrayList();
            String methodName = jsniRef.memberName();
            if ("new".equals(methodName)) {
                MethodBinding constructorBinding = this.getMatchingConstructor(clazz, jsniRef);
                if (constructorBinding != null) {
                    foundMethods.add(constructorBinding);
                }
            } else {
                LinkedList<ReferenceBinding> work = Lists.newLinkedList();
                work.add(clazz);
                while (!work.isEmpty()) {
                    ReferenceBinding superclass;
                    ReferenceBinding[] superInterfaces;
                    ReferenceBinding currentClass = (ReferenceBinding)work.remove();
                    block1: for (MethodBinding findMethod : currentClass.getMethods(methodName.toCharArray())) {
                        if (!this.isMethodVisibleToJsniRef(clazz, findMethod) || !this.paramTypesMatch(findMethod, jsniRef)) continue;
                        for (MethodBinding alreadyFound : foundMethods) {
                            if (!this.paramTypesMatch(alreadyFound, findMethod)) continue;
                            break block1;
                        }
                        foundMethods.add(findMethod);
                    }
                    if ((superInterfaces = currentClass.superInterfaces()) != null) {
                        work.addAll(Arrays.asList(superInterfaces));
                    }
                    if ((superclass = currentClass.superclass()) == null) continue;
                    work.add(superclass);
                }
            }
            return foundMethods;
        }

        private boolean paramTypesMatch(MethodBinding method, JsniRef jsniRef) {
            if (jsniRef.matchesAnyOverload()) {
                return true;
            }
            StringBuilder methodSig = new StringBuilder();
            if (method.parameters != null) {
                for (TypeBinding binding : method.parameters) {
                    methodSig.append(binding.signature());
                }
            }
            return methodSig.toString().equals(jsniRef.paramTypesString());
        }

        private boolean paramTypesMatch(MethodBinding thisMethod, MethodBinding thatMethod) {
            int thatParameterCount;
            int thisParameterCount = thisMethod.parameters == null ? 0 : thisMethod.parameters.length;
            int n = thatParameterCount = thatMethod.parameters == null ? 0 : thatMethod.parameters.length;
            if (thisParameterCount != thatParameterCount) {
                return false;
            }
            for (int i = 0; i < thisParameterCount; ++i) {
                TypeBinding thisBinding = thisMethod.parameters[i];
                TypeBinding thatBinding = thatMethod.parameters[i];
                if (new String(thisBinding.signature()).equals(new String(thatBinding.signature()))) continue;
                return false;
            }
            return true;
        }

        private String typeString(TypeBinding type) {
            return String.valueOf(type.shortReadableName());
        }
    }

    private class JsniDeclChecker
    extends SafeASTVisitor
    implements ClassFileConstants {
        private JsniDeclChecker() {
        }

        @Override
        public void endVisit(MethodDeclaration method, ClassScope scope) {
            if (method.isNative()) {
                JsniMethod jsniMethod;
                boolean hasUnsafeLongsAnnotation = JsniReferenceResolver.this.hasUnsafeLongsAnnotation(method, scope);
                if (!hasUnsafeLongsAnnotation) {
                    this.checkDecl(method, scope);
                }
                if ((jsniMethod = (JsniMethod)JsniReferenceResolver.this.jsniMethods.get(method)) != null) {
                    new JsniReferenceResolverVisitor(method, hasUnsafeLongsAnnotation).resolve(jsniMethod.function());
                }
            }
            JsniReferenceResolver.this.suppressWarningsStack.pop();
        }

        @Override
        public void endVisit(TypeDeclaration typeDeclaration, ClassScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.pop();
        }

        @Override
        public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.pop();
        }

        @Override
        public void endVisitValid(TypeDeclaration typeDeclaration, BlockScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.pop();
        }

        @Override
        public boolean visit(MethodDeclaration meth, ClassScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.push(JdtUtil.getSuppressedWarnings(meth.annotations));
            return true;
        }

        @Override
        public boolean visit(TypeDeclaration typeDeclaration, ClassScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.push(JdtUtil.getSuppressedWarnings(typeDeclaration.annotations));
            return true;
        }

        @Override
        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.push(JdtUtil.getSuppressedWarnings(typeDeclaration.annotations));
            return true;
        }

        @Override
        public boolean visitValid(TypeDeclaration typeDeclaration, BlockScope scope) {
            JsniReferenceResolver.this.suppressWarningsStack.push(JdtUtil.getSuppressedWarnings(typeDeclaration.annotations));
            return true;
        }

        private void checkDecl(MethodDeclaration meth, ClassScope scope) {
            TypeReference returnType = meth.returnType;
            if (this.containsLong(returnType, scope)) {
                JsniReferenceResolver.this.longAccessError(meth, "Type '" + this.typeString(returnType) + "' may not be returned from a JSNI method");
            }
            if (meth.arguments == null) {
                return;
            }
            for (Argument arg : meth.arguments) {
                if (!this.containsLong(arg.type, scope)) continue;
                JsniReferenceResolver.this.longAccessError(arg, "Parameter '" + String.valueOf(arg.name) + "': type '" + this.typeString(arg.type) + "' is not safe to access in JSNI code");
            }
        }

        private boolean containsLong(TypeReference type, ClassScope scope) {
            return type != null && JsniReferenceResolver.this.containsLong(type.resolveType(scope));
        }

        private String typeString(TypeReference type) {
            return type.toString();
        }
    }

    public static interface TypeResolver {
        public ReferenceBinding resolveType(String var1);
    }
}

