/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.javac;

import com.google.gwt.core.client.GwtScriptOnly;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.javac.GWTProblem;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.javac.MethodVisitor;
import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.JsParser;
import com.google.gwt.dev.js.JsParserException;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.util.collect.IdentityHashMap;
import com.google.gwt.dev.util.collect.IdentityMaps;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JsniMethodCollector {
    public static Map<MethodDeclaration, JsniMethod> collectJsniMethods(CompilationUnitDeclaration cud, String sourceMapPath, String source, JsScope scope, CorrelationFactory correlator) {
        IdentityHashMap<MethodDeclaration, JsniMethod> jsniMethods = new IdentityHashMap<MethodDeclaration, JsniMethod>();
        new Visitor(source, scope, correlator, jsniMethods).collect(cud, sourceMapPath);
        return IdentityMaps.normalizeUnmodifiable(jsniMethods);
    }

    public static JsFunction parseJsniFunction(AbstractMethodDeclaration method, String unitSource, String enclosingType, SourceInfo baseInfo, JsScope scope) {
        CompilationResult compResult = method.compilationResult;
        int[] indexes = compResult.lineSeparatorPositions;
        int startLine = Util.getLineNumber(method.sourceStart, indexes, 0, indexes.length - 1);
        SourceInfo info = baseInfo.makeChild(SourceOrigin.create(method.sourceStart, method.bodyEnd, startLine, baseInfo.getFileName()));
        String jsniCode = unitSource.substring(method.bodyStart, method.bodyEnd + 1);
        int startPos = jsniCode.indexOf("/*-{");
        int endPos = jsniCode.lastIndexOf("}-*/");
        if (startPos < 0 && endPos < 0) {
            return null;
        }
        if (startPos < 0) {
            JsniMethodCollector.reportJsniError(info, method, "Unable to find start of native block; begin your JavaScript block with: /*-{");
            return null;
        }
        if (endPos < 0) {
            JsniMethodCollector.reportJsniError(info, method, "Unable to find end of native block; terminate your JavaScript block with: }-*/");
            return null;
        }
        jsniCode = jsniCode.substring(startPos += 3, ++endPos);
        StringBuilder functionSource = new StringBuilder("function (");
        boolean first = true;
        if (method.arguments != null) {
            for (Argument arg : method.arguments) {
                if (first) {
                    first = false;
                } else {
                    functionSource.append(',');
                }
                functionSource.append(arg.binding.name);
            }
        }
        functionSource.append(") ");
        int functionHeaderLength = functionSource.length();
        functionSource.append(jsniCode);
        StringReader sr = new StringReader(functionSource.toString());
        int absoluteJsStartPos = method.bodyStart + startPos;
        int absoluteJsEndPos = absoluteJsStartPos + jsniCode.length();
        int jsStartPos = absoluteJsStartPos - functionHeaderLength;
        int jsEndPos = absoluteJsEndPos - functionHeaderLength;
        int jsLine = info.getStartLine() + JsniMethodCollector.countLines(indexes, info.getStartPos(), absoluteJsStartPos);
        SourceInfo jsInfo = baseInfo.makeChild(SourceOrigin.create(jsStartPos, jsEndPos, jsLine, baseInfo.getFileName()));
        try {
            List<JsStatement> result = JsParser.parse(jsInfo, scope, sr);
            JsExprStmt jsExprStmt = (JsExprStmt)result.get(0);
            return (JsFunction)jsExprStmt.getExpression();
        }
        catch (IOException e) {
            throw new InternalCompilerException("Internal error parsing JSNI in '" + enclosingType + '.' + method.toString() + '\'', e);
        }
        catch (JsParserException e) {
            int problemCharPos = JsniMethodCollector.computeAbsoluteProblemPosition(indexes, e.getSourceDetail());
            SourceOrigin errorInfo = SourceOrigin.create(problemCharPos, problemCharPos, e.getSourceDetail().getLine(), info.getFileName());
            String msg = e.getMessage();
            int pos = msg.indexOf(": ");
            msg = msg.substring(pos + 2);
            JsniMethodCollector.reportJsniError(errorInfo, method, msg);
            return null;
        }
    }

    public static void reportJsniError(SourceInfo info, AbstractMethodDeclaration method, String msg) {
        JsniMethodCollector.reportJsniProblem(info, method, msg, 1);
    }

    public static void reportJsniWarning(SourceInfo info, MethodDeclaration method, String msg) {
        JsniMethodCollector.reportJsniProblem(info, method, msg, 0);
    }

    private static int computeAbsoluteProblemPosition(int[] indexes, JsParserException.SourceDetail detail) {
        int line = detail.getLine() - 1;
        if (line == 0) {
            return detail.getLineOffset() - 1;
        }
        int result = indexes[line - 1] + detail.getLineOffset();
        assert (line >= indexes.length || result < indexes[line]);
        return result;
    }

    private static int countLines(int[] indexes, int p1, int p2) {
        assert (p1 >= 0);
        assert (p2 >= 0);
        assert (p1 <= p2);
        int p1line = JsniMethodCollector.findLine(p1, indexes, 0, indexes.length);
        int p2line = JsniMethodCollector.findLine(p2, indexes, 0, indexes.length);
        return p2line - p1line;
    }

    private static int findLine(int pos, int[] indexes, int lo, int tooHi) {
        assert (lo < tooHi);
        if (lo == tooHi - 1) {
            return lo;
        }
        int mid = lo + (tooHi - lo) / 2;
        assert (lo < mid);
        if (pos < indexes[mid]) {
            return JsniMethodCollector.findLine(pos, indexes, lo, mid);
        }
        return JsniMethodCollector.findLine(pos, indexes, mid, tooHi);
    }

    private static String getJsniSignature(String enclosingType, AbstractMethodDeclaration method) {
        return '@' + enclosingType + "::" + MethodVisitor.getMemberSignature(method);
    }

    private static void reportJsniProblem(SourceInfo info, AbstractMethodDeclaration methodDeclaration, String message, int problemSeverity) {
        TreeLogger.HelpInfo jsniHelpInfo = null;
        CompilationResult compResult = methodDeclaration.compilationResult();
        int startColumn = Util.searchColumnNumber(compResult.getLineSeparatorPositions(), info.getStartLine(), info.getStartPos());
        GWTProblem.recordProblem(info, startColumn, compResult, message, jsniHelpInfo, problemSeverity);
    }

    private JsniMethodCollector() {
    }

    private static class Visitor
    extends MethodVisitor {
        private final CorrelationFactory correlator;
        private final Map<MethodDeclaration, JsniMethod> jsniMethods;
        private final JsScope scope;
        private final String source;
        private SourceInfo cudInfo;

        private static boolean isScriptOnly(AbstractMethodDeclaration method) {
            if (method.annotations == null) {
                return false;
            }
            for (Annotation a : method.annotations) {
                ReferenceBinding binding = (ReferenceBinding)a.resolvedType;
                String name = CharOperation.toString(binding.compoundName);
                if (!name.equals(GwtScriptOnly.class.getName())) continue;
                return true;
            }
            return false;
        }

        public Visitor(String source, JsScope scope, CorrelationFactory correlator, Map<MethodDeclaration, JsniMethod> jsniMethods) {
            this.jsniMethods = jsniMethods;
            this.source = source;
            this.scope = scope;
            this.correlator = correlator;
        }

        @Override
        public void collect(CompilationUnitDeclaration cud, String sourceMapPath) {
            this.cudInfo = this.correlator.makeSourceInfo(SourceOrigin.create(0, sourceMapPath));
            super.collect(cud, sourceMapPath);
        }

        @Override
        protected boolean interestingMethod(AbstractMethodDeclaration method) {
            return method.isNative();
        }

        @Override
        protected void processMethod(TypeDeclaration typeDecl, AbstractMethodDeclaration method, String enclosingType) {
            JsFunction jsFunction = JsniMethodCollector.parseJsniFunction(method, this.source, enclosingType, this.cudInfo, this.scope);
            if (jsFunction != null) {
                String jsniSignature = JsniMethodCollector.getJsniSignature(enclosingType, method);
                this.jsniMethods.put((MethodDeclaration)method, new JsniMethodImpl(jsniSignature, jsFunction, Visitor.isScriptOnly(method)));
            }
        }
    }

    private static final class JsniMethodImpl
    extends JsniMethod
    implements Serializable {
        private final JsFunction func;
        private boolean isScriptOnly;
        private final String name;

        public JsniMethodImpl(String name, JsFunction func, boolean isScriptOnly) {
            this.name = name;
            this.func = func;
            this.isScriptOnly = isScriptOnly;
        }

        @Override
        public JsFunction function() {
            return this.func;
        }

        @Override
        public boolean isScriptOnly() {
            return this.isScriptOnly;
        }

        @Override
        public int line() {
            return this.func.getSourceInfo().getStartLine();
        }

        @Override
        public String location() {
            return this.func.getSourceInfo().getFileName();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String[] paramNames() {
            List<JsParameter> params = this.func.getParameters();
            String[] result = new String[params.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = params.get(i).getName().getIdent();
            }
            return result;
        }

        public String toString() {
            return this.func.toString();
        }
    }
}

